/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired(required=false)
    private List<QueryExecutor> executors;
    private static final Pattern EXPR_TOKEN = Pattern.compile("\\(|\\)|[a-zA-Z_][a-zA-Z0-9_=\uff5e{}\\[\\]\".]*|\\d+(\\.\\d+)?|>=|<=|==|!=|>|<|and|or|unless");
    private static final String THRESHOLD = "__threshold__";
    private static final String VALUE = "__value__";

    @Override
    public List<Map<String, Object>> calculate(String datasource, String expr) {
        if (!StringUtils.hasText((String)expr)) {
            throw new IllegalArgumentException("Empty expression");
        }
        if (this.executors == null || this.executors.isEmpty()) {
            throw new IllegalArgumentException("No query executor found");
        }
        QueryExecutor executor = this.executors.stream().filter(e -> e.support(datasource)).findFirst().orElse(null);
        if (executor == null) {
            throw new IllegalArgumentException("Unsupported datasource: " + datasource);
        }
        expr = expr.replaceAll("\\s+", " ");
        try {
            return this.evaluate(expr, executor);
        }
        catch (Exception e2) {
            log.error("Error executing query on datasource {}: {}", (Object)datasource, (Object)e2.getMessage());
            throw new RuntimeException("Query execution failed", e2);
        }
    }

    private List<Map<String, Object>> evaluate(String expr, QueryExecutor executor) {
        Stack<List<Map<String, Object>>> values = new Stack<List<Map<String, Object>>>();
        Stack<String> operators = new Stack<String>();
        Matcher matcher = EXPR_TOKEN.matcher(expr);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group());
        }
        for (String token : tokens) {
            if (token.equals("(")) {
                operators.push(token);
                continue;
            }
            if (token.equals(")")) {
                while (!operators.isEmpty() && !((String)operators.peek()).equals("(")) {
                    this.applyOperator(values, (String)operators.pop());
                }
                operators.pop();
                continue;
            }
            if (token.matches(">=|<=|==|!=|>|<")) {
                operators.push(token);
                continue;
            }
            if (token.equals("and") || token.equals("or") || token.equals("unless")) {
                while (!operators.isEmpty() && this.precedence((String)operators.peek()) >= this.precedence(token)) {
                    this.applyOperator(values, (String)operators.pop());
                }
                operators.push(token);
                continue;
            }
            if (token.matches("\\d+(\\.\\d+)?")) {
                double value = Double.parseDouble(token);
                ArrayList<Map<String, Double>> numAsList = new ArrayList<Map<String, Double>>();
                numAsList.add(Map.of(THRESHOLD, value));
                values.push(numAsList);
                continue;
            }
            if (!token.matches("[a-zA-Z_][a-zA-Z0-9_=\uff5e{}\\[\\]\".]*")) continue;
            List results = executor.execute(token);
            values.push(results);
        }
        while (!operators.isEmpty()) {
            this.applyOperator(values, (String)operators.pop());
        }
        return values.isEmpty() ? new LinkedList() : (List)values.pop();
    }

    private int precedence(String op) {
        return switch (op) {
            case "or" -> 1;
            case "unless" -> 2;
            case "and" -> 3;
            case ">", "<", ">=", "<=", "==", "!=" -> 4;
            default -> 0;
        };
    }

    private void applyOperator(Stack<List<Map<String, Object>>> values, String op) {
        if (values.size() < 2) {
            return;
        }
        List<Map<String, Object>> rightOperand = values.pop();
        List<Map<String, Object>> leftOperand = values.pop();
        if (rightOperand.size() == 1 && rightOperand.get(0).containsKey(THRESHOLD)) {
            double threshold = (Double)rightOperand.get(0).get(THRESHOLD);
            ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
            for (Map<String, Object> item : leftOperand) {
                Object queryValues = item.get(VALUE);
                if (queryValues == null) continue;
                Object matchValue = this.evaluateCondition(queryValues, op, threshold);
                item.put(VALUE, matchValue);
                result.add(new HashMap<String, Object>(item));
            }
            if (!result.isEmpty()) {
                values.push(result);
            }
            return;
        }
        Map<String, Object> leftMap = null;
        boolean leftMatch = false;
        Map<String, Object> rightMap = null;
        boolean rightMatch = false;
        switch (op) {
            case "and": {
                for (Map<String, Object> item : leftOperand) {
                    if (leftMap == null) {
                        leftMap = item;
                    }
                    if (item.get(VALUE) == null) continue;
                    leftMap = item;
                    leftMatch = true;
                    break;
                }
                for (Map<String, Object> item : rightOperand) {
                    if (rightMap == null) {
                        rightMap = item;
                    }
                    if (item.get(VALUE) == null) continue;
                    rightMap = item;
                    rightMatch = true;
                    break;
                }
                if (leftMatch && rightMatch) {
                    rightMap.putAll(leftMap);
                    values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                    break;
                }
                if (leftMap != null) {
                    leftMap.put(VALUE, null);
                    values.push(new LinkedList<Map<String, Object>>(List.of(leftMap)));
                    break;
                }
                if (rightMap == null) break;
                rightMap.put(VALUE, null);
                values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                break;
            }
            case "or": {
                for (Map<String, Object> item : leftOperand) {
                    if (leftMap == null) {
                        leftMap = item;
                    }
                    if (item.get(VALUE) == null) continue;
                    leftMap = item;
                    leftMatch = true;
                    break;
                }
                for (Map<String, Object> item : rightOperand) {
                    if (rightMap == null) {
                        rightMap = item;
                    }
                    if (item.get(VALUE) == null) continue;
                    rightMap = item;
                    rightMatch = true;
                    break;
                }
                if (leftMatch && rightMatch) {
                    rightMap.putAll(leftMap);
                    values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                    break;
                }
                if (leftMatch) {
                    values.push(new LinkedList<Map<String, Object>>(List.of(leftMap)));
                    break;
                }
                if (rightMatch) {
                    values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                    break;
                }
                if (leftMap != null && rightMap != null) {
                    rightMap.putAll(leftMap);
                    values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                    break;
                }
                if (leftMap != null) {
                    values.push(new LinkedList<Map<String, Object>>(List.of(leftMap)));
                    break;
                }
                if (rightMap == null) break;
                values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                break;
            }
            case "unless": {
                for (Map<String, Object> item : leftOperand) {
                    if (leftMap == null) {
                        leftMap = item;
                    }
                    if (item.get(VALUE) == null) continue;
                    leftMap = item;
                    leftMatch = true;
                    break;
                }
                for (Map<String, Object> item : rightOperand) {
                    if (rightMap == null) {
                        rightMap = item;
                    }
                    if (item.get(VALUE) == null) continue;
                    rightMap = item;
                    rightMatch = true;
                    break;
                }
                if (leftMatch && !rightMatch) {
                    values.push(new LinkedList<Map<String, Object>>(List.of(leftMap)));
                    break;
                }
                if (leftMap != null) {
                    leftMap.put(VALUE, null);
                    values.push(new LinkedList<Map<String, Object>>(List.of(leftMap)));
                    break;
                }
                if (rightMap == null) break;
                rightMap.put(VALUE, null);
                values.push(new LinkedList<Map<String, Object>>(List.of(rightMap)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator: " + op);
            }
        }
    }

    private Object evaluateCondition(Object value, String operator, Double threshold) {
        switch (operator) {
            case ">": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).max(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue > threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) > threshold ? value : null;
            }
            case ">=": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).max(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue >= threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) >= threshold ? value : null;
            }
            case "<": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).min(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue < threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) < threshold ? value : null;
            }
            case "<=": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).min(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue <= threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) <= threshold ? value : null;
            }
            case "==": {
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v2 : values) {
                        if (!v2.equals(threshold)) continue;
                        return v2;
                    }
                    return null;
                }
                return value.equals(threshold) ? value : null;
            }
            case "!=": {
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v3 : values) {
                        if (!v3.equals(threshold)) continue;
                        return null;
                    }
                    return value;
                }
                return value.equals(threshold) ? null : value;
            }
        }
        return null;
    }

    public void setExecutors(List<QueryExecutor> mockExecutor) {
        this.executors = mockExecutor;
    }
}

