/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.dao.GroupAlertDao;
import org.apache.hertzbeat.alert.dao.SingleAlertDao;
import org.apache.hertzbeat.alert.notice.AlertStoreHandler;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
final class DbAlertStoreHandlerImpl
implements AlertStoreHandler {
    private static final Logger log = LoggerFactory.getLogger(DbAlertStoreHandlerImpl.class);
    private final GroupAlertDao groupAlertDao;
    private final SingleAlertDao singleAlertDao;

    @Override
    public GroupAlert store(GroupAlert groupAlert) {
        if (groupAlert == null || groupAlert.getAlerts() == null || groupAlert.getAlerts().isEmpty()) {
            log.error("The Group Alerts is empty, ignore store");
            return groupAlert;
        }
        GroupAlert existGroupAlert = this.groupAlertDao.findByGroupKey(groupAlert.getGroupKey());
        HashSet<String> alertFingerprints = new HashSet<String>(8);
        List originalAlerts = groupAlert.getAlerts();
        ArrayList<SingleAlert> newAlerts = new ArrayList<SingleAlert>();
        for (SingleAlert singleAlert : originalAlerts) {
            SingleAlert existAlert = this.singleAlertDao.findByFingerprint(singleAlert.getFingerprint());
            if (existAlert != null) {
                singleAlert.setId(existAlert.getId());
                singleAlert.setGmtCreate(existAlert.getGmtCreate());
                if ("firing".equals(singleAlert.getStatus())) {
                    if (!"resolved".equals(existAlert.getStatus())) {
                        singleAlert.setStartAt(existAlert.getStartAt());
                        int triggerTimes = Optional.ofNullable(existAlert.getTriggerTimes()).orElse(1) + Optional.ofNullable(singleAlert.getTriggerTimes()).orElse(1);
                        singleAlert.setTriggerTimes(Integer.valueOf(triggerTimes));
                    }
                } else if ("resolved".equals(singleAlert.getStatus())) {
                    if (singleAlert.getEndAt() == null) {
                        singleAlert.setEndAt(Long.valueOf(System.currentTimeMillis()));
                    }
                    singleAlert.setStartAt(existAlert.getStartAt());
                    singleAlert.setActiveAt(existAlert.getActiveAt());
                    singleAlert.setTriggerTimes(existAlert.getTriggerTimes());
                }
            }
            SingleAlert savedSingleAlert = (SingleAlert)this.singleAlertDao.save(singleAlert);
            newAlerts.add(savedSingleAlert);
            alertFingerprints.add(savedSingleAlert.getFingerprint());
        }
        groupAlert.setAlerts(newAlerts);
        if (existGroupAlert != null) {
            Map<String, String> commonAnnotations;
            Map existCommonAnnotations;
            Map<String, String> commonLabels;
            List existFingerprints = existGroupAlert.getAlertFingerprints();
            if (existFingerprints != null) {
                alertFingerprints.addAll(existFingerprints);
            }
            groupAlert.setId(existGroupAlert.getId());
            groupAlert.setGmtCreate(existGroupAlert.getGmtCreate());
            Map existCommonLabels = existGroupAlert.getCommonLabels();
            if (existCommonLabels != null && (commonLabels = groupAlert.getCommonLabels()) != null) {
                commonLabels = commonLabels.entrySet().stream().filter(entry -> existCommonLabels.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                groupAlert.setCommonLabels(commonLabels);
            }
            if ((existCommonAnnotations = existGroupAlert.getCommonAnnotations()) != null && (commonAnnotations = groupAlert.getCommonAnnotations()) != null) {
                commonAnnotations = commonAnnotations.entrySet().stream().filter(entry -> existCommonAnnotations.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                groupAlert.setCommonAnnotations(commonAnnotations);
            }
        }
        groupAlert.setAlertFingerprints(alertFingerprints.stream().toList());
        GroupAlert savedGroupAlert = (GroupAlert)this.groupAlertDao.save(groupAlert);
        savedGroupAlert.setAlerts(groupAlert.getAlerts());
        return savedGroupAlert;
    }

    public DbAlertStoreHandlerImpl(GroupAlertDao groupAlertDao, SingleAlertDao singleAlertDao) {
        this.groupAlertDao = groupAlertDao;
        this.singleAlertDao = singleAlertDao;
    }
}

