/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.alert.util.AlertTemplateUtil;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PeriodicAlertCalculator {
    private static final Logger log = LoggerFactory.getLogger(PeriodicAlertCalculator.class);
    private static final String VALUE = "__value__";
    private static final String TIMESTAMP = "__timestamp__";
    private final DataSourceService dataSourceService;
    private final AlarmCommonReduce alarmCommonReduce;
    private final Map<String, SingleAlert> pendingAlertMap;
    private final Map<String, SingleAlert> firingAlertMap;

    public PeriodicAlertCalculator(DataSourceService dataSourceService, AlarmCommonReduce alarmCommonReduce) {
        this.dataSourceService = dataSourceService;
        this.alarmCommonReduce = alarmCommonReduce;
        this.pendingAlertMap = new ConcurrentHashMap<String, SingleAlert>(8);
        this.firingAlertMap = new ConcurrentHashMap<String, SingleAlert>(8);
    }

    public void calculate(AlertDefine rule) {
        if (!rule.isEnable() || StringUtils.isEmpty((CharSequence)rule.getExpr())) {
            log.error("Periodic rule {} is disabled or expression is empty", (Object)rule.getName());
            return;
        }
        long currentTimeMilli = System.currentTimeMillis();
        try {
            try {
                List<Map<String, Object>> results = this.dataSourceService.calculate(rule.getDatasource(), rule.getExpr());
                if (CollectionUtils.isEmpty(results)) {
                    return;
                }
                for (Map<String, Object> result : results) {
                    HashMap<String, String> fingerPrints = new HashMap<String, String>(8);
                    fingerPrints.put("alertname", rule.getName());
                    fingerPrints.putAll(rule.getLabels());
                    for (Map.Entry<String, Object> entry : result.entrySet()) {
                        if (entry.getValue() == null || VALUE.equals(entry.getKey()) || TIMESTAMP.equals(entry.getKey())) continue;
                        fingerPrints.put(entry.getKey(), entry.getValue().toString());
                    }
                    if (result.get(VALUE) == null) {
                        this.handleRecoveredAlert(fingerPrints);
                        continue;
                    }
                    HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
                    fieldValueMap.putAll(rule.getLabels());
                    fieldValueMap.put("alertname", rule.getName());
                    for (Map.Entry<String, Object> entry : result.entrySet()) {
                        if (entry.getValue() == null) continue;
                        fieldValueMap.put(entry.getKey(), entry.getValue());
                    }
                    this.afterThresholdRuleMatch(currentTimeMilli, fingerPrints, fieldValueMap, rule);
                }
            }
            catch (Exception ignored) {
                return;
            }
        }
        catch (Exception e) {
            log.error("Calculate periodic rule {} failed: {}", (Object)rule.getName(), (Object)e.getMessage());
        }
    }

    private void afterThresholdRuleMatch(long currentTimeMilli, Map<String, String> fingerPrints, Map<String, Object> fieldValueMap, AlertDefine define) {
        int requiredTimes;
        String fingerprint = this.calculateFingerprint(fingerPrints);
        SingleAlert existingAlert = this.pendingAlertMap.get(fingerprint);
        HashMap<String, String> labels = new HashMap<String, String>(8);
        fieldValueMap.putAll(define.getLabels());
        labels.putAll(fingerPrints);
        int n = requiredTimes = define.getTimes() == null ? 1 : define.getTimes();
        if (existingAlert == null) {
            SingleAlert newAlert = SingleAlert.builder().labels(labels).annotations(define.getAnnotations()).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("pending").triggerTimes(Integer.valueOf(1)).startAt(Long.valueOf(currentTimeMilli)).activeAt(Long.valueOf(currentTimeMilli)).build();
            if (requiredTimes <= 1) {
                newAlert.setStatus("firing");
                this.firingAlertMap.put(fingerprint, newAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(newAlert.clone());
            } else {
                this.pendingAlertMap.put(fingerprint, newAlert);
            }
        } else {
            existingAlert.setTriggerTimes(Integer.valueOf(existingAlert.getTriggerTimes() + 1));
            existingAlert.setActiveAt(Long.valueOf(currentTimeMilli));
            if (existingAlert.getStatus().equals("pending") && existingAlert.getTriggerTimes() >= requiredTimes) {
                this.pendingAlertMap.remove(fingerprint);
                existingAlert.setStatus("firing");
                this.firingAlertMap.put(fingerprint, existingAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(existingAlert.clone());
            }
        }
    }

    private void handleRecoveredAlert(Map<String, String> fingerprints) {
        String fingerprint = this.calculateFingerprint(fingerprints);
        SingleAlert firingAlert = this.firingAlertMap.remove(fingerprint);
        if (firingAlert != null) {
            firingAlert.setTriggerTimes(Integer.valueOf(1));
            firingAlert.setEndAt(Long.valueOf(System.currentTimeMillis()));
            firingAlert.setStatus("resolved");
            this.alarmCommonReduce.reduceAndSendAlarm(firingAlert.clone());
        }
        this.pendingAlertMap.remove(fingerprint);
    }

    private String calculateFingerprint(Map<String, String> fingerPrints) {
        List<String> keyList = fingerPrints.keySet().stream().filter(Objects::nonNull).sorted().toList();
        List<String> valueList = fingerPrints.values().stream().filter(Objects::nonNull).sorted().toList();
        return Arrays.hashCode(keyList.toArray(new String[0])) + "-" + Arrays.hashCode(valueList.toArray(new String[0]));
    }
}

