/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.entity.sd.ConnectionConfig;
import org.apache.hertzbeat.common.entity.sd.ServiceDiscoveryResponseEntity;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(HttpSdCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        ArrayList configList = Lists.newArrayList();
        HttpUriRequest request = RequestBuilder.get().setUri(metrics.getSdProtocol().getSdSource()).build();
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request);){
            TypeReference<List<ServiceDiscoveryResponseEntity>> typeReference;
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn("Failed to fetch sd...");
                builder.setMsg("StatusCode " + statusCode);
                builder.setCode(CollectRep.Code.FAIL);
                return;
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            List responseEntityList = (List)JsonUtil.fromJson((String)responseBody, (TypeReference)(typeReference = new TypeReference<List<ServiceDiscoveryResponseEntity>>(){}));
            if (CollectionUtils.isEmpty((Collection)responseEntityList)) {
                return;
            }
            responseEntityList.stream().filter(entity -> !CollectionUtils.isEmpty((Collection)entity.getTarget())).forEach(responseEntity -> this.convertTarget(configList, (ServiceDiscoveryResponseEntity)responseEntity));
            configList.forEach(config -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumn(config.getHost());
                valueRowBuilder.addColumn(config.getPort());
                builder.addValueRow(valueRowBuilder.build());
            });
        }
        catch (IOException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("Failed to fetch sd... {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    private void convertTarget(List<ConnectionConfig> configList, ServiceDiscoveryResponseEntity responseEntity) {
        responseEntity.getTarget().stream().filter(StringUtils::isNotBlank).forEach(fetchedTarget -> this.addConfig(configList, (String)fetchedTarget));
    }

    private void addConfig(List<ConnectionConfig> configList, String fetchedTarget) {
        for (String url : fetchedTarget.split(",")) {
            String[] split = url.split(":");
            if (split.length != 2) continue;
            configList.add(ConnectionConfig.builder().host(split[0]).port(split[1]).build());
        }
    }

    public String supportProtocol() {
        return "httpsd";
    }
}

