/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.prometheus;

import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hertzbeat.collector.collect.prometheus.parser.MetricFamily;
import org.apache.hertzbeat.collector.collect.prometheus.parser.TextParser;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.PrometheusProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PrometheusAutoCollectImpl {
    private static final Logger log = LoggerFactory.getLogger(PrometheusAutoCollectImpl.class);
    private final Set<Integer> defaultSuccessStatusCodes = Stream.of(200, 201, 202, 300, 301, 302).collect(Collectors.toSet());

    /*
     * Exception decompiling
     */
    public List<CollectRep.MetricsData> collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String supportProtocol() {
        return "prometheus";
    }

    private void validateParams(Metrics metrics) throws Exception {
        if (metrics == null || metrics.getPrometheus() == null) {
            throw new Exception("Prometheus collect must has prometheus params");
        }
        PrometheusProtocol protocol = metrics.getPrometheus();
        if (protocol.getPath() == null || !StringUtils.hasText((String)protocol.getPath()) || !protocol.getPath().startsWith("/")) {
            protocol.setPath((String)(protocol.getPath() == null ? "/" : "/" + protocol.getPath().trim()));
        }
    }

    private List<CollectRep.MetricsData> parseResponseByPrometheusExporter(String resp, List<String> aliasFields, CollectRep.MetricsData.Builder builder) {
        Map<String, MetricFamily> metricFamilyMap = TextParser.textToMetricFamilies(resp);
        LinkedList<CollectRep.MetricsData> metricsDataList = new LinkedList<CollectRep.MetricsData>();
        for (Map.Entry<String, MetricFamily> entry : metricFamilyMap.entrySet()) {
            builder.clearFields();
            builder.clearValues();
            String metricsName = entry.getKey();
            builder.setMetrics(metricsName);
            MetricFamily metricFamily = entry.getValue();
            if (metricFamily.getMetricList().isEmpty()) continue;
            LinkedList metricsFields = new LinkedList();
            for (int index = 0; index < metricFamily.getMetricList().size(); ++index) {
                MetricFamily.Metric metric = metricFamily.getMetricList().get(index);
                if (index == 0) {
                    metric.getLabels().forEach(label -> {
                        metricsFields.add(label.getName());
                        builder.addField(CollectRep.Field.newBuilder().setName(label.getName()).setType(1).setLabel(true).build());
                    });
                    builder.addField(CollectRep.Field.newBuilder().setName("value").setType(0).setLabel(false).build());
                }
                Map<String, String> labelMap = metric.getLabels().stream().collect(Collectors.toMap(MetricFamily.Label::getName, MetricFamily.Label::getValue));
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String field : metricsFields) {
                    String fieldValue = labelMap.get(field);
                    valueRowBuilder.addColumn(fieldValue == null ? "&nbsp;" : fieldValue);
                }
                valueRowBuilder.addColumn(String.valueOf(metric.getValue()));
                builder.addValueRow(valueRowBuilder.build());
            }
            metricsDataList.add(builder.build());
        }
        return metricsDataList;
    }

    public HttpContext createHttpContext(PrometheusProtocol protocol) {
        PrometheusProtocol.Authorization auth = protocol.getAuthorization();
        if (auth != null && "Digest Auth".equals(auth.getType())) {
            HttpClientContext clientContext = new HttpClientContext();
            if (StringUtils.hasText((String)auth.getDigestAuthUsername()) && StringUtils.hasText((String)auth.getDigestAuthPassword())) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(auth.getDigestAuthUsername(), auth.getDigestAuthPassword());
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(new HttpHost(protocol.getHost(), Integer.parseInt(protocol.getPort())), (AuthScheme)new DigestScheme());
                clientContext.setCredentialsProvider((CredentialsProvider)provider);
                clientContext.setAuthCache((AuthCache)authCache);
                return clientContext;
            }
        }
        return null;
    }

    public HttpUriRequest createHttpRequest(PrometheusProtocol protocol) {
        RequestBuilder requestBuilder = RequestBuilder.get();
        Map params = protocol.getParams();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry param : params.entrySet()) {
                if (!StringUtils.hasText((String)((String)param.getValue()))) continue;
                requestBuilder.addParameter((String)param.getKey(), (String)param.getValue());
            }
        }
        requestBuilder.addHeader("Connection", "Keep-Alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        Map headers = protocol.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                if (!StringUtils.hasText((String)((String)entry.getValue()))) continue;
                requestBuilder.addHeader(CollectUtil.replaceUriSpecialChar((String)((String)entry.getKey())), CollectUtil.replaceUriSpecialChar((String)((String)entry.getValue())));
            }
        }
        requestBuilder.addHeader("Accept", "text/plain");
        if (protocol.getAuthorization() != null) {
            PrometheusProtocol.Authorization authorization = protocol.getAuthorization();
            if ("Bearer Token".equalsIgnoreCase(authorization.getType())) {
                String string = "Bearer " + authorization.getBearerTokenToken();
                requestBuilder.addHeader("Authorization", string);
            } else if ("Basic Auth".equals(authorization.getType()) && StringUtils.hasText((String)authorization.getBasicAuthUsername()) && StringUtils.hasText((String)authorization.getBasicAuthPassword())) {
                String string = authorization.getBasicAuthUsername() + ":" + authorization.getBasicAuthPassword();
                String encodedAuth = Base64Util.encode((String)string);
                requestBuilder.addHeader("Authorization", "Basic " + encodedAuth);
            }
        }
        if (StringUtils.hasLength((String)protocol.getPayload())) {
            requestBuilder.setEntity((HttpEntity)new StringEntity(protocol.getPayload(), StandardCharsets.UTF_8));
        }
        String uri = CollectUtil.replaceUriSpecialChar((String)protocol.getPath());
        if (IpDomainUtil.isHasSchema((String)protocol.getHost())) {
            requestBuilder.setUri(protocol.getHost() + ":" + protocol.getPort() + uri);
        } else {
            String string = IpDomainUtil.checkIpAddressType((String)protocol.getHost());
            String baseUri = "ipv6".equals(string) ? String.format("[%s]:%s%s", protocol.getHost(), protocol.getPort(), uri) : String.format("%s:%s%s", protocol.getHost(), protocol.getPort(), uri);
            boolean ssl = Boolean.parseBoolean(protocol.getSsl());
            if (ssl) {
                requestBuilder.setUri("https://" + baseUri);
            } else {
                requestBuilder.setUri("http://" + baseUri);
            }
        }
        int n = CollectUtil.getTimeout((String)protocol.getTimeout(), (int)0);
        if (n > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(n).setSocketTimeout(n).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    public static PrometheusAutoCollectImpl getInstance() {
        return SingleInstance.INSTANCE;
    }

    private static class SingleInstance {
        private static final PrometheusAutoCollectImpl INSTANCE = new PrometheusAutoCollectImpl();

        private SingleInstance() {
        }
    }
}

