/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.push.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.push.service.PushGatewayService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Metrics Push Gateway API")
@RestController
@RequestMapping(value={"/api/push/pushgateway"})
public class PushGatewayController {
    @Autowired
    private PushGatewayService pushGatewayService;

    @PostMapping
    @Operation(summary="Push metric data to hertzbeat pushgateway", description="Push metric data to hertzbeat pushgateway")
    public ResponseEntity<Message<Void>> pushMetrics(HttpServletRequest request) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        boolean result = this.pushGatewayService.pushMetricsData((InputStream)inputStream);
        if (result) {
            return ResponseEntity.ok((Object)Message.success((String)"Push success"));
        }
        return ResponseEntity.ok((Object)Message.success((String)"Push failed"));
    }
}

