/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.kafka;

import java.util.HashSet;
import java.util.Set;

public enum SupportedCommand {
    TOPIC_DESCRIBE("topic-describe"),
    TOPIC_LIST("topic-list"),
    TOPIC_OFFSET("topic-offset");

    private static Set<String> SUPPORTED_COMMAND;
    private final String key;

    private SupportedCommand(String command) {
        this.key = command;
    }

    public String getCommand() {
        return this.key;
    }

    public static boolean isKafkaCommand(String str) {
        return SUPPORTED_COMMAND.contains(str);
    }

    public static SupportedCommand fromCommand(String command) {
        for (SupportedCommand supportedCommand : SupportedCommand.values()) {
            if (!supportedCommand.getCommand().equals(command)) continue;
            return supportedCommand;
        }
        throw new IllegalArgumentException("No enum constant for command: " + command);
    }

    static {
        SUPPORTED_COMMAND = new HashSet<String>();
        for (SupportedCommand placeholder : SupportedCommand.values()) {
            SUPPORTED_COMMAND.add(placeholder.getCommand());
        }
    }
}

