/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="memory", matchIfMissing=true)
@Primary
public class InMemoryCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(InMemoryCommonDataQueue.class);
    private final LinkedBlockingQueue<Alert> alertDataQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToPersistentStorageQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToRealTimeStorageQueue = new LinkedBlockingQueue();

    public Map<String, Integer> getQueueSizeMetricsInfo() {
        HashMap<String, Integer> metrics = new HashMap<String, Integer>(8);
        metrics.put("alertDataQueue", this.alertDataQueue.size());
        metrics.put("metricsDataToAlertQueue", this.metricsDataToAlertQueue.size());
        metrics.put("metricsDataToPersistentStorageQueue", this.metricsDataToPersistentStorageQueue.size());
        metrics.put("metricsDataToMemoryStorageQueue", this.metricsDataToRealTimeStorageQueue.size());
        return metrics;
    }

    @Override
    public void sendAlertsData(Alert alert) {
        this.alertDataQueue.offer(alert);
    }

    @Override
    public Alert pollAlertsData() throws InterruptedException {
        return this.alertDataQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.metricsDataToAlertQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToPersistentStorage() throws InterruptedException {
        return this.metricsDataToPersistentStorageQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToRealTimeStorage() throws InterruptedException {
        return this.metricsDataToRealTimeStorageQueue.take();
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        this.metricsDataToAlertQueue.offer(metricsData);
        this.metricsDataToPersistentStorageQueue.offer(metricsData);
        this.metricsDataToRealTimeStorageQueue.offer(metricsData);
    }

    public void destroy() {
        this.alertDataQueue.clear();
        this.metricsDataToAlertQueue.clear();
        this.metricsDataToPersistentStorageQueue.clear();
        this.metricsDataToRealTimeStorageQueue.clear();
    }
}

