/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_notice_template")
@Schema(description="Notify Policy Template")
@EntityListeners(value={AuditingEntityListener.class})
public class NoticeTemplate {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Notification Template Entity Primary Key Index ID", description="Notification Template Entity Primary Key Index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Template name", description="Template name", example="dispatch-1", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotBlank
    private @Size(max=100) @NotBlank String name;
    @Schema(title="Notification information method: 0-SMS 1-Email 2-webhook 3-WeChat Official Account 4-Enterprise WeChat Robot 5-DingTalk Robot 6-FeiShu Robot 7-Telegram Bot 8-SlackWebHook 9-Discord Bot 10-Enterprise WeChat app message", description="Notification information method: 0-SMS 1-Email 2-webhook 3-WeChat Official Account 4-Enterprise WeChat Robot 5-DingTalk Robot 6-FeiShu Robot 7-Telegram Bot 8-SlackWebHook 9-Discord Bot 10-Enterprise WeChat app message", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @NotNull
    private @Min(value=0L) @NotNull Byte type;
    @Schema(title="Is it a preset template: true- preset template false- custom template.", description="Is it a preset template: true- preset template false- custom template.", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(columnDefinition="boolean default false")
    private boolean preset = false;
    @Schema(title="Template content", description="Template content", example="[${title}]\n${targetLabel} : ${target}\n<#if (monitorId??)>${monitorIdLabel} : ${monitorId} </#if>\n<#if (monitorName??)>${monitorNameLabel} : ${monitorName} </#if>\n<#if (monitorHost??)>${monitorHostLabel} : ${monitorHost} </#if>\n${priorityLabel} : ${priority}\n${triggerTimeLabel} : ${triggerTime}\n${contentLabel} : ${content}", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=60000)
    @Lob
    @NotBlank
    private @Size(max=60000) @NotBlank String content;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static NoticeTemplateBuilder builder() {
        return new NoticeTemplateBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Byte getType() {
        return this.type;
    }

    public boolean isPreset() {
        return this.preset;
    }

    public String getContent() {
        return this.content;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public void setPreset(boolean preset) {
        this.preset = preset;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoticeTemplate)) {
            return false;
        }
        NoticeTemplate other = (NoticeTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreset() != other.isPreset()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Byte this$type = this.getType();
        Byte other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NoticeTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreset() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Byte $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "NoticeTemplate(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", preset=" + this.isPreset() + ", content=" + this.getContent() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public NoticeTemplate(Long id, String name, Byte type, boolean preset, String content, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.preset = preset;
        this.content = content;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public NoticeTemplate() {
    }

    public static class NoticeTemplateBuilder {
        private Long id;
        private String name;
        private Byte type;
        private boolean preset;
        private String content;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        NoticeTemplateBuilder() {
        }

        public NoticeTemplateBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public NoticeTemplateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NoticeTemplateBuilder type(Byte type) {
            this.type = type;
            return this;
        }

        public NoticeTemplateBuilder preset(boolean preset) {
            this.preset = preset;
            return this;
        }

        public NoticeTemplateBuilder content(String content) {
            this.content = content;
            return this;
        }

        public NoticeTemplateBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public NoticeTemplateBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public NoticeTemplateBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public NoticeTemplateBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public NoticeTemplate build() {
            return new NoticeTemplate(this.id, this.name, this.type, this.preset, this.content, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "NoticeTemplate.NoticeTemplateBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", preset=" + this.preset + ", content=" + this.content + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

