/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.manager.JsonLongListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonMapListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonTagListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Schema(description="Bulletin")
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="hzb_bulletin")
public class Bulletin {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(description="Bulletin ID", example="1")
    private Long id;
    @Schema(description="Bulletin Name", example="Bulletin1", accessMode=Schema.AccessMode.READ_WRITE)
    private String name;
    @Schema(description="Monitor IDs", example="1")
    @Column(name="monitor_ids", length=4096)
    @Convert(converter=JsonLongListAttributeConverter.class)
    private List<Long> monitorIds;
    @Schema(description="Monitor Type eg: jvm, tomcat", example="jvm", accessMode=Schema.AccessMode.READ_WRITE)
    private String app;
    @Schema(description="Monitor Fields")
    @Column(name="fields", length=4096)
    @Convert(converter=JsonMapListAttributeConverter.class)
    private Map<String, List<String>> fields;
    @Schema(description="Tags(status:success,env:prod)", example="{name: key1, value: value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonTagListAttributeConverter.class)
    @Column(length=2048)
    private List<TagItem> tags;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_WRITE)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_WRITE)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="2024-07-02T20:09:34.903217", accessMode=Schema.AccessMode.READ_WRITE)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="2024-07-02T20:09:34.903217", accessMode=Schema.AccessMode.READ_WRITE)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static BulletinBuilder builder() {
        return new BulletinBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Long> getMonitorIds() {
        return this.monitorIds;
    }

    public String getApp() {
        return this.app;
    }

    public Map<String, List<String>> getFields() {
        return this.fields;
    }

    public List<TagItem> getTags() {
        return this.tags;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMonitorIds(List<Long> monitorIds) {
        this.monitorIds = monitorIds;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setFields(Map<String, List<String>> fields) {
        this.fields = fields;
    }

    public void setTags(List<TagItem> tags) {
        this.tags = tags;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bulletin)) {
            return false;
        }
        Bulletin other = (Bulletin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Long> this$monitorIds = this.getMonitorIds();
        List<Long> other$monitorIds = other.getMonitorIds();
        if (this$monitorIds == null ? other$monitorIds != null : !((Object)this$monitorIds).equals(other$monitorIds)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        Map<String, List<String>> this$fields = this.getFields();
        Map<String, List<String>> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List<TagItem> this$tags = this.getTags();
        List<TagItem> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bulletin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Long> $monitorIds = this.getMonitorIds();
        result = result * 59 + ($monitorIds == null ? 43 : ((Object)$monitorIds).hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        Map<String, List<String>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<TagItem> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "Bulletin(id=" + this.getId() + ", name=" + this.getName() + ", monitorIds=" + this.getMonitorIds() + ", app=" + this.getApp() + ", fields=" + this.getFields() + ", tags=" + this.getTags() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public Bulletin(Long id, String name, List<Long> monitorIds, String app, Map<String, List<String>> fields, List<TagItem> tags, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.monitorIds = monitorIds;
        this.app = app;
        this.fields = fields;
        this.tags = tags;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public Bulletin() {
    }

    public static class BulletinBuilder {
        private Long id;
        private String name;
        private List<Long> monitorIds;
        private String app;
        private Map<String, List<String>> fields;
        private List<TagItem> tags;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        BulletinBuilder() {
        }

        public BulletinBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public BulletinBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BulletinBuilder monitorIds(List<Long> monitorIds) {
            this.monitorIds = monitorIds;
            return this;
        }

        public BulletinBuilder app(String app) {
            this.app = app;
            return this;
        }

        public BulletinBuilder fields(Map<String, List<String>> fields) {
            this.fields = fields;
            return this;
        }

        public BulletinBuilder tags(List<TagItem> tags) {
            this.tags = tags;
            return this;
        }

        public BulletinBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public BulletinBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public BulletinBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public BulletinBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public Bulletin build() {
            return new Bulletin(this.id, this.name, this.monitorIds, this.app, this.fields, this.tags, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "Bulletin.BulletinBuilder(id=" + this.id + ", name=" + this.name + ", monitorIds=" + this.monitorIds + ", app=" + this.app + ", fields=" + this.fields + ", tags=" + this.tags + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

