/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoServerUnavailableException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.ConnectionCommonCache;
import org.apache.hertzbeat.collector.collect.mongodb.MongodbConnect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.MongodbProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MongodbSingleCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(MongodbSingleCollectImpl.class);
    private static final String[] SUPPORTED_MONGODB_DIAGNOSTIC_COMMANDS = new String[]{"buildInfo", "collStats", "connPoolStats", "connectionStatus", "dbHash", "dbStats", "explain", "features", "getCmdLineOpts", "getLog", "hostInfo", "listCommands", "profile", "serverStatus", "top", "validateDBMetadata"};
    private final ConnectionCommonCache<CacheIdentifier, MongodbConnect> connectionCommonCache = new ConnectionCommonCache();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.isTrue((metrics != null && metrics.getMongodb() != null ? 1 : 0) != 0, (String)"Mongodb collect must has mongodb params");
        MongodbProtocol mongodbProtocol = metrics.getMongodb();
        Assert.hasText((String)mongodbProtocol.getCommand(), (String)"Mongodb Protocol command is required.");
        Assert.hasText((String)mongodbProtocol.getHost(), (String)"Mongodb Protocol host is required.");
        Assert.hasText((String)mongodbProtocol.getPort(), (String)"Mongodb Protocol port is required.");
    }

    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        String[] metricsParts = metrics.getMongodb().getCommand().split("\\.");
        String command = metricsParts[0];
        if (Arrays.stream(SUPPORTED_MONGODB_DIAGNOSTIC_COMMANDS).noneMatch(command::equals)) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("unsupported mongodb diagnostic command: " + command);
            return;
        }
        CacheIdentifier identifier = null;
        try {
            identifier = MongodbSingleCollectImpl.getIdentifier(metrics.getMongodb());
            MongoClient mongoClient = this.getClient(metrics, identifier);
            MongoDatabase mongoDatabase = mongoClient.getDatabase(metrics.getMongodb().getDatabase());
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            Document document = mongoDatabase.runCommand((Bson)new Document(command, (Object)1));
            for (int i = 1; i < metricsParts.length; ++i) {
                document = (Document)document.get((Object)metricsParts[i]);
            }
            if (document == null) {
                throw new RuntimeException("the document get from command " + metrics.getMongodb().getCommand() + " is null.");
            }
            this.fillBuilder(metrics, valueRowBuilder, document);
            builder.addValues(valueRowBuilder.build());
        }
        catch (MongoServerUnavailableException | MongoTimeoutException unavailableException) {
            this.connectionCommonCache.removeCache((Object)identifier);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            String message = CommonUtil.getMessageFromThrowable((Throwable)unavailableException);
            builder.setMsg(message);
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.FAIL);
            String message = CommonUtil.getMessageFromThrowable((Throwable)e);
            builder.setMsg(message);
            log.warn(message, (Throwable)e);
        }
    }

    public String supportProtocol() {
        return "mongodb";
    }

    private void fillBuilder(Metrics metrics, CollectRep.ValueRow.Builder valueRowBuilder, Document document) {
        metrics.getAliasFields().forEach(it -> {
            if (document.containsKey(it)) {
                Object fieldValue = document.get(it);
                if (fieldValue == null) {
                    valueRowBuilder.addColumns("&nbsp;");
                } else {
                    valueRowBuilder.addColumns(fieldValue.toString());
                }
            } else {
                valueRowBuilder.addColumns("&nbsp;");
            }
        });
    }

    public static CacheIdentifier getIdentifier(MongodbProtocol mongodbProtocol) {
        return CacheIdentifier.builder().ip(mongodbProtocol.getHost()).port(mongodbProtocol.getPort()).username(mongodbProtocol.getUsername()).password(mongodbProtocol.getPassword()).build();
    }

    private MongoClient getClient(Metrics metrics, CacheIdentifier identifier) {
        MongodbProtocol mongodbProtocol = metrics.getMongodb();
        Optional cacheOption = this.connectionCommonCache.getCache((Object)identifier, true);
        MongoClient mongoClient = null;
        if (cacheOption.isPresent()) {
            MongodbConnect mongodbConnect = (MongodbConnect)((Object)cacheOption.get());
            mongoClient = mongodbConnect.getConnection();
        }
        if (mongoClient != null) {
            return mongoClient;
        }
        String url = null;
        url = "mongodb-atlas".equals(mongodbProtocol.getModel()) ? (StringUtils.isBlank((CharSequence)mongodbProtocol.getUsername()) && StringUtils.isBlank((CharSequence)mongodbProtocol.getPassword()) ? String.format("mongodb+srv://%s/%s", mongodbProtocol.getHost(), mongodbProtocol.getDatabase()) : String.format("mongodb+srv://%s:%s@%s/%s?authSource=%s", mongodbProtocol.getUsername(), URLEncoder.encode(mongodbProtocol.getPassword(), StandardCharsets.UTF_8), mongodbProtocol.getHost(), mongodbProtocol.getDatabase(), mongodbProtocol.getAuthenticationDatabase())) : (StringUtils.isBlank((CharSequence)mongodbProtocol.getUsername()) && StringUtils.isBlank((CharSequence)mongodbProtocol.getPassword()) ? String.format("mongodb://%s:%s/%s", mongodbProtocol.getHost(), mongodbProtocol.getPort(), mongodbProtocol.getDatabase()) : String.format("mongodb://%s:%s@%s:%s/%s?authSource=%s", mongodbProtocol.getUsername(), URLEncoder.encode(mongodbProtocol.getPassword(), StandardCharsets.UTF_8), mongodbProtocol.getHost(), mongodbProtocol.getPort(), mongodbProtocol.getDatabase(), mongodbProtocol.getAuthenticationDatabase()));
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(url)).applyToClusterSettings(builder -> builder.serverSelectionTimeout(Long.parseLong(mongodbProtocol.getTimeout()), TimeUnit.MILLISECONDS)).build();
        mongoClient = MongoClients.create((MongoClientSettings)settings);
        MongodbConnect mongodbConnect = new MongodbConnect(mongoClient);
        this.connectionCommonCache.addCache((Object)identifier, (AbstractConnection)mongodbConnect, Long.valueOf(3600000L));
        return mongoClient;
    }
}

