/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.telnet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.TelnetProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(TelnetCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getTelnet() == null) {
            throw new IllegalArgumentException("Telnet collect must has Telnet params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        TelnetProtocol telnet = metrics.getTelnet();
        int timeout = CollectUtil.getTimeout((String)telnet.getTimeout());
        TelnetClient telnetClient = null;
        try {
            CollectRep.ValueRow.Builder valueRowBuilder;
            telnetClient = new TelnetClient("vt200");
            telnetClient.setConnectTimeout(timeout);
            telnetClient.connect(telnet.getHost(), Integer.parseInt(telnet.getPort()));
            if (telnetClient.isConnected()) {
                long responseTime = System.currentTimeMillis() - startTime;
                List aliasFields = metrics.getAliasFields();
                Map<String, String> resultMap = TelnetCollectImpl.execCmdAndParseResult(telnetClient, telnet.getCmd(), app);
                resultMap.put("responseTime", Long.toString(responseTime));
                if (resultMap.size() < aliasFields.size()) {
                    log.error("telnet response data not enough: {}", resultMap);
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("The cmd execution results do not match the expected number of metrics.");
                    return;
                }
                valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String field : aliasFields) {
                    String fieldValue = resultMap.get(field);
                    valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
                }
            } else {
                builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                builder.setMsg("Peer connect failed\uff0cTimeout " + timeout + "ms");
                return;
            }
            builder.addValues(valueRowBuilder.build());
            telnetClient.disconnect();
        }
        catch (ConnectException connectException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)connectException);
            log.debug(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("The peer refused to connect: service port does not listening or firewall: " + errorMsg);
        }
        catch (IOException ioException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ioException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Peer connect failed: " + errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (telnetClient != null) {
                try {
                    telnetClient.disconnect();
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
        }
    }

    public String supportProtocol() {
        return "telnet";
    }

    private static Map<String, String> execCmdAndParseResult(TelnetClient telnetClient, String cmd, String app) throws IOException {
        if (cmd == null || StringUtils.isEmpty((CharSequence)cmd.trim())) {
            return new HashMap<String, String>(16);
        }
        OutputStream outputStream = telnetClient.getOutputStream();
        outputStream.write(cmd.getBytes());
        outputStream.flush();
        String result = new String(telnetClient.getInputStream().readAllBytes());
        String[] lines = result.split("\n");
        if ("zookeeper".equals(app) && "Environment:".equals(lines[0])) {
            lines = (String[])Arrays.stream(lines).skip(1L).toArray(String[]::new);
        }
        boolean contains = lines[0].contains("=");
        return Arrays.stream(lines).map(item -> {
            if (contains) {
                return item.split("=");
            }
            return item.split("\t");
        }).filter(item -> ((String[])item).length == 2).collect(Collectors.toMap(x -> x[0], x -> x[1]));
    }
}

