/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.smtp;

import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.net.smtp.SMTP;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.SmtpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(SmtpCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getSmtp() == null) {
            throw new IllegalArgumentException("Smtp collect must has Smtp params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        SmtpProtocol smtpProtocol = metrics.getSmtp();
        String host = smtpProtocol.getHost();
        String port = smtpProtocol.getPort();
        int timeout = CollectUtil.getTimeout((String)smtpProtocol.getTimeout());
        SMTP smtp = null;
        try {
            CollectRep.ValueRow.Builder valueRowBuilder;
            smtp = new SMTP();
            smtp.setConnectTimeout(timeout);
            smtp.setCharset(StandardCharsets.UTF_8);
            smtp.connect(host, Integer.parseInt(port));
            if (smtp.isConnected()) {
                long responseTime = System.currentTimeMillis() - startTime;
                List aliasFields = metrics.getAliasFields();
                Map<String, String> resultMap = SmtpCollectImpl.execCmdAndParseResult(smtp, smtpProtocol.getCmd(), smtpProtocol);
                resultMap.put("responseTime", Long.toString(responseTime));
                if (resultMap.size() < aliasFields.size()) {
                    log.error("smtp response data not enough: {}", resultMap);
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("The cmd execution results do not match the expected number of metrics.");
                    return;
                }
                valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String field : aliasFields) {
                    String fieldValue = resultMap.get(field);
                    valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
                }
            } else {
                builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                builder.setMsg("Peer connect failed\uff0cTimeout " + timeout + "ms");
                return;
            }
            builder.addValues(valueRowBuilder.build());
            smtp.disconnect();
        }
        catch (SocketException socketException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)socketException);
            log.debug(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("The peer refused to connect: service port does not listening or firewall: " + errorMsg);
        }
        catch (IOException ioException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ioException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Peer connect failed: " + errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (smtp != null) {
                try {
                    smtp.disconnect();
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
        }
    }

    public String supportProtocol() {
        return "smtp";
    }

    private static Map<String, String> execCmdAndParseResult(SMTP smtp, String cmd, SmtpProtocol smtpProtocol) throws IOException {
        String[] lines;
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("smtpBanner", smtp.getReplyString());
        smtp.helo(smtpProtocol.getEmail());
        String replyString = smtp.getReplyString();
        result.put("heloInfo", replyString);
        for (String line : lines = replyString.split("\n")) {
            if (!line.startsWith("250")) continue;
            result.put("response", "OK");
        }
        return result;
    }
}

