/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.ConnectionCommonCache;
import org.apache.hertzbeat.collector.collect.common.cache.RedisConnect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.RedisProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.MapCapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisCommonCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(RedisCommonCollectImpl.class);
    private static final String CLUSTER = "3";
    private static final String CLUSTER_INFO = "cluster";
    private static final String UNIQUE_IDENTITY = "identity";
    private final ClientResources defaultClientResources = DefaultClientResources.create();
    private final ConnectionCommonCache<CacheIdentifier, RedisConnect> connectionCommonCache = new ConnectionCommonCache();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.noNullElements((Object[])new Object[]{metrics, metrics.getRedis()}, (String)"Redis collect must has redis params");
        RedisProtocol redisProtocol = metrics.getRedis();
        Assert.hasText((String)redisProtocol.getHost(), (String)"Redis Protocol host is required.");
        Assert.hasText((String)redisProtocol.getPort(), (String)"Redis Protocol port is required.");
    }

    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        try {
            if (Objects.nonNull(metrics.getRedis().getPattern()) && Objects.equals(metrics.getRedis().getPattern(), CLUSTER)) {
                List<Map<String, String>> redisInfoList = this.getClusterRedisInfo(metrics);
                this.doMetricsDataList(builder, redisInfoList, metrics);
            } else {
                Map<String, String> redisInfo = this.getSingleRedisInfo(metrics);
                this.doMetricsData(builder, redisInfo, metrics);
            }
        }
        catch (RedisConnectionException connectionException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)connectionException);
            log.info("[redis connection] error: {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("[redis collect] error: {}", (Object)e.getMessage(), (Object)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    private Map<String, String> getSingleRedisInfo(Metrics metrics) {
        StatefulRedisConnection<String, String> connection = this.getSingleConnection(metrics.getRedis());
        String info = connection.sync().info(metrics.getName());
        Map<String, String> valueMap = this.parseInfo(info, metrics);
        if (log.isDebugEnabled()) {
            log.debug("[RedisSingleCollectImpl] fetch redis info");
            valueMap.forEach((k, v) -> log.debug("{} : {}", k, v));
        }
        return valueMap;
    }

    private List<Map<String, String>> getClusterRedisInfo(Metrics metrics) {
        Map<String, StatefulRedisClusterConnection<String, String>> connectionMap = this.getConnectionList(metrics.getRedis());
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(connectionMap.size());
        connectionMap.forEach((identity, connection) -> {
            String info = connection.sync().info(metrics.getName());
            Map<String, String> valueMap = this.parseInfo(info, metrics);
            valueMap.put(UNIQUE_IDENTITY, (String)identity);
            if (Objects.equals(metrics.getName(), CLUSTER_INFO)) {
                String clusterNodes = connection.sync().clusterInfo();
                valueMap.putAll(this.parseInfo(clusterNodes, metrics));
            }
            if (log.isDebugEnabled()) {
                log.debug("[RedisSingleCollectImpl] fetch redis info");
                valueMap.forEach((k, v) -> log.debug("{} : {}", k, v));
            }
            list.add(valueMap);
        });
        return list;
    }

    private void doMetricsDataList(CollectRep.MetricsData.Builder builder, List<Map<String, String>> valueMapList, Metrics metrics) {
        valueMapList.forEach(e -> this.doMetricsData(builder, (Map<String, String>)e, metrics));
    }

    private void doMetricsData(CollectRep.MetricsData.Builder builder, Map<String, String> valueMap, Metrics metrics) {
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        metrics.getAliasFields().forEach(it -> {
            if (valueMap.containsKey(it)) {
                String fieldValue = (String)valueMap.get(it);
                valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
            } else {
                valueRowBuilder.addColumns("&nbsp;");
            }
        });
        builder.addValues(valueRowBuilder.build());
    }

    private StatefulRedisConnection<String, String> getSingleConnection(RedisProtocol redisProtocol) {
        CacheIdentifier identifier = this.doIdentifier(redisProtocol);
        StatefulRedisConnection connection = (StatefulRedisConnection)this.getStatefulConnection(identifier);
        if (Objects.isNull(connection)) {
            RedisClient redisClient = this.buildSingleClient(redisProtocol);
            connection = redisClient.connect();
            this.connectionCommonCache.addCache((Object)identifier, (AbstractConnection)new RedisConnect((StatefulConnection)connection));
        }
        return connection;
    }

    private Map<String, StatefulRedisClusterConnection<String, String>> getConnectionList(RedisProtocol redisProtocol) {
        StatefulRedisClusterConnection<String, String> connection = this.getClusterConnection(redisProtocol);
        Partitions partitions = connection.getPartitions();
        HashMap<String, StatefulRedisClusterConnection<String, String>> clusterConnectionMap = new HashMap<String, StatefulRedisClusterConnection<String, String>>(partitions.size());
        for (RedisClusterNode partition : partitions) {
            RedisURI uri = partition.getUri();
            redisProtocol.setHost(uri.getHost());
            redisProtocol.setPort(String.valueOf(uri.getPort()));
            StatefulRedisClusterConnection<String, String> clusterConnection = this.getClusterConnection(redisProtocol);
            clusterConnectionMap.put(this.doUri(uri.getHost(), uri.getPort()), clusterConnection);
        }
        return clusterConnectionMap;
    }

    private StatefulRedisClusterConnection<String, String> getClusterConnection(RedisProtocol redisProtocol) {
        CacheIdentifier identifier = this.doIdentifier(redisProtocol);
        StatefulRedisClusterConnection connection = (StatefulRedisClusterConnection)this.getStatefulConnection(identifier);
        if (connection == null) {
            RedisClusterClient redisClusterClient = this.buildClusterClient(redisProtocol);
            connection = redisClusterClient.connect();
            this.connectionCommonCache.addCache((Object)identifier, (AbstractConnection)new RedisConnect((StatefulConnection)connection));
        }
        return connection;
    }

    private StatefulConnection<String, String> getStatefulConnection(CacheIdentifier identifier) {
        RedisConnect redisConnect;
        StatefulConnection connection = null;
        Optional cacheOption = this.connectionCommonCache.getCache((Object)identifier, true);
        if (cacheOption.isPresent() && !(connection = (redisConnect = (RedisConnect)cacheOption.get()).getConnection()).isOpen()) {
            try {
                connection.closeAsync();
            }
            catch (Exception e) {
                log.info("The redis connect form cache, close error: {}", (Object)e.getMessage());
            }
            connection = null;
            this.connectionCommonCache.removeCache((Object)identifier);
        }
        return connection;
    }

    private RedisClusterClient buildClusterClient(RedisProtocol redisProtocol) {
        return RedisClusterClient.create((ClientResources)this.defaultClientResources, (RedisURI)this.redisUri(redisProtocol));
    }

    private RedisClient buildSingleClient(RedisProtocol redisProtocol) {
        return RedisClient.create((ClientResources)this.defaultClientResources, (RedisURI)this.redisUri(redisProtocol));
    }

    private RedisURI redisUri(RedisProtocol redisProtocol) {
        RedisURI.Builder redisUriBuilder = RedisURI.builder().withHost(redisProtocol.getHost()).withPort(Integer.parseInt(redisProtocol.getPort()));
        if (StringUtils.hasText((String)redisProtocol.getUsername())) {
            redisUriBuilder.withClientName(redisProtocol.getUsername());
        }
        if (StringUtils.hasText((String)redisProtocol.getPassword())) {
            redisUriBuilder.withPassword(redisProtocol.getPassword().toCharArray());
        }
        Duration timeout = Duration.ofMillis(CollectUtil.getTimeout((String)redisProtocol.getTimeout()));
        redisUriBuilder.withTimeout(timeout);
        return redisUriBuilder.build();
    }

    private String removeCr(String value) {
        return value.replace("\r", "");
    }

    private String doUri(String ip, Integer port) {
        return ip + ":" + port;
    }

    private CacheIdentifier doIdentifier(RedisProtocol redisProtocol) {
        return CacheIdentifier.builder().ip(redisProtocol.getHost()).port(redisProtocol.getPort()).username(redisProtocol.getUsername()).password(redisProtocol.getPassword()).customArg(redisProtocol.getPattern()).build();
    }

    private Map<String, String> parseInfo(String info, Metrics metrics) {
        int fieldTotalSize = metrics.getFields().size();
        String[] lines = info.split("\n");
        HashMap<String, String> result = new HashMap<String, String>(MapCapUtil.calInitMap((int)fieldTotalSize));
        Arrays.stream(lines).filter(it -> StringUtils.hasText((String)it) && !it.startsWith("#") && it.contains(":")).map(this::removeCr).map(r -> r.split(":")).filter(t -> ((String[])t).length > 1).forEach(it -> result.put(it[0], it[1]));
        if (result.size() < fieldTotalSize) {
            for (Metrics.Field field : metrics.getFields()) {
                if (result.containsKey(field.getField())) continue;
                result.put(field.getField(), "&nbsp;");
            }
        }
        return result;
    }

    public String supportProtocol() {
        return "redis";
    }
}

