/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.push;

import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.PushProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.entity.push.PushMetricsDto;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(PushCollectImpl.class);
    private static final Map<Long, Long> timeMap = new ConcurrentHashMap<Long, Long>();
    private static final Integer timeout = 3000;
    private static final Integer SUCCESS_CODE = 200;
    private static final Integer firstCollectInterval = 30000;

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getPush() == null) {
            throw new IllegalArgumentException("Push collect must has Push params");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long curTime = System.currentTimeMillis();
        PushProtocol pushProtocol = metrics.getPush();
        Long time = timeMap.getOrDefault(monitorId, curTime - (long)firstCollectInterval.intValue());
        timeMap.put(monitorId, curTime);
        HttpContext httpContext = this.createHttpContext(pushProtocol);
        HttpUriRequest request = this.createHttpRequest(pushProtocol, monitorId, time);
        try {
            CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != SUCCESS_CODE) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("StatusCode " + statusCode);
                return;
            }
            String resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            this.parseResponse(builder, resp, metrics);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    public String supportProtocol() {
        return "push";
    }

    private HttpContext createHttpContext(PushProtocol pushProtocol) {
        HttpHost host = new HttpHost(pushProtocol.getHost(), Integer.parseInt(pushProtocol.getPort()));
        HttpClientContext httpClientContext = new HttpClientContext();
        httpClientContext.setTargetHost(host);
        return httpClientContext;
    }

    private HttpUriRequest createHttpRequest(PushProtocol pushProtocol, Long monitorId, Long startTime) {
        RequestBuilder requestBuilder = RequestBuilder.get();
        String uri = CollectUtil.replaceUriSpecialChar((String)pushProtocol.getUri());
        if (IpDomainUtil.isHasSchema((String)pushProtocol.getHost())) {
            requestBuilder.setUri(pushProtocol.getHost() + ":" + pushProtocol.getPort() + uri);
        } else {
            String ipAddressType = IpDomainUtil.checkIpAddressType((String)pushProtocol.getHost());
            String baseUri = "ipv6".equals(ipAddressType) ? String.format("[%s]:%s", pushProtocol.getHost(), pushProtocol.getPort() + uri) : String.format("%s:%s", pushProtocol.getHost(), pushProtocol.getPort() + uri);
            requestBuilder.setUri("http://" + baseUri);
        }
        requestBuilder.addHeader("Connection", "Keep-Alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36\")");
        requestBuilder.addParameter("id", String.valueOf(monitorId));
        requestBuilder.addParameter("time", String.valueOf(startTime));
        requestBuilder.addHeader("Accept", "application/json");
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout.intValue()).setSocketTimeout(timeout.intValue()).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    private void parseResponse(CollectRep.MetricsData.Builder builder, String resp, Metrics metric) {
        Message msg = (Message)JsonUtil.fromJson((String)resp, (TypeReference)new TypeReference<Message<PushMetricsDto>>(){});
        if (msg == null) {
            throw new NullPointerException("parse result is null");
        }
        PushMetricsDto pushMetricsDto = (PushMetricsDto)msg.getData();
        if (pushMetricsDto == null || pushMetricsDto.getMetricsList() == null) {
            throw new NullPointerException("parse result is null");
        }
        for (PushMetricsDto.Metrics pushMetrics : pushMetricsDto.getMetricsList()) {
            ArrayList<CollectRep.ValueRow> rows = new ArrayList<CollectRep.ValueRow>();
            for (Map metrics : pushMetrics.getMetrics()) {
                ArrayList<String> metricColumn = new ArrayList<String>();
                for (Metrics.Field field : metric.getFields()) {
                    metricColumn.add((String)metrics.get(field.getField()));
                }
                CollectRep.ValueRow valueRow = CollectRep.ValueRow.newBuilder().addAllColumns(metricColumn).build();
                rows.add(valueRow);
            }
            builder.addAllValues(rows);
        }
        builder.setTime(System.currentTimeMillis());
    }
}

