/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.imap;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.commons.net.imap.IMAPSClient;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.ImapProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ImapCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(ImapCollectImpl.class);
    private static final String UTF_7_X = "X-MODIFIED-UTF-7";
    private static final String STATUS = "STATUS";
    private static final String STATUS_COMMAND = "(MESSAGES RECENT UNSEEN)";
    private static final String MESSAGES = "MESSAGES";
    private static final String RECENT = "RECENT";
    private static final String UNSEEN = "UNSEEN";
    private static final String RESPONSETIME = "responseTime";
    private static final String totalMessageCount = "TotalMessageCount";
    private static final String recentMessageCount = "RecentMessageCount";
    private static final String unseenMessageCount = "UnseenMessageCount";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        ImapProtocol imapProtocol = metrics.getImap();
        Assert.notNull((Object)metrics, (String)"IMAP collect must has Imap params");
        Assert.notNull((Object)metrics.getImap(), (String)"IMAP collect must has Imap params");
        Assert.hasText((String)imapProtocol.getHost(), (String)"IMAP host is required");
        Assert.hasText((String)imapProtocol.getPort(), (String)"IMAP port is required");
        Assert.hasText((String)imapProtocol.getEmail(), (String)"IMAP email is required");
        Assert.hasText((String)imapProtocol.getAuthorize(), (String)"IMAP authorize code is required");
        Assert.hasText((String)imapProtocol.getFolderName(), (String)"IMAP folder name is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        String errorMsg;
        long startTime = System.currentTimeMillis();
        ImapProtocol imapProtocol = metrics.getImap();
        IMAPClient imapClient = null;
        boolean ssl = Boolean.parseBoolean(imapProtocol.getSsl());
        try {
            imapClient = this.createImapClient(imapProtocol, ssl);
            if (imapClient.isConnected()) {
                long responseTime = System.currentTimeMillis() - startTime;
                String folderName = imapProtocol.getFolderName();
                this.collectImapMetrics(builder, imapClient, metrics.getAliasFields(), folderName, responseTime);
            } else {
                builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                builder.setMsg("Peer connect failed\uff0cTimeout " + imapProtocol.getTimeout() + "ms");
            }
        }
        catch (Exception e) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (imapClient != null) {
                try {
                    imapClient.logout();
                    imapClient.disconnect();
                }
                catch (IOException e) {
                    errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
                    log.error(errorMsg);
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg(errorMsg);
                }
            }
        }
    }

    public String supportProtocol() {
        return "imap";
    }

    private IMAPClient createImapClient(ImapProtocol imapProtocol, boolean ssl) throws Exception {
        int timeout;
        IMAPSClient imapClient = null;
        imapClient = new IMAPSClient(true);
        if (!ssl) {
            imapClient = new IMAPClient();
        }
        if ((timeout = Integer.parseInt(imapProtocol.getTimeout())) > 0) {
            imapClient.setConnectTimeout(timeout);
        }
        imapClient.setCharset(StandardCharsets.US_ASCII);
        String host = imapProtocol.getHost();
        int port = Integer.parseInt(imapProtocol.getPort());
        imapClient.connect(host, port);
        String email = imapProtocol.getEmail();
        String authorize = imapProtocol.getAuthorize();
        boolean isAuthenticated = imapClient.login(email, authorize);
        if (!isAuthenticated) {
            throw new Exception("IMAP client authentication failed");
        }
        return imapClient;
    }

    private void collectImapMetrics(CollectRep.MetricsData.Builder builder, IMAPClient imapClient, List<String> aliasFields, String folderName, long responseTime) throws Exception {
        HashMap<Object, String> resultsMap = new HashMap<Object, String>();
        resultsMap.put(RESPONSETIME, String.valueOf(responseTime));
        imapClient.sendCommand("STATUS \"" + CollectUtil.stringEncodeUtf7String((String)folderName, (String)UTF_7_X) + "\" (MESSAGES RECENT UNSEEN)");
        String[] response = imapClient.getReplyString().split("\\s+|\\(|\\)");
        block10: for (int i = 0; i < response.length; ++i) {
            switch (response[i]) {
                case "MESSAGES": {
                    resultsMap.put(folderName + totalMessageCount, response[i + 1]);
                    continue block10;
                }
                case "RECENT": {
                    resultsMap.put(folderName + recentMessageCount, response[i + 1]);
                    continue block10;
                }
                case "UNSEEN": {
                    resultsMap.put(folderName + unseenMessageCount, response[i + 1]);
                    continue block10;
                }
            }
        }
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String field : aliasFields) {
            String fieldValue = (String)resultsMap.get(field);
            valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
        }
        builder.addValues(valueRowBuilder.build());
    }
}

