/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.rocketmq;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.rocketmq.RocketmqCollectData;
import org.apache.hertzbeat.collector.util.JsonPathParser;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.RocketmqProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

public class RocketmqSingleCollectImpl
extends AbstractCollect
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RocketmqSingleCollectImpl.class);
    private static final int WAIT_TIMEOUT = 10;
    private static final Set<String> SYSTEM_GROUP_SET = new HashSet<String>();
    private final ExecutorService executorService;

    public RocketmqSingleCollectImpl() {
        Runtime runtime = Runtime.getRuntime();
        int corePoolSize = Math.max(8, runtime.availableProcessors());
        int maximumPoolSize = Math.max(16, runtime.availableProcessors());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("RocketMQCollectGroup has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("rocketMQ-collector-%d").build();
        this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(5000), threadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void destroy() {
        ThreadUtils.shutdownGracefully((ExecutorService)this.executorService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.isTrue((metrics != null && metrics.getRocketmq() != null ? 1 : 0) != 0, (String)"Rocketmq collect must has rocketmq params");
        RocketmqProtocol rocketmq = metrics.getRocketmq();
        Assert.hasText((String)rocketmq.getNamesrvHost(), (String)"Rocketmq Protocol namesrvHost is required.");
        Assert.hasText((String)rocketmq.getNamesrvPort(), (String)"Rocketmq Protocol namesrvPort is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        DefaultMQAdminExt mqAdminExt = null;
        try {
            mqAdminExt = this.createMqAdminExt(metrics);
            mqAdminExt.start();
            RocketmqCollectData rocketmqCollectData = new RocketmqCollectData();
            this.collectData(mqAdminExt, rocketmqCollectData);
            this.fillBuilder(rocketmqCollectData, builder, metrics.getAliasFields(), metrics.getRocketmq().getParseScript());
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.FAIL);
            String message = CommonUtil.getMessageFromThrowable((Throwable)e);
            builder.setMsg(message);
        }
        finally {
            if (mqAdminExt != null) {
                mqAdminExt.shutdown();
            }
        }
    }

    public String supportProtocol() {
        return "rocketmq";
    }

    private DefaultMQAdminExt createMqAdminExt(Metrics metrics) {
        RocketmqProtocol rocketmqProtocol = metrics.getRocketmq();
        assert (rocketmqProtocol != null);
        AclClientRPCHook rpcHook = null;
        if (StringUtils.isNotBlank((CharSequence)rocketmqProtocol.getAccessKey()) && StringUtils.isNotBlank((CharSequence)rocketmqProtocol.getSecretKey())) {
            rpcHook = new AclClientRPCHook(new SessionCredentials(rocketmqProtocol.getAccessKey(), rocketmqProtocol.getSecretKey()));
        }
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt(rpcHook, 5000L);
        mqAdminExt.setNamesrvAddr(rocketmqProtocol.getNamesrvHost() + ":" + rocketmqProtocol.getNamesrvPort());
        mqAdminExt.setInstanceName("admin-" + System.currentTimeMillis());
        return mqAdminExt;
    }

    private void collectData(DefaultMQAdminExt mqAdminExt, RocketmqCollectData rocketmqCollectData) throws Exception {
        this.collectClusterData(mqAdminExt, rocketmqCollectData);
        this.collectConsumerData(mqAdminExt, rocketmqCollectData);
        this.collectTopicData(mqAdminExt, rocketmqCollectData);
    }

    private void collectClusterData(DefaultMQAdminExt mqAdminExt, RocketmqCollectData rocketmqCollectData) throws Exception {
        try {
            ArrayList<RocketmqCollectData.ClusterBrokerData> clusterBrokerDataList = new ArrayList<RocketmqCollectData.ClusterBrokerData>();
            rocketmqCollectData.setClusterBrokerDataList(clusterBrokerDataList);
            ClusterInfo clusterInfo = mqAdminExt.examineBrokerClusterInfo();
            for (BrokerData brokerData : clusterInfo.getBrokerAddrTable().values()) {
                for (Map.Entry entry : brokerData.getBrokerAddrs().entrySet()) {
                    String msgGetTotalTodayNow;
                    String msgPutTotalTodayNow;
                    String getTransferredTps;
                    RocketmqCollectData.ClusterBrokerData clusterBrokerData = new RocketmqCollectData.ClusterBrokerData();
                    clusterBrokerDataList.add(clusterBrokerData);
                    clusterBrokerData.setBrokerId((Long)entry.getKey());
                    clusterBrokerData.setAddress((String)entry.getValue());
                    KVTable kvTable = mqAdminExt.fetchBrokerRuntimeStats((String)entry.getValue());
                    clusterBrokerData.setVersion((String)kvTable.getTable().get("brokerVersionDesc"));
                    String putTps = (String)kvTable.getTable().get("putTps");
                    if (StringUtils.isNotEmpty((CharSequence)putTps)) {
                        String[] putTpsArr = putTps.split(" ");
                        clusterBrokerData.setProducerMessageTps(Double.parseDouble(putTpsArr[0]));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(getTransferredTps = (String)kvTable.getTable().get("getTransferedTps")))) {
                        String[] getTransferredTpsArr = getTransferredTps.split(" ");
                        clusterBrokerData.setConsumerMessageTps(Double.parseDouble(getTransferredTpsArr[0]));
                    }
                    String msgPutTotalTodayMorning = (String)kvTable.getTable().get("msgPutTotalTodayMorning");
                    String msgPutTotalYesterdayMorning = (String)kvTable.getTable().get("msgPutTotalYesterdayMorning");
                    if (StringUtils.isNotEmpty((CharSequence)msgPutTotalTodayMorning) && StringUtils.isNotEmpty((CharSequence)msgPutTotalYesterdayMorning)) {
                        long yesterdayProduceCount = Long.parseLong(msgPutTotalTodayMorning) - Long.parseLong(msgPutTotalYesterdayMorning);
                        clusterBrokerData.setYesterdayProduceCount(yesterdayProduceCount);
                    }
                    String msgGetTotalTodayMorning = (String)kvTable.getTable().get("msgGetTotalTodayMorning");
                    String msgGetTotalYesterdayMorning = (String)kvTable.getTable().get("msgGetTotalYesterdayMorning");
                    if (StringUtils.isNotEmpty((CharSequence)msgGetTotalTodayMorning) && StringUtils.isNotEmpty((CharSequence)msgGetTotalYesterdayMorning)) {
                        long yesterdayConsumerCount = Long.parseLong(msgGetTotalTodayMorning) - Long.parseLong(msgGetTotalYesterdayMorning);
                        clusterBrokerData.setYesterdayConsumeCount(yesterdayConsumerCount);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(msgPutTotalTodayNow = (String)kvTable.getTable().get("msgPutTotalTodayNow"))) && StringUtils.isNotEmpty((CharSequence)msgPutTotalTodayMorning)) {
                        long todayProduceCount = Long.parseLong(msgPutTotalTodayNow) - Long.parseLong(msgPutTotalTodayMorning);
                        clusterBrokerData.setTodayProduceCount(todayProduceCount);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(msgGetTotalTodayNow = (String)kvTable.getTable().get("msgGetTotalTodayNow"))) || !StringUtils.isNotEmpty((CharSequence)msgGetTotalTodayMorning)) continue;
                    long todayConsumerCount = Long.parseLong(msgGetTotalTodayNow) - Long.parseLong(msgGetTotalTodayMorning);
                    clusterBrokerData.setTodayConsumeCount(todayConsumerCount);
                }
            }
        }
        catch (Exception e) {
            log.warn("collect rocketmq cluster data error", (Throwable)e);
            throw e;
        }
    }

    private void collectConsumerData(DefaultMQAdminExt mqAdminExt, RocketmqCollectData rocketmqCollectData) throws Exception {
        HashSet consumerGroupSet = new HashSet();
        try {
            ClusterInfo clusterInfo = mqAdminExt.examineBrokerClusterInfo();
            for (BrokerData brokerData : clusterInfo.getBrokerAddrTable().values()) {
                SubscriptionGroupWrapper subscriptionGroupWrapper = mqAdminExt.getAllSubscriptionGroup(brokerData.selectBrokerAddr(), 3000L);
                consumerGroupSet.addAll(subscriptionGroupWrapper.getSubscriptionGroupTable().keySet());
            }
            List<RocketmqCollectData.ConsumerInfo> consumerInfoList = Collections.synchronizedList(Lists.newArrayList());
            rocketmqCollectData.setConsumerInfoList(consumerInfoList);
            CountDownLatch countDownLatch = new CountDownLatch(consumerGroupSet.size());
            for (String consumerGroup : consumerGroupSet) {
                if (SYSTEM_GROUP_SET.contains(consumerGroup)) continue;
                this.executorService.submit(() -> {
                    RocketmqCollectData.ConsumerInfo consumerInfo = new RocketmqCollectData.ConsumerInfo();
                    consumerInfoList.add(consumerInfo);
                    consumerInfo.setConsumerGroup(consumerGroup);
                    try {
                        ConsumeStats consumeStats = null;
                        try {
                            consumeStats = mqAdminExt.examineConsumeStats(consumerGroup);
                        }
                        catch (Exception e) {
                            log.warn("examineConsumeStats exception to consumerGroup {}, response [{}]", (Object)consumerGroup, (Object)e.getMessage());
                        }
                        if (consumeStats != null) {
                            consumerInfo.setConsumeTps(consumeStats.getConsumeTps());
                            consumerInfo.setDiffTotal(consumeStats.computeTotalDiff());
                        }
                        ConsumerConnection consumerConnection = null;
                        try {
                            consumerConnection = mqAdminExt.examineConsumerConnectionInfo(consumerGroup);
                        }
                        catch (Exception e) {
                            log.warn("examineConsumeStats exception to consumerGroup {}, response [{}]", (Object)consumerGroup, (Object)e.getMessage());
                        }
                        if (consumerConnection != null) {
                            consumerInfo.setClientQuantity(consumerConnection.getConnectionSet().size());
                            consumerInfo.setMessageModel(consumerConnection.getMessageModel().getModeCN());
                            consumerInfo.setConsumeType(consumerConnection.getConsumeType().getTypeCN());
                        }
                    }
                    catch (Exception e) {
                        log.warn("examineConsumeStats or examineConsumerConnectionInfo error, {}", (Object)consumerGroup, (Object)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            if (!countDownLatch.await(10L, TimeUnit.SECONDS)) {
                log.warn("examineConsumeStats or examineConsumerConnectionInfo timeout");
            }
        }
        catch (Exception e) {
            log.warn("collect rocketmq consume data error", (Throwable)e);
            throw e;
        }
    }

    private void collectTopicData(DefaultMQAdminExt mqAdminExt, RocketmqCollectData rocketmqCollectData) throws Exception {
        try {
            TopicList topicList = mqAdminExt.fetchAllTopicList();
            Set topics = topicList.getTopicList().stream().filter(topic -> !topic.startsWith("%RETRY%") && !topic.startsWith("%DLQ%")).collect(Collectors.toSet());
            ArrayList<Map<String, List<RocketmqCollectData.TopicQueueInfo>>> topicInfoList = new ArrayList<Map<String, List<RocketmqCollectData.TopicQueueInfo>>>();
            for (String topic2 : topics) {
                HashMap topicQueueInfoTable = new HashMap(32);
                ArrayList topicQueueInfoList = new ArrayList();
                topicQueueInfoTable.put(topic2, topicQueueInfoList);
                topicInfoList.add(topicQueueInfoTable);
                rocketmqCollectData.setTopicInfoList(topicInfoList);
            }
        }
        catch (Exception e) {
            log.warn("collect rocketmq topic data error", (Throwable)e);
            throw e;
        }
    }

    private void fillBuilder(RocketmqCollectData rocketmqCollectData, CollectRep.MetricsData.Builder builder, List<String> aliasFields, String parseScript) {
        String dataJson = JSONObject.toJSONString((Object)rocketmqCollectData);
        List results = JsonPathParser.parseContentWithJsonPath((String)dataJson, (String)parseScript);
        for (int i = 0; i < results.size(); ++i) {
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String aliasField : aliasFields) {
                List valueList = JsonPathParser.parseContentWithJsonPath((String)dataJson, (String)(parseScript + aliasField));
                if (CollectionUtils.isNotEmpty((Collection)valueList) && valueList.size() > i) {
                    Object value = valueList.get(i);
                    valueRowBuilder.addColumns(value == null ? "&nbsp;" : String.valueOf(value));
                    continue;
                }
                valueRowBuilder.addColumns("&nbsp;");
            }
            builder.addValues(valueRowBuilder.build());
        }
    }

    static {
        SYSTEM_GROUP_SET.add("TOOLS_CONSUMER");
        SYSTEM_GROUP_SET.add("FILTERSRV_CONSUMER");
        SYSTEM_GROUP_SET.add("SELF_TEST_C_GROUP");
        SYSTEM_GROUP_SET.add("CID_ONS-HTTP-PROXY");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_PULL");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_PERMISSION");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_OWNER");
        SYSTEM_GROUP_SET.add("CID_RMQ_SYS_TRANS");
    }
}

