/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hertzbeat.alert.dao.AlertDao;
import org.apache.hertzbeat.alert.dto.AlertPriorityNum;
import org.apache.hertzbeat.alert.dto.AlertSummary;
import org.apache.hertzbeat.alert.dto.CloudAlertReportAbstract;
import org.apache.hertzbeat.alert.enums.CloudServiceAlarmInformationEnum;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.dto.AlertReport;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertServiceImpl
implements AlertService {
    private static final Logger log = LoggerFactory.getLogger(AlertServiceImpl.class);
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addAlert(Alert alert) throws RuntimeException {
        this.alertDao.save(alert);
    }

    @Override
    public Page<Alert> getAlerts(List<Long> alarmIds, Long monitorId, Byte priority, Byte status, String content, String sort, String order, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate;
            ArrayList<Object> andList = new ArrayList<Object>();
            if (alarmIds != null && !alarmIds.isEmpty()) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = alarmIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (monitorId != null) {
                predicate = criteriaBuilder.like(root.get("tags").as(String.class), "%" + monitorId + "%");
                andList.add(predicate);
            }
            if (priority != null) {
                predicate = criteriaBuilder.equal((Expression)root.get("priority"), (Object)priority);
                andList.add(predicate);
            }
            if (status != null) {
                predicate = criteriaBuilder.equal((Expression)root.get("status"), (Object)status);
                andList.add(predicate);
            }
            if (content != null && !content.isEmpty()) {
                Predicate predicateContent = criteriaBuilder.like((Expression)root.get("content"), "%" + content + "%");
                andList.add(predicateContent);
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.alertDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void deleteAlerts(HashSet<Long> ids) {
        this.alertDao.deleteAlertsByIdIn(ids);
    }

    @Override
    public void clearAlerts() {
        this.alertDao.deleteAll();
    }

    @Override
    public void editAlertStatus(Byte status, List<Long> ids) {
        this.alertDao.updateAlertsStatus(status, ids);
    }

    @Override
    public AlertSummary getAlertsSummary() {
        AlertSummary alertSummary = new AlertSummary();
        List<AlertPriorityNum> priorityNums = this.alertDao.findAlertPriorityNum();
        if (priorityNums != null) {
            for (AlertPriorityNum priorityNum : priorityNums) {
                switch (priorityNum.getPriority()) {
                    case 2: {
                        alertSummary.setPriorityWarningNum(priorityNum.getNum());
                        break;
                    }
                    case 1: {
                        alertSummary.setPriorityCriticalNum(priorityNum.getNum());
                        break;
                    }
                    case 0: {
                        alertSummary.setPriorityEmergencyNum(priorityNum.getNum());
                        break;
                    }
                }
            }
        }
        long total = this.alertDao.count();
        alertSummary.setTotal(total);
        long dealNum = total - alertSummary.getPriorityCriticalNum() - alertSummary.getPriorityEmergencyNum() - alertSummary.getPriorityWarningNum();
        alertSummary.setDealNum(dealNum);
        try {
            if (total == 0L) {
                alertSummary.setRate(100.0f);
            } else {
                float rate = BigDecimal.valueOf(100.0f * (float)dealNum / (float)total).setScale(2, RoundingMode.HALF_UP).floatValue();
                alertSummary.setRate(rate);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return alertSummary;
    }

    @Override
    public void addNewAlertReport(AlertReport alertReport) {
        this.alarmCommonReduce.reduceAndSendAlarm(this.buildAlertData(alertReport));
    }

    @Override
    public void addNewAlertReportFromCloud(String cloudServiceName, String alertReport) {
        CloudServiceAlarmInformationEnum cloudService = CloudServiceAlarmInformationEnum.getEnumFromCloudServiceName(cloudServiceName);
        AlertReport alert = null;
        if (cloudService != null) {
            try {
                CloudAlertReportAbstract cloudAlertReport = (CloudAlertReportAbstract)JsonUtil.fromJson((String)alertReport, cloudService.getCloudServiceAlarmInformationEntity());
                assert (cloudAlertReport != null);
                alert = AlertReport.builder().content(cloudAlertReport.getContent()).alertName(cloudAlertReport.getAlertName()).alertTime(cloudAlertReport.getAlertTime()).alertDuration(cloudAlertReport.getAlertDuration()).priority(cloudAlertReport.getPriority()).reportType(cloudAlertReport.getReportType()).labels(cloudAlertReport.getLabels()).annotations(cloudAlertReport.getAnnotations()).build();
            }
            catch (Exception e) {
                log.error("[alert report] parse cloud service alarm content failed! cloud service: {} conrent: {}", (Object)cloudService.name(), (Object)alertReport);
            }
        } else {
            alert = AlertReport.builder().content("error do not has cloud service api").alertName("/api/alerts/report/" + cloudServiceName).alertTime(new Date().getTime()).priority(Integer.valueOf(1)).reportType(Integer.valueOf(1)).build();
        }
        Optional.ofNullable(alert).ifPresent(this::addNewAlertReport);
    }

    @Override
    public List<Alert> getAlerts(Specification<Alert> specification) {
        return this.alertDao.findAll(specification);
    }

    private Alert buildAlertData(AlertReport alertReport) {
        Map annotations = alertReport.getAnnotations();
        StringBuilder sb = new StringBuilder();
        if (alertReport.getContent() == null || alertReport.getContent().length() <= 0) {
            StringBuilder finalSb = sb;
            annotations.forEach((k, v) -> finalSb.append((String)k).append(":").append((String)v).append("\n"));
        } else {
            sb = new StringBuilder(alertReport.getContent());
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(alertReport.getAlertTime()), ZoneId.systemDefault());
        return Alert.builder().content("Alert Center\n" + sb).priority(alertReport.getPriority().byteValue()).status((byte)0).tags(alertReport.getLabels()).target(alertReport.getAlertName()).triggerTimes(Integer.valueOf(1)).firstAlarmTime(Long.valueOf(alertReport.getAlertTime())).lastAlarmTime(Long.valueOf(alertReport.getAlertTime())).gmtCreate(dateTime).gmtUpdate(dateTime).build();
    }
}

