/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.dao.AlertDefineBindDao;
import org.apache.hertzbeat.alert.dao.AlertDefineDao;
import org.apache.hertzbeat.alert.dao.AlertMonitorDao;
import org.apache.hertzbeat.alert.service.AlertDefineImExportService;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.AlertDefineMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.util.FileUtil;
import org.apache.hertzbeat.common.util.JexlExpressionRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertDefineServiceImpl
implements AlertDefineService {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineServiceImpl.class);
    @Autowired
    private AlertDefineDao alertDefineDao;
    @Autowired
    private AlertDefineBindDao alertDefineBindDao;
    @Autowired
    private AlertMonitorDao alertMonitorDao;
    private final Map<String, AlertDefineImExportService> alertDefineImExportServiceMap = new HashMap<String, AlertDefineImExportService>();
    private static final String CONTENT_TYPE = "application/octet-stream;charset=" + StandardCharsets.UTF_8;

    public AlertDefineServiceImpl(List<AlertDefineImExportService> alertDefineImExportServiceList) {
        alertDefineImExportServiceList.forEach(it -> this.alertDefineImExportServiceMap.put(it.type(), (AlertDefineImExportService)it));
    }

    @Override
    public void validate(AlertDefine alertDefine, boolean isModify) throws IllegalArgumentException {
        if (StringUtils.hasText((String)alertDefine.getExpr())) {
            try {
                JexlExpressionRunner.compile((String)alertDefine.getExpr());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("alert expr error: " + e.getMessage());
            }
        }
    }

    @Override
    public void addAlertDefine(AlertDefine alertDefine) throws RuntimeException {
        this.alertDefineDao.save(alertDefine);
    }

    @Override
    public void modifyAlertDefine(AlertDefine alertDefine) throws RuntimeException {
        this.alertDefineDao.save(alertDefine);
    }

    @Override
    public void deleteAlertDefine(long alertId) throws RuntimeException {
        this.alertDefineDao.deleteById(alertId);
    }

    @Override
    public AlertDefine getAlertDefine(long alertId) throws RuntimeException {
        Optional optional = this.alertDefineDao.findById(alertId);
        return optional.orElse(null);
    }

    @Override
    public void deleteAlertDefines(Set<Long> alertIds) throws RuntimeException {
        this.alertDefineDao.deleteAlertDefinesByIdIn(alertIds);
    }

    @Override
    public Page<AlertDefine> getMonitorBindAlertDefines(Specification<AlertDefine> specification, PageRequest pageRequest) {
        return this.alertDefineDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void applyBindAlertDefineMonitors(Long alertId, List<AlertDefineMonitorBind> alertDefineBinds) {
        if (!this.alertDefineBindDao.existsById(alertId)) {
            this.alertDefineBindDao.deleteAlertDefineBindsByAlertDefineIdEquals(alertId);
        }
        this.alertDefineBindDao.deleteAlertDefineBindsByAlertDefineIdEquals(alertId);
        this.alertDefineBindDao.saveAll(alertDefineBinds);
    }

    @Override
    public Map<String, List<AlertDefine>> getMonitorBindAlertDefines(long monitorId, String app, String metrics) {
        List<AlertDefine> defines = this.alertDefineDao.queryAlertDefinesByMonitor(monitorId, app, metrics);
        List<AlertDefine> defaultDefines = this.alertDefineDao.queryAlertDefinesByAppAndMetricAndPresetTrueAndEnableTrue(app, metrics);
        defines.addAll(defaultDefines);
        Set defineSet = defines.stream().filter(item -> item.getField() != null).collect(Collectors.toSet());
        return defineSet.stream().sorted(Comparator.comparing(AlertDefine::getPriority)).collect(Collectors.groupingBy(AlertDefine::getField));
    }

    @Override
    public AlertDefine getMonitorBindAlertAvaDefine(long monitorId, String app, String metrics) {
        List<AlertDefine> defines = this.alertDefineDao.queryAlertDefinesByMonitor(monitorId, app, metrics);
        List<AlertDefine> defaultDefines = this.alertDefineDao.queryAlertDefinesByAppAndMetricAndPresetTrueAndEnableTrue(app, metrics);
        defines.addAll(defaultDefines);
        return defines.stream().findFirst().orElse(null);
    }

    @Override
    public Page<AlertDefine> getAlertDefines(List<Long> defineIds, String search, Byte priority, String sort, String order, int pageIndex, int pageSize) {
        ObjectMapper objectMapper = new ObjectMapper();
        List searchList = Collections.emptyList();
        if (StringUtils.hasText((String)search)) {
            try {
                searchList = (List)objectMapper.readValue(URLDecoder.decode(search, StandardCharsets.UTF_8), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to parse search parameter", e);
            }
        }
        List finalSearchList = searchList;
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Object> andList = new ArrayList<Object>();
            if (defineIds != null && !defineIds.isEmpty()) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = defineIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (null != finalSearchList && !finalSearchList.isEmpty()) {
                ArrayList<Predicate> searchPredicates = new ArrayList<Predicate>();
                for (String searchContent : finalSearchList) {
                    searchContent = searchContent.toLowerCase();
                    Predicate predicate = criteriaBuilder.or(new Predicate[]{criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("app")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("metric")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("field")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("expr")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("template")), "%" + searchContent + "%")});
                    searchPredicates.add(predicate);
                }
                andList.add(criteriaBuilder.or(searchPredicates.toArray(new Predicate[0])));
            }
            if (priority != null) {
                Predicate predicate = criteriaBuilder.equal((Expression)root.get("priority"), (Object)priority);
                andList.add(predicate);
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.alertDefineDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public List<AlertDefineMonitorBind> getBindAlertDefineMonitors(long alertDefineId) {
        List<AlertDefineMonitorBind> defineMonitorBinds = this.alertDefineBindDao.getAlertDefineBindsByAlertDefineIdEquals(alertDefineId);
        if (defineMonitorBinds == null || defineMonitorBinds.isEmpty()) {
            return defineMonitorBinds;
        }
        List<Long> needLoadMonitorIds = defineMonitorBinds.stream().filter(bind -> bind.getMonitor() == null).map(AlertDefineMonitorBind::getMonitorId).toList();
        if (needLoadMonitorIds.isEmpty()) {
            return defineMonitorBinds;
        }
        Map monitorMap = this.alertMonitorDao.findAllById(needLoadMonitorIds).stream().collect(Collectors.toMap(Monitor::getId, Function.identity()));
        for (AlertDefineMonitorBind bind2 : defineMonitorBinds) {
            if (bind2.getMonitor() != null) continue;
            bind2.setMonitor((Monitor)monitorMap.get(bind2.getMonitorId()));
        }
        return defineMonitorBinds;
    }

    @Override
    public void export(List<Long> ids, String type, HttpServletResponse res) throws Exception {
        AlertDefineImExportService imExportService = this.alertDefineImExportServiceMap.get(type);
        if (imExportService == null) {
            throw new IllegalArgumentException("not support export type: " + type);
        }
        String fileName = imExportService.getFileName();
        res.setHeader("Content-Type", CONTENT_TYPE);
        res.setContentType(CONTENT_TYPE);
        res.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8));
        res.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        imExportService.exportConfig((OutputStream)res.getOutputStream(), ids);
    }

    @Override
    public void importConfig(MultipartFile file) throws Exception {
        String type = FileUtil.getFileType((MultipartFile)file);
        String fileName = FileUtil.getFileName((MultipartFile)file);
        if (!this.alertDefineImExportServiceMap.containsKey(type)) {
            throw new RuntimeException("file " + fileName + " is not supported.");
        }
        AlertDefineImExportService imExportService = this.alertDefineImExportServiceMap.get(type);
        imExportService.importConfig(file.getInputStream());
    }
}

