/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hertzbeat.alert.dao.AlertConvergeDao;
import org.apache.hertzbeat.alert.service.AlertConvergeService;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.AlertConverge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertConvergeServiceImpl
implements AlertConvergeService {
    private static final Logger log = LoggerFactory.getLogger(AlertConvergeServiceImpl.class);
    @Autowired
    private AlertConvergeDao alertConvergeDao;

    @Override
    public void validate(AlertConverge alertConverge, boolean isModify) throws IllegalArgumentException {
    }

    @Override
    public void addAlertConverge(AlertConverge alertConverge) throws RuntimeException {
        this.alertConvergeDao.save(alertConverge);
        this.clearAlertConvergesCache();
    }

    @Override
    public void modifyAlertConverge(AlertConverge alertConverge) throws RuntimeException {
        this.alertConvergeDao.save(alertConverge);
        this.clearAlertConvergesCache();
    }

    @Override
    public AlertConverge getAlertConverge(long convergeId) throws RuntimeException {
        return this.alertConvergeDao.findById(convergeId).orElse(null);
    }

    @Override
    public void deleteAlertConverges(Set<Long> convergeIds) throws RuntimeException {
        this.alertConvergeDao.deleteAlertConvergesByIdIn(convergeIds);
        this.clearAlertConvergesCache();
    }

    @Override
    public Page<AlertConverge> getAlertConverges(List<Long> convergeIds, String search, String sort, String order, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Object> andList = new ArrayList<Object>();
            if (convergeIds != null && !convergeIds.isEmpty()) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = convergeIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (StringUtils.hasText((String)search)) {
                Predicate predicate = criteriaBuilder.or(new Predicate[]{criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%")});
                andList.add(predicate);
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.alertConvergeDao.findAll(specification, (Pageable)pageRequest);
    }

    private void clearAlertConvergesCache() {
        CommonCacheService convergeCache = CacheFactory.getAlertConvergeCache();
        convergeCache.remove((Object)"alert_converge");
    }
}

