/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hertzbeat.alert.dao.AlertSilenceDao;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.alerter.AlertSilence;
import org.springframework.stereotype.Service;

@Service
public class AlarmSilenceReduce {
    private final AlertSilenceDao alertSilenceDao;

    public boolean filterSilence(Alert alert) {
        CommonCacheService silenceCache = CacheFactory.getAlertSilenceCache();
        List alertSilenceList = (List)silenceCache.get((Object)"alert_silence");
        if (alertSilenceList == null) {
            alertSilenceList = this.alertSilenceDao.findAll();
            silenceCache.put((Object)"alert_silence", (Object)alertSilenceList);
        }
        for (AlertSilence alertSilence : alertSilenceList) {
            boolean dayMatch;
            if (!alertSilence.isEnable()) continue;
            boolean match = alertSilence.isMatchAll();
            if (!match) {
                List tags = alertSilence.getTags();
                if (alert.getTags() != null && !alert.getTags().isEmpty()) {
                    Map alertTagMap = alert.getTags();
                    match = tags.stream().anyMatch(item -> {
                        if (alertTagMap.containsKey(item.getName())) {
                            String tagValue = (String)alertTagMap.get(item.getName());
                            if (tagValue == null && item.getValue() == null) {
                                return true;
                            }
                            return tagValue != null && tagValue.equals(item.getValue());
                        }
                        return false;
                    });
                } else {
                    match = true;
                }
                if (match && alertSilence.getPriorities() != null && !alertSilence.getPriorities().isEmpty()) {
                    match = alertSilence.getPriorities().stream().anyMatch(item -> item != null && item.byteValue() == alert.getPriority());
                }
            }
            if (!match) continue;
            if (alertSilence.getType() == 0) {
                return this.checkAndSave(LocalDateTime.now(), alertSilence);
            }
            if (alertSilence.getType() != 1) continue;
            int currentDayOfWeek = LocalDateTime.now().toLocalDate().getDayOfWeek().getValue();
            if (alertSilence.getDays() == null || alertSilence.getDays().isEmpty() || !(dayMatch = alertSilence.getDays().stream().anyMatch(item -> item == currentDayOfWeek))) continue;
            return this.checkAndSave(LocalDateTime.now(), alertSilence);
        }
        return true;
    }

    private boolean checkAndSave(LocalDateTime times, AlertSilence alertSilence) {
        boolean endMatch;
        boolean startMatch = alertSilence.getPeriodStart() == null || times.isAfter(alertSilence.getPeriodStart().toLocalDateTime());
        boolean bl = endMatch = alertSilence.getPeriodEnd() == null || times.isBefore(alertSilence.getPeriodEnd().toLocalDateTime());
        if (startMatch && endMatch) {
            int time = Optional.ofNullable(alertSilence.getTimes()).orElse(0);
            alertSilence.setTimes(Integer.valueOf(time + 1));
            this.alertSilenceDao.save(alertSilence);
            return false;
        }
        return true;
    }

    public AlarmSilenceReduce(AlertSilenceDao alertSilenceDao) {
        this.alertSilenceDao = alertSilenceDao;
    }
}

