/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.alert.dao.AlertConvergeDao;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.alerter.AlertConverge;
import org.springframework.stereotype.Service;

@Service
public class AlarmConvergeReduce {
    private final AlertConvergeDao alertConvergeDao;
    private final Map<Integer, Alert> converageAlertMap;

    public AlarmConvergeReduce(AlertConvergeDao alertConvergeDao) {
        this.alertConvergeDao = alertConvergeDao;
        this.converageAlertMap = new ConcurrentHashMap<Integer, Alert>(16);
    }

    public boolean filterConverge(Alert currentAlert) {
        if (currentAlert.getTags() != null && currentAlert.getTags().containsKey("ignore") || currentAlert.getStatus() == 2) {
            boolean isHasIgnore = false;
            Map tags = currentAlert.getTags();
            if (Objects.requireNonNull(tags).containsKey("ignore")) {
                isHasIgnore = true;
                tags.remove("ignore");
            }
            int alertHash = this.generateAlertHash((byte)1, tags);
            this.converageAlertMap.remove(alertHash);
            alertHash = this.generateAlertHash((byte)0, tags);
            this.converageAlertMap.remove(alertHash);
            alertHash = this.generateAlertHash((byte)2, tags);
            this.converageAlertMap.remove(alertHash);
            if (isHasIgnore) {
                tags.put("ignore", "ignore");
            }
            return true;
        }
        CommonCacheService convergeCache = CacheFactory.getAlertConvergeCache();
        List alertConvergeList = (List)convergeCache.get((Object)"alert_converge");
        if (alertConvergeList == null) {
            alertConvergeList = this.alertConvergeDao.findAll();
            alertConvergeList.sort((item1, item2) -> {
                if (item1.isMatchAll()) {
                    return 1;
                }
                if (item2.isMatchAll()) {
                    return -1;
                }
                return 0;
            });
            convergeCache.put((Object)"alert_converge", (Object)alertConvergeList);
        }
        for (AlertConverge alertConverge : alertConvergeList) {
            if (!alertConverge.isEnable()) continue;
            boolean match = alertConverge.isMatchAll();
            if (!match) {
                List tags = alertConverge.getTags();
                if (currentAlert.getTags() != null && !currentAlert.getTags().isEmpty()) {
                    Map alertTagMap = currentAlert.getTags();
                    match = tags.stream().anyMatch(item -> {
                        if (alertTagMap.containsKey(item.getName())) {
                            String tagValue = (String)alertTagMap.get(item.getName());
                            if (tagValue == null && item.getValue() == null) {
                                return true;
                            }
                            return tagValue != null && tagValue.equals(item.getValue());
                        }
                        return false;
                    });
                } else {
                    match = true;
                }
                if (match && alertConverge.getPriorities() != null && !alertConverge.getPriorities().isEmpty()) {
                    match = alertConverge.getPriorities().stream().anyMatch(item -> item != null && item.byteValue() == currentAlert.getPriority());
                }
            }
            if (!match) continue;
            long evalInterval = (long)alertConverge.getEvalInterval().intValue() * 1000L;
            long now = System.currentTimeMillis();
            if (evalInterval <= 0L) {
                return true;
            }
            int alertHash = this.generateAlertHash(currentAlert.getPriority(), currentAlert.getTags());
            Alert preAlert = this.converageAlertMap.get(alertHash);
            if (preAlert == null) {
                currentAlert.setTimes(Integer.valueOf(1));
                currentAlert.setFirstAlarmTime(Long.valueOf(now));
                currentAlert.setLastAlarmTime(Long.valueOf(now));
                this.converageAlertMap.put(alertHash, currentAlert.clone());
                return true;
            }
            if (now - preAlert.getFirstAlarmTime() < evalInterval) {
                preAlert.setTimes(Integer.valueOf(preAlert.getTimes() + 1));
                preAlert.setLastAlarmTime(Long.valueOf(now));
                return false;
            }
            currentAlert.setTimes(preAlert.getTimes());
            if (preAlert.getTimes() == 1) {
                currentAlert.setFirstAlarmTime(Long.valueOf(now));
            } else {
                currentAlert.setFirstAlarmTime(preAlert.getFirstAlarmTime());
            }
            currentAlert.setLastAlarmTime(Long.valueOf(now));
            preAlert.setFirstAlarmTime(Long.valueOf(now));
            preAlert.setLastAlarmTime(Long.valueOf(now));
            preAlert.setTimes(Integer.valueOf(1));
            return true;
        }
        return true;
    }

    private int generateAlertHash(byte priority, Map<String, String> tags) {
        List<String> keyList = tags.keySet().stream().filter(Objects::nonNull).sorted().toList();
        List<String> valueList = tags.values().stream().filter(Objects::nonNull).sorted().toList();
        return Objects.hash(priority) + Arrays.hashCode(keyList.toArray(new String[0])) + Arrays.hashCode(valueList.toArray(new String[0]));
    }
}

