/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import org.apache.hertzbeat.alert.dto.CloudAlertReportAbstract;
import org.apache.hertzbeat.alert.util.DateUtil;

public class TenCloudAlertReport
extends CloudAlertReportAbstract
implements Serializable {
    @JsonProperty(value="sessionID")
    private String sessionId;
    private String alarmStatus;
    private String alarmType;
    private AlarmObjInfo alarmObjInfo;
    private AlarmPolicyInfo alarmPolicyInfo;
    private String firstOccurTime;
    private int durationTime;
    private String recoverTime;
    private static final String EVENT = "event";
    private static final String METRIC = "metric";

    @Override
    public String getAlertName() {
        return "TenCloud|\u817e\u8baf\u4e91";
    }

    @Override
    public Integer getAlertDuration() {
        return this.durationTime;
    }

    @Override
    public long getAlertTime() {
        return DateUtil.getTimeStampFromFormat(this.getFirstOccurTime(), "yyyy-MM-dd HH:mm:ss").orElse(0L);
    }

    @Override
    public Integer getPriority() {
        return 1;
    }

    @Override
    public Integer getReportType() {
        return 1;
    }

    @Override
    public Map<String, String> getLabels() {
        return Map.of("app", "TenCloud");
    }

    @Override
    public Map<String, String> getAnnotations() {
        return Map.of("app", "TenCloud");
    }

    @Override
    public String getContent() {
        StringBuilder contentBuilder = new StringBuilder();
        if (EVENT.equals(this.getAlarmType())) {
            contentBuilder.append("[").append("\u544a\u8b66\u72b6\u6001 | ").append("0".equals(this.alarmStatus) ? "\u6062\u590d" : "\u544a\u8b66").append("]\n").append("[").append("\u544a\u8b66\u5bf9\u8c61\u4fe1\u606f | ").append((String)(this.getAlarmObjInfo().getRegion() == null ? "" : "region:" + this.getAlarmObjInfo().getRegion())).append(";").append("appId:").append(this.getAlarmObjInfo().getAppId()).append(";").append("uni:").append(this.getAlarmObjInfo().getUin()).append(";").append("unInstanceId:").append(this.getAlarmObjInfo().getDimensions().getUnInstanceId()).append("]\n").append("[").append("\u544a\u8b66\u7b56\u7565\u7ec4\u4fe1\u606f | ").append("\u540d\u79f0\uff1a").append(this.getAlarmPolicyInfo().getPolicyName()).append(";").append("\u7b56\u7565\u7c7b\u578b\u5c55\u793a\u540d\u79f0\uff1a").append(this.getAlarmPolicyInfo().getConditions().getProductName()).append(",").append(this.getAlarmPolicyInfo().getConditions().getProductShowName()).append(";").append("\u4e8b\u4ef6\u544a\u8b66\u540d\u79f0\uff1a").append(this.getAlarmPolicyInfo().getConditions().getEventName()).append(",").append(this.getAlarmPolicyInfo().getConditions().getEventShowName()).append("]");
        } else if (METRIC.equals(this.getAlarmType())) {
            contentBuilder.append("[").append("\u544a\u8b66\u5bf9\u8c61\uff1a").append(this.getAlarmObjInfo().getRegion() == null ? "" : this.getAlarmObjInfo().getRegion()).append(this.getAlarmObjInfo().getRegion() == null ? "" : "|").append(this.getAlarmObjInfo().getNamespace()).append("]").append("[").append("\u544a\u8b66\u5185\u5bb9\uff1a").append(this.getAlarmPolicyInfo().getPolicyTypeCname()).append("|").append(this.getAlarmPolicyInfo().getConditions().getMetricShowName()).append("|").append(this.getAlarmPolicyInfo().getConditions().getMetricName()).append(this.getAlarmPolicyInfo().getConditions().getCalcType()).append(this.getAlarmPolicyInfo().getConditions().getCalcValue()).append(this.getAlarmPolicyInfo().getConditions().getCalcUnit()).append("]").append("[").append("\u5f53\u524d\u6570\u636e").append(this.getAlarmPolicyInfo().getConditions().getCurrentValue()).append(this.getAlarmPolicyInfo().getConditions().getCalcUnit()).append("]");
        }
        return contentBuilder.toString();
    }

    public static TenCloudAlertReportBuilder builder() {
        return new TenCloudAlertReportBuilder();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getAlarmStatus() {
        return this.alarmStatus;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public AlarmObjInfo getAlarmObjInfo() {
        return this.alarmObjInfo;
    }

    public AlarmPolicyInfo getAlarmPolicyInfo() {
        return this.alarmPolicyInfo;
    }

    public String getFirstOccurTime() {
        return this.firstOccurTime;
    }

    public int getDurationTime() {
        return this.durationTime;
    }

    public String getRecoverTime() {
        return this.recoverTime;
    }

    @JsonProperty(value="sessionID")
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setAlarmStatus(String alarmStatus) {
        this.alarmStatus = alarmStatus;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public void setAlarmObjInfo(AlarmObjInfo alarmObjInfo) {
        this.alarmObjInfo = alarmObjInfo;
    }

    public void setAlarmPolicyInfo(AlarmPolicyInfo alarmPolicyInfo) {
        this.alarmPolicyInfo = alarmPolicyInfo;
    }

    public void setFirstOccurTime(String firstOccurTime) {
        this.firstOccurTime = firstOccurTime;
    }

    public void setDurationTime(int durationTime) {
        this.durationTime = durationTime;
    }

    public void setRecoverTime(String recoverTime) {
        this.recoverTime = recoverTime;
    }

    public String toString() {
        return "TenCloudAlertReport(sessionId=" + this.getSessionId() + ", alarmStatus=" + this.getAlarmStatus() + ", alarmType=" + this.getAlarmType() + ", alarmObjInfo=" + this.getAlarmObjInfo() + ", alarmPolicyInfo=" + this.getAlarmPolicyInfo() + ", firstOccurTime=" + this.getFirstOccurTime() + ", durationTime=" + this.getDurationTime() + ", recoverTime=" + this.getRecoverTime() + ")";
    }

    public TenCloudAlertReport(String sessionId, String alarmStatus, String alarmType, AlarmObjInfo alarmObjInfo, AlarmPolicyInfo alarmPolicyInfo, String firstOccurTime, int durationTime, String recoverTime) {
        this.sessionId = sessionId;
        this.alarmStatus = alarmStatus;
        this.alarmType = alarmType;
        this.alarmObjInfo = alarmObjInfo;
        this.alarmPolicyInfo = alarmPolicyInfo;
        this.firstOccurTime = firstOccurTime;
        this.durationTime = durationTime;
        this.recoverTime = recoverTime;
    }

    public TenCloudAlertReport() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenCloudAlertReport)) {
            return false;
        }
        TenCloudAlertReport other = (TenCloudAlertReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDurationTime() != other.getDurationTime()) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$alarmStatus = this.getAlarmStatus();
        String other$alarmStatus = other.getAlarmStatus();
        if (this$alarmStatus == null ? other$alarmStatus != null : !this$alarmStatus.equals(other$alarmStatus)) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        if (this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType)) {
            return false;
        }
        AlarmObjInfo this$alarmObjInfo = this.getAlarmObjInfo();
        AlarmObjInfo other$alarmObjInfo = other.getAlarmObjInfo();
        if (this$alarmObjInfo == null ? other$alarmObjInfo != null : !((Object)this$alarmObjInfo).equals(other$alarmObjInfo)) {
            return false;
        }
        AlarmPolicyInfo this$alarmPolicyInfo = this.getAlarmPolicyInfo();
        AlarmPolicyInfo other$alarmPolicyInfo = other.getAlarmPolicyInfo();
        if (this$alarmPolicyInfo == null ? other$alarmPolicyInfo != null : !((Object)this$alarmPolicyInfo).equals(other$alarmPolicyInfo)) {
            return false;
        }
        String this$firstOccurTime = this.getFirstOccurTime();
        String other$firstOccurTime = other.getFirstOccurTime();
        if (this$firstOccurTime == null ? other$firstOccurTime != null : !this$firstOccurTime.equals(other$firstOccurTime)) {
            return false;
        }
        String this$recoverTime = this.getRecoverTime();
        String other$recoverTime = other.getRecoverTime();
        return !(this$recoverTime == null ? other$recoverTime != null : !this$recoverTime.equals(other$recoverTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenCloudAlertReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDurationTime();
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $alarmStatus = this.getAlarmStatus();
        result = result * 59 + ($alarmStatus == null ? 43 : $alarmStatus.hashCode());
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        AlarmObjInfo $alarmObjInfo = this.getAlarmObjInfo();
        result = result * 59 + ($alarmObjInfo == null ? 43 : ((Object)$alarmObjInfo).hashCode());
        AlarmPolicyInfo $alarmPolicyInfo = this.getAlarmPolicyInfo();
        result = result * 59 + ($alarmPolicyInfo == null ? 43 : ((Object)$alarmPolicyInfo).hashCode());
        String $firstOccurTime = this.getFirstOccurTime();
        result = result * 59 + ($firstOccurTime == null ? 43 : $firstOccurTime.hashCode());
        String $recoverTime = this.getRecoverTime();
        result = result * 59 + ($recoverTime == null ? 43 : $recoverTime.hashCode());
        return result;
    }

    public static class AlarmObjInfo {
        private String region;
        private String namespace;
        @JsonProperty(value="appID")
        private String appId;
        private String uin;
        private Dimensions dimensions;

        public String getRegion() {
            return this.region;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getUin() {
            return this.uin;
        }

        public Dimensions getDimensions() {
            return this.dimensions;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @JsonProperty(value="appID")
        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setUin(String uin) {
            this.uin = uin;
        }

        public void setDimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlarmObjInfo)) {
                return false;
            }
            AlarmObjInfo other = (AlarmObjInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                return false;
            }
            String this$uin = this.getUin();
            String other$uin = other.getUin();
            if (this$uin == null ? other$uin != null : !this$uin.equals(other$uin)) {
                return false;
            }
            Dimensions this$dimensions = this.getDimensions();
            Dimensions other$dimensions = other.getDimensions();
            return !(this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlarmObjInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            String $uin = this.getUin();
            result = result * 59 + ($uin == null ? 43 : $uin.hashCode());
            Dimensions $dimensions = this.getDimensions();
            result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
            return result;
        }

        public String toString() {
            return "TenCloudAlertReport.AlarmObjInfo(region=" + this.getRegion() + ", namespace=" + this.getNamespace() + ", appId=" + this.getAppId() + ", uin=" + this.getUin() + ", dimensions=" + this.getDimensions() + ")";
        }

        public AlarmObjInfo(String region, String namespace, String appId, String uin, Dimensions dimensions) {
            this.region = region;
            this.namespace = namespace;
            this.appId = appId;
            this.uin = uin;
            this.dimensions = dimensions;
        }

        public AlarmObjInfo() {
        }
    }

    public static class Dimensions {
        @JsonProperty(value="unInstanceID")
        private String unInstanceId;
        @JsonProperty(value="objID")
        private String objId;

        public String getUnInstanceId() {
            return this.unInstanceId;
        }

        public String getObjId() {
            return this.objId;
        }

        @JsonProperty(value="unInstanceID")
        public void setUnInstanceId(String unInstanceId) {
            this.unInstanceId = unInstanceId;
        }

        @JsonProperty(value="objID")
        public void setObjId(String objId) {
            this.objId = objId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dimensions)) {
                return false;
            }
            Dimensions other = (Dimensions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$unInstanceId = this.getUnInstanceId();
            String other$unInstanceId = other.getUnInstanceId();
            if (this$unInstanceId == null ? other$unInstanceId != null : !this$unInstanceId.equals(other$unInstanceId)) {
                return false;
            }
            String this$objId = this.getObjId();
            String other$objId = other.getObjId();
            return !(this$objId == null ? other$objId != null : !this$objId.equals(other$objId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Dimensions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $unInstanceId = this.getUnInstanceId();
            result = result * 59 + ($unInstanceId == null ? 43 : $unInstanceId.hashCode());
            String $objId = this.getObjId();
            result = result * 59 + ($objId == null ? 43 : $objId.hashCode());
            return result;
        }

        public String toString() {
            return "TenCloudAlertReport.Dimensions(unInstanceId=" + this.getUnInstanceId() + ", objId=" + this.getObjId() + ")";
        }

        public Dimensions(String unInstanceId, String objId) {
            this.unInstanceId = unInstanceId;
            this.objId = objId;
        }

        public Dimensions() {
        }
    }

    public static class AlarmPolicyInfo {
        @JsonProperty(value="policyID")
        private String policyId;
        private String policyType;
        private String policyName;
        @JsonProperty(value="policyTypeCName")
        private String policyTypeCname;
        private Conditions conditions;

        public String getPolicyId() {
            return this.policyId;
        }

        public String getPolicyType() {
            return this.policyType;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public String getPolicyTypeCname() {
            return this.policyTypeCname;
        }

        public Conditions getConditions() {
            return this.conditions;
        }

        @JsonProperty(value="policyID")
        public void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @JsonProperty(value="policyTypeCName")
        public void setPolicyTypeCname(String policyTypeCname) {
            this.policyTypeCname = policyTypeCname;
        }

        public void setConditions(Conditions conditions) {
            this.conditions = conditions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlarmPolicyInfo)) {
                return false;
            }
            AlarmPolicyInfo other = (AlarmPolicyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$policyId = this.getPolicyId();
            String other$policyId = other.getPolicyId();
            if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
                return false;
            }
            String this$policyType = this.getPolicyType();
            String other$policyType = other.getPolicyType();
            if (this$policyType == null ? other$policyType != null : !this$policyType.equals(other$policyType)) {
                return false;
            }
            String this$policyName = this.getPolicyName();
            String other$policyName = other.getPolicyName();
            if (this$policyName == null ? other$policyName != null : !this$policyName.equals(other$policyName)) {
                return false;
            }
            String this$policyTypeCname = this.getPolicyTypeCname();
            String other$policyTypeCname = other.getPolicyTypeCname();
            if (this$policyTypeCname == null ? other$policyTypeCname != null : !this$policyTypeCname.equals(other$policyTypeCname)) {
                return false;
            }
            Conditions this$conditions = this.getConditions();
            Conditions other$conditions = other.getConditions();
            return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlarmPolicyInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $policyId = this.getPolicyId();
            result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
            String $policyType = this.getPolicyType();
            result = result * 59 + ($policyType == null ? 43 : $policyType.hashCode());
            String $policyName = this.getPolicyName();
            result = result * 59 + ($policyName == null ? 43 : $policyName.hashCode());
            String $policyTypeCname = this.getPolicyTypeCname();
            result = result * 59 + ($policyTypeCname == null ? 43 : $policyTypeCname.hashCode());
            Conditions $conditions = this.getConditions();
            result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
            return result;
        }

        public String toString() {
            return "TenCloudAlertReport.AlarmPolicyInfo(policyId=" + this.getPolicyId() + ", policyType=" + this.getPolicyType() + ", policyName=" + this.getPolicyName() + ", policyTypeCname=" + this.getPolicyTypeCname() + ", conditions=" + this.getConditions() + ")";
        }

        public AlarmPolicyInfo(String policyId, String policyType, String policyName, String policyTypeCname, Conditions conditions) {
            this.policyId = policyId;
            this.policyType = policyType;
            this.policyName = policyName;
            this.policyTypeCname = policyTypeCname;
            this.conditions = conditions;
        }

        public AlarmPolicyInfo() {
        }
    }

    public static class Conditions {
        private String metricName;
        private String metricShowName;
        private String calcType;
        private String calcValue;
        private String calcUnit;
        private String currentValue;
        private String historyValue;
        private String unit;
        private String period;
        private String periodNum;
        private String alarmNotifyType;
        private long alarmNotifyPeriod;
        private String productName;
        private String productShowName;
        private String eventName;
        private String eventShowName;

        public String getMetricName() {
            return this.metricName;
        }

        public String getMetricShowName() {
            return this.metricShowName;
        }

        public String getCalcType() {
            return this.calcType;
        }

        public String getCalcValue() {
            return this.calcValue;
        }

        public String getCalcUnit() {
            return this.calcUnit;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public String getHistoryValue() {
            return this.historyValue;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getPeriod() {
            return this.period;
        }

        public String getPeriodNum() {
            return this.periodNum;
        }

        public String getAlarmNotifyType() {
            return this.alarmNotifyType;
        }

        public long getAlarmNotifyPeriod() {
            return this.alarmNotifyPeriod;
        }

        public String getProductName() {
            return this.productName;
        }

        public String getProductShowName() {
            return this.productShowName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getEventShowName() {
            return this.eventShowName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public void setMetricShowName(String metricShowName) {
            this.metricShowName = metricShowName;
        }

        public void setCalcType(String calcType) {
            this.calcType = calcType;
        }

        public void setCalcValue(String calcValue) {
            this.calcValue = calcValue;
        }

        public void setCalcUnit(String calcUnit) {
            this.calcUnit = calcUnit;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }

        public void setHistoryValue(String historyValue) {
            this.historyValue = historyValue;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public void setPeriodNum(String periodNum) {
            this.periodNum = periodNum;
        }

        public void setAlarmNotifyType(String alarmNotifyType) {
            this.alarmNotifyType = alarmNotifyType;
        }

        public void setAlarmNotifyPeriod(long alarmNotifyPeriod) {
            this.alarmNotifyPeriod = alarmNotifyPeriod;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        public void setProductShowName(String productShowName) {
            this.productShowName = productShowName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public void setEventShowName(String eventShowName) {
            this.eventShowName = eventShowName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conditions)) {
                return false;
            }
            Conditions other = (Conditions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAlarmNotifyPeriod() != other.getAlarmNotifyPeriod()) {
                return false;
            }
            String this$metricName = this.getMetricName();
            String other$metricName = other.getMetricName();
            if (this$metricName == null ? other$metricName != null : !this$metricName.equals(other$metricName)) {
                return false;
            }
            String this$metricShowName = this.getMetricShowName();
            String other$metricShowName = other.getMetricShowName();
            if (this$metricShowName == null ? other$metricShowName != null : !this$metricShowName.equals(other$metricShowName)) {
                return false;
            }
            String this$calcType = this.getCalcType();
            String other$calcType = other.getCalcType();
            if (this$calcType == null ? other$calcType != null : !this$calcType.equals(other$calcType)) {
                return false;
            }
            String this$calcValue = this.getCalcValue();
            String other$calcValue = other.getCalcValue();
            if (this$calcValue == null ? other$calcValue != null : !this$calcValue.equals(other$calcValue)) {
                return false;
            }
            String this$calcUnit = this.getCalcUnit();
            String other$calcUnit = other.getCalcUnit();
            if (this$calcUnit == null ? other$calcUnit != null : !this$calcUnit.equals(other$calcUnit)) {
                return false;
            }
            String this$currentValue = this.getCurrentValue();
            String other$currentValue = other.getCurrentValue();
            if (this$currentValue == null ? other$currentValue != null : !this$currentValue.equals(other$currentValue)) {
                return false;
            }
            String this$historyValue = this.getHistoryValue();
            String other$historyValue = other.getHistoryValue();
            if (this$historyValue == null ? other$historyValue != null : !this$historyValue.equals(other$historyValue)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                return false;
            }
            String this$period = this.getPeriod();
            String other$period = other.getPeriod();
            if (this$period == null ? other$period != null : !this$period.equals(other$period)) {
                return false;
            }
            String this$periodNum = this.getPeriodNum();
            String other$periodNum = other.getPeriodNum();
            if (this$periodNum == null ? other$periodNum != null : !this$periodNum.equals(other$periodNum)) {
                return false;
            }
            String this$alarmNotifyType = this.getAlarmNotifyType();
            String other$alarmNotifyType = other.getAlarmNotifyType();
            if (this$alarmNotifyType == null ? other$alarmNotifyType != null : !this$alarmNotifyType.equals(other$alarmNotifyType)) {
                return false;
            }
            String this$productName = this.getProductName();
            String other$productName = other.getProductName();
            if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
                return false;
            }
            String this$productShowName = this.getProductShowName();
            String other$productShowName = other.getProductShowName();
            if (this$productShowName == null ? other$productShowName != null : !this$productShowName.equals(other$productShowName)) {
                return false;
            }
            String this$eventName = this.getEventName();
            String other$eventName = other.getEventName();
            if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
                return false;
            }
            String this$eventShowName = this.getEventShowName();
            String other$eventShowName = other.getEventShowName();
            return !(this$eventShowName == null ? other$eventShowName != null : !this$eventShowName.equals(other$eventShowName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conditions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $alarmNotifyPeriod = this.getAlarmNotifyPeriod();
            result = result * 59 + (int)($alarmNotifyPeriod >>> 32 ^ $alarmNotifyPeriod);
            String $metricName = this.getMetricName();
            result = result * 59 + ($metricName == null ? 43 : $metricName.hashCode());
            String $metricShowName = this.getMetricShowName();
            result = result * 59 + ($metricShowName == null ? 43 : $metricShowName.hashCode());
            String $calcType = this.getCalcType();
            result = result * 59 + ($calcType == null ? 43 : $calcType.hashCode());
            String $calcValue = this.getCalcValue();
            result = result * 59 + ($calcValue == null ? 43 : $calcValue.hashCode());
            String $calcUnit = this.getCalcUnit();
            result = result * 59 + ($calcUnit == null ? 43 : $calcUnit.hashCode());
            String $currentValue = this.getCurrentValue();
            result = result * 59 + ($currentValue == null ? 43 : $currentValue.hashCode());
            String $historyValue = this.getHistoryValue();
            result = result * 59 + ($historyValue == null ? 43 : $historyValue.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            String $period = this.getPeriod();
            result = result * 59 + ($period == null ? 43 : $period.hashCode());
            String $periodNum = this.getPeriodNum();
            result = result * 59 + ($periodNum == null ? 43 : $periodNum.hashCode());
            String $alarmNotifyType = this.getAlarmNotifyType();
            result = result * 59 + ($alarmNotifyType == null ? 43 : $alarmNotifyType.hashCode());
            String $productName = this.getProductName();
            result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
            String $productShowName = this.getProductShowName();
            result = result * 59 + ($productShowName == null ? 43 : $productShowName.hashCode());
            String $eventName = this.getEventName();
            result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
            String $eventShowName = this.getEventShowName();
            result = result * 59 + ($eventShowName == null ? 43 : $eventShowName.hashCode());
            return result;
        }

        public String toString() {
            return "TenCloudAlertReport.Conditions(metricName=" + this.getMetricName() + ", metricShowName=" + this.getMetricShowName() + ", calcType=" + this.getCalcType() + ", calcValue=" + this.getCalcValue() + ", calcUnit=" + this.getCalcUnit() + ", currentValue=" + this.getCurrentValue() + ", historyValue=" + this.getHistoryValue() + ", unit=" + this.getUnit() + ", period=" + this.getPeriod() + ", periodNum=" + this.getPeriodNum() + ", alarmNotifyType=" + this.getAlarmNotifyType() + ", alarmNotifyPeriod=" + this.getAlarmNotifyPeriod() + ", productName=" + this.getProductName() + ", productShowName=" + this.getProductShowName() + ", eventName=" + this.getEventName() + ", eventShowName=" + this.getEventShowName() + ")";
        }

        public Conditions(String metricName, String metricShowName, String calcType, String calcValue, String calcUnit, String currentValue, String historyValue, String unit, String period, String periodNum, String alarmNotifyType, long alarmNotifyPeriod, String productName, String productShowName, String eventName, String eventShowName) {
            this.metricName = metricName;
            this.metricShowName = metricShowName;
            this.calcType = calcType;
            this.calcValue = calcValue;
            this.calcUnit = calcUnit;
            this.currentValue = currentValue;
            this.historyValue = historyValue;
            this.unit = unit;
            this.period = period;
            this.periodNum = periodNum;
            this.alarmNotifyType = alarmNotifyType;
            this.alarmNotifyPeriod = alarmNotifyPeriod;
            this.productName = productName;
            this.productShowName = productShowName;
            this.eventName = eventName;
            this.eventShowName = eventShowName;
        }

        public Conditions() {
        }
    }

    public static class TenCloudAlertReportBuilder {
        private String sessionId;
        private String alarmStatus;
        private String alarmType;
        private AlarmObjInfo alarmObjInfo;
        private AlarmPolicyInfo alarmPolicyInfo;
        private String firstOccurTime;
        private int durationTime;
        private String recoverTime;

        TenCloudAlertReportBuilder() {
        }

        @JsonProperty(value="sessionID")
        public TenCloudAlertReportBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public TenCloudAlertReportBuilder alarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
            return this;
        }

        public TenCloudAlertReportBuilder alarmType(String alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        public TenCloudAlertReportBuilder alarmObjInfo(AlarmObjInfo alarmObjInfo) {
            this.alarmObjInfo = alarmObjInfo;
            return this;
        }

        public TenCloudAlertReportBuilder alarmPolicyInfo(AlarmPolicyInfo alarmPolicyInfo) {
            this.alarmPolicyInfo = alarmPolicyInfo;
            return this;
        }

        public TenCloudAlertReportBuilder firstOccurTime(String firstOccurTime) {
            this.firstOccurTime = firstOccurTime;
            return this;
        }

        public TenCloudAlertReportBuilder durationTime(int durationTime) {
            this.durationTime = durationTime;
            return this;
        }

        public TenCloudAlertReportBuilder recoverTime(String recoverTime) {
            this.recoverTime = recoverTime;
            return this;
        }

        public TenCloudAlertReport build() {
            return new TenCloudAlertReport(this.sessionId, this.alarmStatus, this.alarmType, this.alarmObjInfo, this.alarmPolicyInfo, this.firstOccurTime, this.durationTime, this.recoverTime);
        }

        public String toString() {
            return "TenCloudAlertReport.TenCloudAlertReportBuilder(sessionId=" + this.sessionId + ", alarmStatus=" + this.alarmStatus + ", alarmType=" + this.alarmType + ", alarmObjInfo=" + this.alarmObjInfo + ", alarmPolicyInfo=" + this.alarmPolicyInfo + ", firstOccurTime=" + this.firstOccurTime + ", durationTime=" + this.durationTime + ", recoverTime=" + this.recoverTime + ")";
        }
    }
}

