/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.dto;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.util.DateUtil;
import org.apache.hertzbeat.common.entity.dto.AlertReport;

public class GeneralCloudAlertReport
extends AlertReport {
    private String alertDateTime;
    private String dateTimeFormat;

    public void refreshAlertTime() {
        if (this.getAlertTime() != 0L) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.alertDateTime)) {
            Optional<Long> tsf;
            boolean present;
            Long timeStamp = null;
            if (StringUtils.isNotBlank((CharSequence)this.dateTimeFormat) && (present = (tsf = DateUtil.getTimeStampFromFormat(this.alertDateTime, this.dateTimeFormat)).isPresent())) {
                timeStamp = tsf.get();
            }
            if (timeStamp == null && (present = (tsf = DateUtil.getTimeStampFromSomeFormats(this.alertDateTime)).isPresent())) {
                timeStamp = tsf.get();
            }
            if (timeStamp != null) {
                this.setAlertTime(timeStamp);
                return;
            }
        }
        throw new RuntimeException("parse alarm time error");
    }

    public String getAlertDateTime() {
        return this.alertDateTime;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setAlertDateTime(String alertDateTime) {
        this.alertDateTime = alertDateTime;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String toString() {
        return "GeneralCloudAlertReport(alertDateTime=" + this.getAlertDateTime() + ", dateTimeFormat=" + this.getDateTimeFormat() + ")";
    }

    public GeneralCloudAlertReport(String alertDateTime, String dateTimeFormat) {
        this.alertDateTime = alertDateTime;
        this.dateTimeFormat = dateTimeFormat;
    }

    public GeneralCloudAlertReport() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralCloudAlertReport)) {
            return false;
        }
        GeneralCloudAlertReport other = (GeneralCloudAlertReport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$alertDateTime = this.getAlertDateTime();
        String other$alertDateTime = other.getAlertDateTime();
        if (this$alertDateTime == null ? other$alertDateTime != null : !this$alertDateTime.equals(other$alertDateTime)) {
            return false;
        }
        String this$dateTimeFormat = this.getDateTimeFormat();
        String other$dateTimeFormat = other.getDateTimeFormat();
        return !(this$dateTimeFormat == null ? other$dateTimeFormat != null : !this$dateTimeFormat.equals(other$dateTimeFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralCloudAlertReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $alertDateTime = this.getAlertDateTime();
        result = result * 59 + ($alertDateTime == null ? 43 : $alertDateTime.hashCode());
        String $dateTimeFormat = this.getDateTimeFormat();
        result = result * 59 + ($dateTimeFormat == null ? 43 : $dateTimeFormat.hashCode());
        return result;
    }
}

