/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.hertzbeat.alert.dto.GeneralCloudAlertReport;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Extern Alarm Manage API")
@RestController
@RequestMapping(path={"/api/alerts/report"}, produces={"application/json"})
public class AlertReportController {
    private static final Logger log = LoggerFactory.getLogger(AlertReportController.class);
    @Autowired
    private AlertService alertService;

    @PostMapping(value={"/{cloud}"})
    @Operation(summary="Interface for reporting external alarm information of cloud service")
    public ResponseEntity<Message<Void>> addNewAlertReportFromCloud(@PathVariable(value="cloud") String cloudServiceName, @RequestBody String alertReport) {
        this.alertService.addNewAlertReportFromCloud(cloudServiceName, alertReport);
        return ResponseEntity.ok((Object)Message.success((String)"Add report success"));
    }

    @PostMapping
    @Operation(summary="Interface for reporting external and general alarm information", description="The interface is used to report external and general alarm information")
    public ResponseEntity<Message<Void>> addNewAlertReport(@RequestBody GeneralCloudAlertReport alertReport) {
        alertReport.refreshAlertTime();
        this.alertService.addNewAlertReport(alertReport);
        return ResponseEntity.ok((Object)Message.success((String)"Add report success"));
    }
}

