/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.AlerterWorkerPool;
import org.apache.hertzbeat.alert.dao.AlertMonitorDao;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.alert.util.AlertTemplateUtil;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.support.event.MonitorDeletedEvent;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JexlExpressionRunner;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CalculateAlarm {
    private static final Logger log = LoggerFactory.getLogger(CalculateAlarm.class);
    private static final String SYSTEM_VALUE_ROW_COUNT = "system_value_row_count";
    private static final int CALCULATE_THREADS = 3;
    private final Map<String, Alert> triggeredAlertMap;
    private final Map<String, Alert> notRecoveredAlertMap;
    private final AlerterWorkerPool workerPool;
    private final CommonDataQueue dataQueue;
    private final AlertDefineService alertDefineService;
    private final AlarmCommonReduce alarmCommonReduce;
    private ResourceBundle bundle;
    private final AlertService alertService;

    public CalculateAlarm(AlerterWorkerPool workerPool, CommonDataQueue dataQueue, AlertDefineService alertDefineService, AlertMonitorDao monitorDao, AlarmCommonReduce alarmCommonReduce, AlertService alertService) {
        this.workerPool = workerPool;
        this.dataQueue = dataQueue;
        this.alarmCommonReduce = alarmCommonReduce;
        this.alertDefineService = alertDefineService;
        this.alertService = alertService;
        this.bundle = ResourceBundleUtil.getBundle((String)"alerter");
        this.triggeredAlertMap = new ConcurrentHashMap<String, Alert>(16);
        this.notRecoveredAlertMap = new ConcurrentHashMap<String, Alert>(16);
        List<Monitor> monitors = monitorDao.findMonitorsByStatus((byte)2);
        if (monitors != null) {
            for (Monitor monitor : monitors) {
                HashMap<String, String> tags = new HashMap<String, String>(8);
                tags.put("monitorId", String.valueOf(monitor.getId()));
                tags.put("monitorName", monitor.getName());
                tags.put("app", monitor.getApp());
                this.notRecoveredAlertMap.put(monitor.getId() + "availability", Alert.builder().tags(tags).target("availability").status((byte)0).build());
            }
        }
        this.startCalculate();
    }

    private void startCalculate() {
        Runnable runnable = () -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = this.dataQueue.pollMetricsDataToAlerter();
                    if (metricsData == null) continue;
                    this.calculate(metricsData);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error("calculate alarm error: {}.", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        for (int i = 0; i < 3; ++i) {
            this.workerPool.executeJob(runnable);
        }
    }

    private void calculate(CollectRep.MetricsData metricsData) {
        Map<String, List<AlertDefine>> defineMap;
        long currentTimeMilli = System.currentTimeMillis();
        long monitorId = metricsData.getId();
        String app = metricsData.getApp();
        if (app.startsWith("_prometheus_")) {
            app = "prometheus";
        }
        String metrics = metricsData.getMetrics();
        if (metricsData.getPriority() == 0) {
            this.handlerAvailableMetrics(monitorId, app, metricsData);
        }
        if ((defineMap = this.alertDefineService.getMonitorBindAlertDefines(monitorId, app, metrics)).isEmpty()) {
            return;
        }
        List fields = metricsData.getFieldsList();
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
        int valueRowCount = metricsData.getValuesCount();
        for (Map.Entry<String, List<AlertDefine>> entry : defineMap.entrySet()) {
            List<AlertDefine> defines = entry.getValue();
            for (AlertDefine define : defines) {
                String expr = define.getExpr();
                if (StringUtils.isBlank((CharSequence)expr)) continue;
                if (expr.contains(SYSTEM_VALUE_ROW_COUNT) && metricsData.getValuesCount() == 0) {
                    fieldValueMap.put(SYSTEM_VALUE_ROW_COUNT, valueRowCount);
                    try {
                        boolean match = this.execAlertExpression(fieldValueMap, expr);
                        try {
                            if (match) {
                                this.afterThresholdRuleMatch(currentTimeMilli, monitorId, app, metrics, "", fieldValueMap, define);
                                continue;
                            }
                            String alarmKey = String.valueOf(monitorId) + define.getId();
                            this.triggeredAlertMap.remove(alarmKey);
                            if (define.isRecoverNotice()) {
                                this.handleRecoveredAlert(currentTimeMilli, define, expr, alarmKey);
                            }
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (CollectRep.ValueRow valueRow : metricsData.getValuesList()) {
                    if (CollectionUtils.isEmpty((Collection)valueRow.getColumnsList())) continue;
                    fieldValueMap.clear();
                    fieldValueMap.put(SYSTEM_VALUE_ROW_COUNT, valueRowCount);
                    StringBuilder tagBuilder = new StringBuilder();
                    for (int index = 0; index < valueRow.getColumnsList().size(); ++index) {
                        String valueStr = valueRow.getColumns(index);
                        if ("&nbsp;".equals(valueStr)) continue;
                        CollectRep.Field field = (CollectRep.Field)fields.get(index);
                        int fieldType = field.getType();
                        if (fieldType == 0) {
                            Double doubleValue = CommonUtil.parseStrDouble((String)valueStr);
                            if (doubleValue != null) {
                                fieldValueMap.put(field.getName(), doubleValue);
                            }
                        } else if (fieldType == 3) {
                            Integer integerValue = CommonUtil.parseStrInteger((String)valueStr);
                            if (integerValue != null) {
                                fieldValueMap.put(field.getName(), integerValue);
                            }
                        } else if (StringUtils.isNotEmpty((CharSequence)valueStr)) {
                            fieldValueMap.put(field.getName(), valueStr);
                        }
                        if (!field.getLabel()) continue;
                        tagBuilder.append("-").append(valueStr);
                    }
                    try {
                        boolean match = this.execAlertExpression(fieldValueMap, expr);
                        try {
                            if (match) {
                                this.afterThresholdRuleMatch(currentTimeMilli, monitorId, app, metrics, tagBuilder.toString(), fieldValueMap, define);
                                continue;
                            }
                            String alarmKey = String.valueOf(monitorId) + define.getId() + tagBuilder;
                            this.triggeredAlertMap.remove(alarmKey);
                            if (!define.isRecoverNotice()) continue;
                            this.handleRecoveredAlert(currentTimeMilli, define, expr, alarmKey);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void handleRecoveredAlert(long currentTimeMilli, AlertDefine define, String expr, String alarmKey) {
        Alert notResolvedAlert = this.notRecoveredAlertMap.remove(alarmKey);
        if (notResolvedAlert != null) {
            Map tags = notResolvedAlert.getTags();
            String content = this.bundle.getString("alerter.alarm.recover") + " : " + expr;
            Alert resumeAlert = Alert.builder().tags(tags).target(define.getApp() + "." + define.getMetric() + "." + define.getField()).content(content).priority((byte)2).status((byte)2).firstAlarmTime(Long.valueOf(currentTimeMilli)).lastAlarmTime(notResolvedAlert.getLastAlarmTime()).triggerTimes(Integer.valueOf(1)).build();
            this.alarmCommonReduce.reduceAndSendAlarm(resumeAlert);
        }
    }

    private void afterThresholdRuleMatch(long currentTimeMilli, long monitorId, String app, String metrics, String tagStr, Map<String, Object> fieldValueMap, AlertDefine define) {
        String alarmKey = String.valueOf(monitorId) + define.getId() + tagStr;
        Alert triggeredAlert = this.triggeredAlertMap.get(alarmKey);
        if (triggeredAlert != null) {
            int defineTimes;
            int times = triggeredAlert.getTriggerTimes() + 1;
            triggeredAlert.setTriggerTimes(Integer.valueOf(times));
            triggeredAlert.setFirstAlarmTime(Long.valueOf(currentTimeMilli));
            triggeredAlert.setLastAlarmTime(Long.valueOf(currentTimeMilli));
            int n = defineTimes = define.getTimes() == null ? 1 : define.getTimes();
            if (times >= defineTimes) {
                triggeredAlert.setStatus((byte)0);
                this.triggeredAlertMap.remove(alarmKey);
                this.notRecoveredAlertMap.put(alarmKey, triggeredAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(triggeredAlert.clone());
            }
        } else {
            int defineTimes;
            fieldValueMap.put("app", app);
            fieldValueMap.put("metrics", metrics);
            fieldValueMap.put("metric", define.getField());
            HashMap<String, String> tags = new HashMap<String, String>(8);
            tags.put("monitorId", String.valueOf(monitorId));
            tags.put("app", app);
            tags.put("thresholdId", String.valueOf(define.getId()));
            if (!CollectionUtils.isEmpty((Collection)define.getTags())) {
                for (TagItem tagItem : define.getTags()) {
                    fieldValueMap.put(tagItem.getName(), tagItem.getValue());
                    tags.put(tagItem.getName(), tagItem.getValue());
                }
            }
            Alert alert = Alert.builder().tags(tags).priority(define.getPriority()).status((byte)1).target(app + "." + metrics + "." + define.getField()).triggerTimes(Integer.valueOf(1)).firstAlarmTime(Long.valueOf(currentTimeMilli)).lastAlarmTime(Long.valueOf(currentTimeMilli)).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).build();
            int n = defineTimes = define.getTimes() == null ? 1 : define.getTimes();
            if (1 >= defineTimes) {
                alert.setStatus((byte)0);
                this.notRecoveredAlertMap.put(alarmKey, alert);
                this.alarmCommonReduce.reduceAndSendAlarm(alert.clone());
            } else {
                this.triggeredAlertMap.put(alarmKey, alert);
            }
        }
    }

    private boolean execAlertExpression(Map<String, Object> fieldValueMap, String expr) {
        Boolean match;
        JexlExpression expression;
        try {
            expression = JexlExpressionRunner.compile((String)expr);
        }
        catch (JexlException jexlException) {
            log.error("Alarm Rule: {} Compile Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            throw jexlException;
        }
        catch (Exception e) {
            log.error("Alarm Rule: {} Unknown Error: {}.", (Object)expr, (Object)e.getMessage());
            throw e;
        }
        try {
            match = (Boolean)JexlExpressionRunner.evaluate((JexlExpression)expression, fieldValueMap);
        }
        catch (JexlException jexlException) {
            log.error("Alarm Rule: {} Run Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            throw jexlException;
        }
        catch (Exception e) {
            log.error("Alarm Rule: {} Unknown Error: {}.", (Object)expr, (Object)e.getMessage());
            throw e;
        }
        return match != null && match != false;
    }

    private void handlerAvailableMetrics(long monitorId, String app, CollectRep.MetricsData metricsData) {
        if (metricsData.getCode() == CollectRep.Code.TIMEOUT) {
            return;
        }
        AlertDefine avaAlertDefine = this.alertDefineService.getMonitorBindAlertAvaDefine(monitorId, app, "availability");
        if (avaAlertDefine == null) {
            return;
        }
        long currentTimeMill = System.currentTimeMillis();
        if (metricsData.getCode() != CollectRep.Code.SUCCESS) {
            Alert preAlert = this.triggeredAlertMap.get(String.valueOf(monitorId));
            HashMap<String, String> tags = new HashMap<String, String>(6);
            tags.put("monitorId", String.valueOf(monitorId));
            tags.put("app", app);
            tags.put("thresholdId", String.valueOf(avaAlertDefine.getId()));
            tags.put("metrics", "availability");
            tags.put("code", metricsData.getCode().name());
            Map<String, Object> valueMap = tags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!CollectionUtils.isEmpty((Collection)avaAlertDefine.getTags())) {
                for (TagItem tagItem : avaAlertDefine.getTags()) {
                    valueMap.put(tagItem.getName(), tagItem.getValue());
                    tags.put(tagItem.getName(), tagItem.getValue());
                }
            }
            if (preAlert == null) {
                Alert.AlertBuilder alertBuilder = Alert.builder().tags(tags).priority(avaAlertDefine.getPriority()).status((byte)1).target("availability").content(AlertTemplateUtil.render(avaAlertDefine.getTemplate(), valueMap)).firstAlarmTime(Long.valueOf(currentTimeMill)).lastAlarmTime(Long.valueOf(currentTimeMill)).triggerTimes(Integer.valueOf(1));
                if (avaAlertDefine.getTimes() == null || avaAlertDefine.getTimes() <= 1) {
                    String notResolvedAlertKey = monitorId + "availability";
                    alertBuilder.status((byte)0);
                    this.notRecoveredAlertMap.put(notResolvedAlertKey, alertBuilder.build());
                    this.alarmCommonReduce.reduceAndSendAlarm(alertBuilder.build());
                } else {
                    this.triggeredAlertMap.put(String.valueOf(monitorId), alertBuilder.build());
                }
            } else {
                int defineTimes;
                int times = preAlert.getTriggerTimes() + 1;
                preAlert.setTriggerTimes(Integer.valueOf(times));
                preAlert.setFirstAlarmTime(Long.valueOf(currentTimeMill));
                preAlert.setLastAlarmTime(Long.valueOf(currentTimeMill));
                int n = defineTimes = avaAlertDefine.getTimes() == null ? 1 : avaAlertDefine.getTimes();
                if (times >= defineTimes) {
                    preAlert.setStatus((byte)0);
                    String notResolvedAlertKey = monitorId + "availability";
                    this.notRecoveredAlertMap.put(notResolvedAlertKey, preAlert.clone());
                    this.alarmCommonReduce.reduceAndSendAlarm(preAlert.clone());
                    this.triggeredAlertMap.remove(String.valueOf(monitorId));
                }
            }
        } else {
            this.triggeredAlertMap.remove(String.valueOf(monitorId));
            String notResolvedAlertKey = monitorId + "availability";
            Alert notResolvedAlert = this.notRecoveredAlertMap.remove(notResolvedAlertKey);
            if (notResolvedAlert != null) {
                Map tags = notResolvedAlert.getTags();
                if (!avaAlertDefine.isRecoverNotice()) {
                    tags.put("ignore", "ignore");
                }
                String content = this.bundle.getString("alerter.availability.recover");
                Alert resumeAlert = Alert.builder().tags(tags).target("availability").content(content).priority((byte)2).status((byte)2).firstAlarmTime(Long.valueOf(currentTimeMill)).lastAlarmTime(notResolvedAlert.getLastAlarmTime()).triggerTimes(Integer.valueOf(1)).build();
                this.alarmCommonReduce.reduceAndSendAlarm(resumeAlert);
                Runnable updateStatusJob = () -> this.updateAvailabilityAlertStatus(monitorId, resumeAlert);
                this.workerPool.executeJob(updateStatusJob);
            }
        }
    }

    private void updateAvailabilityAlertStatus(long monitorId, Alert restoreAlert) {
        List<Alert> availabilityAlerts = this.queryAvailabilityAlerts(monitorId, restoreAlert);
        ((Stream)availabilityAlerts.stream().parallel()).forEach(alert -> {
            log.info("updating alert status solved id: {}", (Object)alert.getId());
            this.alertService.editAlertStatus((byte)3, List.of(alert.getId()));
        });
    }

    private List<Alert> queryAvailabilityAlerts(long monitorId, Alert restoreAlert) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            Predicate predicateTags = criteriaBuilder.like(root.get("tags").as(String.class), "%" + monitorId + "%");
            andList.add(predicateTags);
            Predicate predicatePriority = criteriaBuilder.equal((Expression)root.get("priority"), (Object)0);
            andList.add(predicatePriority);
            Predicate predicateStatus = criteriaBuilder.equal((Expression)root.get("status"), (Object)0);
            andList.add(predicateStatus);
            Predicate predicateAlertTime = criteriaBuilder.lessThanOrEqualTo((Expression)root.get("lastAlarmTime"), (Comparable)restoreAlert.getLastAlarmTime());
            andList.add(predicateAlertTime);
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        return this.alertService.getAlerts((Specification<Alert>)specification);
    }

    @EventListener(value={SystemConfigChangeEvent.class})
    public void onSystemConfigChangeEvent(SystemConfigChangeEvent event) {
        log.info("calculate alarm receive system config change event: {}.", event.getSource());
        this.bundle = ResourceBundleUtil.getBundle((String)"alerter");
    }

    @EventListener(value={MonitorDeletedEvent.class})
    public void onMonitorDeletedEvent(MonitorDeletedEvent event) {
        log.info("calculate alarm receive monitor {} has been deleted.", (Object)event.getMonitorId());
        this.triggeredAlertMap.remove(String.valueOf(event.getMonitorId()));
    }
}

