/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlerterWorkerPool {
    private static final Logger log = LoggerFactory.getLogger(AlerterWorkerPool.class);
    private ThreadPoolExecutor workerExecutor;
    private ThreadPoolExecutor notifyExecutor;

    public AlerterWorkerPool() {
        this.initWorkExecutor();
        this.initNotifyExecutor();
    }

    private void initWorkExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("workerExecutor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("alerter-worker-%d").build();
        this.workerExecutor = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    private void initNotifyExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("notifyExecutor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("notify-worker-%d").build();
        this.notifyExecutor = new ThreadPoolExecutor(6, 6, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void executeJob(Runnable runnable) throws RejectedExecutionException {
        this.workerExecutor.execute(runnable);
    }

    public void executeNotify(Runnable runnable) throws RejectedExecutionException {
        this.notifyExecutor.execute(runnable);
    }
}

