/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.support;

import java.util.Objects;
import javax.validation.ConstraintViolationException;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.apache.hertzbeat.manager.support.exception.MonitorDatabaseException;
import org.apache.hertzbeat.manager.support.exception.MonitorDetectException;
import org.apache.hertzbeat.manager.support.exception.MonitorMetricsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String CONNECT_STR = "||";

    @ExceptionHandler(value={MonitorDetectException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleMonitorDetectException(MonitorDetectException exception) {
        Message message = Message.fail((byte)2, exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(message);
    }

    @ExceptionHandler(value={MonitorDatabaseException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleMonitorDatabaseException(MonitorDatabaseException exception) {
        Message message = Message.fail((byte)4, exception.getMessage());
        return ResponseEntity.ok(message);
    }

    @ExceptionHandler(value={CommonException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleCommonException(CommonException exception) {
        Message message = Message.fail((byte)15, exception.getMessage());
        return ResponseEntity.ok(message);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleIllegalArgumentException(IllegalArgumentException exception) {
        Message message = Message.fail((byte)1, exception.getMessage());
        return ResponseEntity.ok(message);
    }

    @ExceptionHandler(value={AlertNoticeException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleAlertNoticeException(AlertNoticeException noticeException) {
        Message message = Message.fail((byte)15, noticeException.getMessage());
        return ResponseEntity.ok(message);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleHttpMessageNotReadableException(HttpMessageNotReadableException exception) {
        try {
            String msg = exception.getCause().getMessage();
            if (msg == null) {
                msg = exception.getMessage();
            }
            Message message = Message.fail((byte)1, msg);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(message);
        }
        catch (Exception e) {
            Message message = Message.fail((byte)1, exception.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(message);
        }
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleInputValidException(Exception e) {
        StringBuffer errorMessage = new StringBuffer();
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException)e;
            exception.getBindingResult().getAllErrors().forEach(error -> {
                try {
                    String field = Objects.requireNonNull(error.getCodes())[0];
                    errorMessage.append(field).append(":").append(error.getDefaultMessage()).append(CONNECT_STR);
                }
                catch (Exception e1) {
                    errorMessage.append(error.getDefaultMessage()).append(CONNECT_STR);
                }
            });
        } else if (e instanceof BindException) {
            BindException exception = (BindException)e;
            exception.getAllErrors().forEach(error -> errorMessage.append(error.getDefaultMessage()).append(CONNECT_STR));
        }
        String errorMsg = errorMessage.toString();
        if (errorMsg.endsWith(CONNECT_STR)) {
            errorMsg = errorMsg.substring(0, errorMsg.length() - 2);
        }
        if (log.isDebugEnabled()) {
            log.debug("[input argument not valid happen]-{}", (Object)errorMsg, (Object)e);
        }
        Message message = Message.fail((byte)1, errorMsg);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(message);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleInputOtherValidException(ConstraintViolationException e) {
        StringBuffer errorMessage = new StringBuffer();
        e.getConstraintViolations().forEach(error -> {
            try {
                String field = error.getPropertyPath().toString();
                errorMessage.append(field).append(":").append(error.getMessage()).append(CONNECT_STR);
            }
            catch (Exception e1) {
                errorMessage.append(error.getMessage()).append(CONNECT_STR);
            }
        });
        String errorMsg = errorMessage.toString();
        if (errorMsg.endsWith(CONNECT_STR)) {
            errorMsg = errorMsg.substring(0, errorMsg.length() - 2);
        }
        log.warn("[input argument not valid happen]-{}", (Object)errorMsg);
        Message message = Message.fail((byte)1, errorMsg);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(message);
    }

    @ExceptionHandler(value={DataAccessException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleDataAccessException(DataAccessException exception) {
        String errorMessage = "database error happen";
        if (exception != null) {
            errorMessage = exception.getMessage();
        }
        log.warn("[database error happen]-{}", (Object)errorMessage, (Object)exception);
        Message message = Message.fail((byte)4, errorMessage);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(message);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleMethodNotSupportException(HttpRequestMethodNotSupportedException exception) {
        String errorMessage = "Request method not supported";
        if (exception != null && exception.getMessage() != null) {
            errorMessage = exception.getMessage();
        }
        log.info("[monitor]-[Request method not supported]-{}", (Object)errorMessage);
        Message<String> message = Message.success(errorMessage);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).body(message);
    }

    @ExceptionHandler(value={MonitorMetricsException.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleMonitorMetricsException(MonitorMetricsException exception) {
        Message message = Message.fail((byte)1, exception.getMessage());
        return ResponseEntity.ok(message);
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    void ignoreNoResourceFoundException(Exception ex) throws Exception {
        throw ex;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    ResponseEntity<Message<Void>> handleUnknownException(Exception exception) {
        String errorMessage = "unknown error happen";
        if (exception != null) {
            errorMessage = exception.getMessage();
        }
        log.error("[monitor]-[unknown error happen]-{}", (Object)errorMessage, (Object)exception);
        Message message = Message.fail((byte)4, errorMessage);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(message);
    }
}

