/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeRule;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.DispatcherAlarm;
import org.apache.hertzbeat.manager.dao.NoticeReceiverDao;
import org.apache.hertzbeat.manager.dao.NoticeRuleDao;
import org.apache.hertzbeat.manager.dao.NoticeTemplateDao;
import org.apache.hertzbeat.manager.service.NoticeConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=-2147483648)
@Transactional(rollbackFor={Exception.class})
public class NoticeConfigServiceImpl
implements NoticeConfigService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(NoticeConfigServiceImpl.class);
    private static final String ALERT_TEST_TARGET = "Test Target";
    private static final String ALERT_TEST_CONTENT = "test send msg! \\n This is the test data. It is proved that it can be received successfully";
    private static final Map<Byte, NoticeTemplate> PRESET_TEMPLATE = new HashMap<Byte, NoticeTemplate>(16);
    @Autowired
    private NoticeReceiverDao noticeReceiverDao;
    @Autowired
    private NoticeRuleDao noticeRuleDao;
    @Autowired
    private NoticeTemplateDao noticeTemplateDao;
    @Autowired
    @Lazy
    private DispatcherAlarm dispatcherAlarm;

    @Override
    public List<NoticeReceiver> getNoticeReceivers(String name) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + name + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        return this.noticeReceiverDao.findAll(specification);
    }

    @Override
    public List<NoticeTemplate> getNoticeTemplates(String name) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + name + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        LinkedList<NoticeTemplate> defaultTemplates = new LinkedList<NoticeTemplate>(PRESET_TEMPLATE.values());
        defaultTemplates.addAll(this.noticeTemplateDao.findAll(specification));
        return defaultTemplates;
    }

    @Override
    public List<NoticeRule> getNoticeRules(String name) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + name + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        return this.noticeRuleDao.findAll(specification);
    }

    @Override
    public void addReceiver(NoticeReceiver noticeReceiver) {
        this.noticeReceiverDao.save(noticeReceiver);
    }

    @Override
    public void editReceiver(NoticeReceiver noticeReceiver) {
        this.noticeReceiverDao.save(noticeReceiver);
    }

    @Override
    public void deleteReceiver(Long receiverId) {
        this.noticeReceiverDao.deleteById(receiverId);
    }

    @Override
    public void addNoticeRule(NoticeRule noticeRule) {
        this.noticeRuleDao.save(noticeRule);
        this.clearNoticeRulesCache();
    }

    @Override
    public void editNoticeRule(NoticeRule noticeRule) {
        this.noticeRuleDao.save(noticeRule);
        this.clearNoticeRulesCache();
    }

    @Override
    public void deleteNoticeRule(Long ruleId) {
        this.noticeRuleDao.deleteById(ruleId);
        this.clearNoticeRulesCache();
    }

    @Override
    public List<NoticeRule> getReceiverFilterRule(Alert alert) {
        CommonCacheService<String, Object> noticeCache = CacheFactory.getNoticeCache();
        List<NoticeRule> rules = (List<NoticeRule>)noticeCache.get("notice_rule");
        if (CollectionUtils.isEmpty((Collection)rules)) {
            rules = this.noticeRuleDao.findNoticeRulesByEnableTrue();
            noticeCache.put("notice_rule", rules);
        }
        return rules.stream().filter(rule -> {
            boolean dayMatch;
            if (!rule.isFilterAll()) {
                boolean tagMatch;
                boolean priorityMatch;
                if (rule.getPriorities() != null && !rule.getPriorities().isEmpty() && !(priorityMatch = rule.getPriorities().stream().anyMatch(item -> item != null && item.byteValue() == alert.getPriority()))) {
                    return false;
                }
                if (rule.getTags() != null && !rule.getTags().isEmpty() && !(tagMatch = rule.getTags().stream().anyMatch(tagItem -> {
                    if (!alert.getTags().containsKey(tagItem.getName())) {
                        return false;
                    }
                    String alertTagValue = alert.getTags().get(tagItem.getName());
                    return Objects.equals(tagItem.getValue(), alertTagValue);
                }))) {
                    return false;
                }
            }
            LocalDateTime nowDate = LocalDateTime.now();
            int currentDayOfWeek = nowDate.toLocalDate().getDayOfWeek().getValue();
            if (rule.getDays() != null && !rule.getDays().isEmpty() && !(dayMatch = rule.getDays().stream().anyMatch(item -> item == currentDayOfWeek))) {
                return false;
            }
            LocalTime nowTime = nowDate.toLocalTime();
            boolean startMatch = rule.getPeriodStart() == null || nowTime.isAfter(rule.getPeriodStart().toLocalTime()) || rule.getPeriodEnd() != null && rule.getPeriodStart().isAfter(rule.getPeriodEnd()) && nowTime.isBefore(rule.getPeriodStart().toLocalTime());
            boolean endMatch = rule.getPeriodEnd() == null || nowTime.isBefore(rule.getPeriodEnd().toLocalTime());
            return startMatch && endMatch;
        }).collect(Collectors.toList());
    }

    @Override
    public NoticeTemplate getOneTemplateById(Long id) {
        return this.noticeTemplateDao.findById(id).orElse(null);
    }

    @Override
    public NoticeReceiver getReceiverById(Long receiverId) {
        return this.noticeReceiverDao.findById(receiverId).orElse(null);
    }

    @Override
    public NoticeRule getNoticeRulesById(Long ruleId) {
        return this.noticeRuleDao.findById(ruleId).orElse(null);
    }

    @Override
    public void addNoticeTemplate(NoticeTemplate noticeTemplate) {
        this.noticeTemplateDao.save(noticeTemplate);
        this.clearNoticeRulesCache();
    }

    @Override
    public void editNoticeTemplate(NoticeTemplate noticeTemplate) {
        this.noticeTemplateDao.save(noticeTemplate);
        this.clearNoticeRulesCache();
    }

    @Override
    public void deleteNoticeTemplate(Long templateId) {
        this.noticeTemplateDao.deleteById(templateId);
        this.clearNoticeRulesCache();
    }

    @Override
    public Optional<NoticeTemplate> getNoticeTemplatesById(Long templateId) {
        return this.noticeTemplateDao.findById(templateId);
    }

    @Override
    public NoticeTemplate getDefaultNoticeTemplateByType(Byte type) {
        if (type == null) {
            return null;
        }
        return PRESET_TEMPLATE.get(type);
    }

    @Override
    public boolean sendTestMsg(NoticeReceiver noticeReceiver) {
        HashMap<String, String> tags = new HashMap<String, String>(8);
        tags.put("monitorId", "100");
        tags.put("monitorName", "100Name");
        tags.put("monitorHost", "127.0.0.1");
        tags.put("thresholdId", "200");
        Alert alert = Alert.builder().tags(tags).id(1003445L).target(ALERT_TEST_TARGET).priority((byte)1).content(ALERT_TEST_CONTENT).alertDefineId(200L).times(2).status((byte)0).firstAlarmTime(System.currentTimeMillis()).lastAlarmTime(System.currentTimeMillis()).build();
        return this.dispatcherAlarm.sendNoticeMsg(noticeReceiver, null, alert);
    }

    private void clearNoticeRulesCache() {
        CommonCacheService<String, Object> noticeCache = CacheFactory.getNoticeCache();
        noticeCache.remove("notice_rule");
    }

    public void run(String ... args) throws Exception {
        try {
            Resource[] resources;
            log.info("load default notice template in internal jar");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources("classpath:templates/*.*")) {
                if (resource.getFilename() == null || !resource.getFilename().endsWith("txt") && !resource.getFilename().endsWith("html")) {
                    log.warn("Ignore the template file {}.", (Object)resource.getFilename());
                    continue;
                }
                try (InputStream inputStream = resource.getInputStream();){
                    byte[] bytes = new byte[inputStream.available()];
                    inputStream.read(bytes);
                    String content = new String(bytes, StandardCharsets.UTF_8);
                    NoticeTemplate template = new NoticeTemplate();
                    String name = resource.getFilename().replace(".txt", "").replace(".html", "");
                    String[] names = name.split("-");
                    if (names.length != 2) {
                        log.warn("Ignore the template file {}.", (Object)resource.getFilename());
                        continue;
                    }
                    byte type = Byte.parseByte(names[0]);
                    name = names[1];
                    template.setName(name);
                    template.setType(type);
                    template.setPreset(true);
                    template.setContent(content);
                    template.setGmtUpdate(LocalDateTime.now());
                    PRESET_TEMPLATE.put(template.getType(), template);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("Ignore this template file: {}.", (Object)resource.getFilename());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

