/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hertzbeat.manager.pojo.dto.TemplateConfig;
import org.apache.hertzbeat.manager.service.ConfigService;
import org.apache.hertzbeat.manager.service.GeneralConfigService;
import org.apache.hertzbeat.manager.service.impl.TemplateConfigServiceImpl;
import org.springframework.stereotype.Component;

@Component
public class ConfigServiceImpl
implements ConfigService {
    private static final String TEMPLATE_CONFIG_TYPE = "template";
    private final Map<String, GeneralConfigService> configServiceMap = new ConcurrentHashMap<String, GeneralConfigService>(8);

    public ConfigServiceImpl(List<GeneralConfigService> generalConfigServices) {
        if (CollectionUtils.isNotEmpty(generalConfigServices)) {
            generalConfigServices.forEach(config -> this.configServiceMap.put(config.type(), (GeneralConfigService)config));
        }
    }

    @Override
    public void saveConfig(String type, Object config) {
        GeneralConfigService configService = this.configServiceMap.get(type);
        if (configService == null) {
            throw new IllegalArgumentException("Not supported this config type: " + type);
        }
        configService.saveConfig(config);
    }

    @Override
    public Object getConfig(String type) {
        GeneralConfigService configService = this.configServiceMap.get(type);
        if (configService == null) {
            throw new IllegalArgumentException("Not supported this config type: " + type);
        }
        return configService.getConfig();
    }

    @Override
    public void updateTemplateAppConfig(String app, TemplateConfig.AppTemplate template) {
        GeneralConfigService configService = this.configServiceMap.get(TEMPLATE_CONFIG_TYPE);
        if (!(configService instanceof TemplateConfigServiceImpl)) {
            throw new IllegalArgumentException("Not supported this config type: template");
        }
        TemplateConfig config = (TemplateConfig)((TemplateConfigServiceImpl)configService).getConfig();
        if (config == null) {
            config = new TemplateConfig();
        }
        if (config.getApps() == null) {
            config.setApps(new HashMap<String, TemplateConfig.AppTemplate>(8));
        }
        config.getApps().put(app, template);
        configService.saveConfig(config);
    }
}

