/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelCollection;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.annotation.Resource;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.service.ImExportService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.manager.service.TagService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public abstract class AbstractImExportServiceImpl
implements ImExportService {
    private static final Logger log = LoggerFactory.getLogger(AbstractImExportServiceImpl.class);
    @Resource
    @Lazy
    private MonitorService monitorService;
    @Resource
    private TagService tagService;

    @Override
    public void importConfig(InputStream is) {
        List<MonitorDto> formList = this.parseImport(is).stream().map(this::convert).toList();
        if (!CollectionUtils.isEmpty(formList)) {
            formList.forEach(monitorDto -> {
                this.monitorService.validate((MonitorDto)monitorDto, false);
                if (monitorDto.isDetected()) {
                    this.monitorService.detectMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
                }
                this.monitorService.addMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector(), monitorDto.getGrafanaDashboard());
            });
        }
    }

    @Override
    public void exportConfig(OutputStream os, List<Long> configList) {
        List<ExportMonitorDTO> monitorList = configList.stream().map(it -> this.monitorService.getMonitorDto((long)it)).filter(Objects::nonNull).map(this::convert).toList();
        this.writeOs(monitorList, os);
    }

    abstract List<ExportMonitorDTO> parseImport(InputStream var1);

    abstract void writeOs(List<ExportMonitorDTO> var1, OutputStream var2);

    private ExportMonitorDTO convert(MonitorDto dto) {
        ExportMonitorDTO exportMonitor = new ExportMonitorDTO();
        MonitorDTO monitor = new MonitorDTO();
        BeanUtils.copyProperties((Object)dto.getMonitor(), (Object)monitor);
        if (!CollectionUtils.isEmpty(dto.getMonitor().getTags())) {
            monitor.setTags(dto.getMonitor().getTags().stream().map(Tag::getId).toList());
        }
        exportMonitor.setMonitor(monitor);
        exportMonitor.setParams(dto.getParams().stream().map(it -> {
            ParamDTO param = new ParamDTO();
            param.setField(it.getField());
            param.setType(it.getType());
            param.setValue(it.getParamValue());
            return param;
        }).toList());
        exportMonitor.setMetrics(dto.getMetrics());
        exportMonitor.setDetected(false);
        exportMonitor.getMonitor().setCollector(dto.getCollector());
        return exportMonitor;
    }

    private MonitorDto convert(ExportMonitorDTO exportMonitor) {
        if (exportMonitor == null || exportMonitor.monitor == null) {
            throw new IllegalArgumentException("exportMonitor and exportMonitor.monitor must not be null");
        }
        MonitorDto monitorDto = new MonitorDto();
        monitorDto.setDetected(exportMonitor.getDetected());
        Monitor monitor = new Monitor();
        log.debug("exportMonitor.monitor{}", (Object)exportMonitor.monitor);
        if (exportMonitor.monitor != null) {
            BeanUtils.copyProperties((Object)exportMonitor.monitor, (Object)monitor);
            if (exportMonitor.monitor.tags != null && !exportMonitor.monitor.tags.isEmpty()) {
                monitor.setTags(this.tagService.listTag(new HashSet<Long>(exportMonitor.monitor.tags)).stream().filter(tag -> !tag.getName().equals("monitorId") && !tag.getName().equals("monitorName")).collect(Collectors.toList()));
            } else {
                monitor.setTags(Collections.emptyList());
            }
        }
        monitorDto.setMonitor(monitor);
        if (exportMonitor.getMonitor() != null) {
            monitorDto.setCollector(exportMonitor.getMonitor().getCollector());
        }
        monitorDto.setMetrics(exportMonitor.metrics);
        if (exportMonitor.params != null) {
            monitorDto.setParams(exportMonitor.params.stream().map(it -> {
                Param param = new Param();
                param.setField(it.field);
                param.setType(it.type);
                param.setParamValue(it.value);
                return param;
            }).toList());
        } else {
            monitorDto.setParams(Collections.emptyList());
        }
        return monitorDto;
    }

    protected String fileNamePrefix() {
        return "hertzbeat_monitor_" + LocalDate.now();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @ExcelTarget(value="ExportMonitorDTO")
    public static class ExportMonitorDTO {
        @ExcelEntity(name="Monitor")
        private MonitorDTO monitor;
        @ExcelCollection(name="Params")
        private List<ParamDTO> params;
        @ExcelCollection(name="Metrics")
        private List<String> metrics;
        @ExcelCollection(name="detected")
        private Boolean detected;

        public MonitorDTO getMonitor() {
            return this.monitor;
        }

        public List<ParamDTO> getParams() {
            return this.params;
        }

        public List<String> getMetrics() {
            return this.metrics;
        }

        public Boolean getDetected() {
            return this.detected;
        }

        public void setMonitor(MonitorDTO monitor) {
            this.monitor = monitor;
        }

        public void setParams(List<ParamDTO> params) {
            this.params = params;
        }

        public void setMetrics(List<String> metrics) {
            this.metrics = metrics;
        }

        public void setDetected(Boolean detected) {
            this.detected = detected;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportMonitorDTO)) {
                return false;
            }
            ExportMonitorDTO other = (ExportMonitorDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$detected = this.getDetected();
            Boolean other$detected = other.getDetected();
            if (this$detected == null ? other$detected != null : !((Object)this$detected).equals(other$detected)) {
                return false;
            }
            MonitorDTO this$monitor = this.getMonitor();
            MonitorDTO other$monitor = other.getMonitor();
            if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
                return false;
            }
            List<ParamDTO> this$params = this.getParams();
            List<ParamDTO> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            List<String> this$metrics = this.getMetrics();
            List<String> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExportMonitorDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $detected = this.getDetected();
            result = result * 59 + ($detected == null ? 43 : ((Object)$detected).hashCode());
            MonitorDTO $monitor = this.getMonitor();
            result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
            List<ParamDTO> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            List<String> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractImExportServiceImpl.ExportMonitorDTO(monitor=" + this.getMonitor() + ", params=" + this.getParams() + ", metrics=" + this.getMetrics() + ", detected=" + this.getDetected() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @ExcelTarget(value="MonitorDTO")
    public static class MonitorDTO {
        @Excel(name="Name")
        private String name;
        @Excel(name="App")
        private String app;
        @Excel(name="Host")
        private String host;
        @Excel(name="Intervals")
        private Integer intervals;
        @Excel(name="Status")
        private Byte status;
        @Excel(name="Description")
        private String description;
        @Excel(name="Tags")
        private List<Long> tags;
        @Excel(name="Collector")
        private String collector;

        public String getName() {
            return this.name;
        }

        public String getApp() {
            return this.app;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getIntervals() {
            return this.intervals;
        }

        public Byte getStatus() {
            return this.status;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Long> getTags() {
            return this.tags;
        }

        public String getCollector() {
            return this.collector;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setIntervals(Integer intervals) {
            this.intervals = intervals;
        }

        public void setStatus(Byte status) {
            this.status = status;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setTags(List<Long> tags) {
            this.tags = tags;
        }

        public void setCollector(String collector) {
            this.collector = collector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MonitorDTO)) {
                return false;
            }
            MonitorDTO other = (MonitorDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$intervals = this.getIntervals();
            Integer other$intervals = other.getIntervals();
            if (this$intervals == null ? other$intervals != null : !((Object)this$intervals).equals(other$intervals)) {
                return false;
            }
            Byte this$status = this.getStatus();
            Byte other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$app = this.getApp();
            String other$app = other.getApp();
            if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<Long> this$tags = this.getTags();
            List<Long> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            String this$collector = this.getCollector();
            String other$collector = other.getCollector();
            return !(this$collector == null ? other$collector != null : !this$collector.equals(other$collector));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MonitorDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $intervals = this.getIntervals();
            result = result * 59 + ($intervals == null ? 43 : ((Object)$intervals).hashCode());
            Byte $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $app = this.getApp();
            result = result * 59 + ($app == null ? 43 : $app.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<Long> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            String $collector = this.getCollector();
            result = result * 59 + ($collector == null ? 43 : $collector.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractImExportServiceImpl.MonitorDTO(name=" + this.getName() + ", app=" + this.getApp() + ", host=" + this.getHost() + ", intervals=" + this.getIntervals() + ", status=" + this.getStatus() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", collector=" + this.getCollector() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @ExcelTarget(value="ParamDTO")
    public static class ParamDTO {
        @Excel(name="Field")
        private String field;
        @Excel(name="Type")
        private Byte type;
        @Excel(name="Value")
        private String value;

        public String getField() {
            return this.field;
        }

        public Byte getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setType(Byte type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamDTO)) {
                return false;
            }
            ParamDTO other = (ParamDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Byte this$type = this.getType();
            Byte other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParamDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Byte $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractImExportServiceImpl.ParamDTO(field=" + this.getField() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
        }
    }
}

