/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class WebHookAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(WebHookAlertNotifyHandlerImpl.class);

    WebHookAlertNotifyHandlerImpl() {
    }

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            this.filterInvalidTags(alert);
            alert.setContent(this.escapeJsonStr(alert.getContent()));
            String webhookJson = this.renderContent(noticeTemplate, alert);
            webhookJson = webhookJson.replace(",\n  }", "\n }");
            HttpEntity alertHttpEntity = new HttpEntity((Object)webhookJson, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity(receiver.getHookUrl(), (Object)alertHttpEntity, String.class, new Object[0]);
            if (entity.getStatusCode().value() >= HttpStatus.BAD_REQUEST.value()) {
                log.warn("Send WebHook: {} Failed: {}", (Object)receiver.getHookUrl(), entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send WebHook: {} Success", (Object)receiver.getHookUrl());
        }
        catch (Exception e) {
            throw new AlertNoticeException("[WebHook Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 2;
    }

    private void filterInvalidTags(Alert alert) {
        if (alert.getTags() == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> iterator = alert.getTags().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.getKey(), entry.getValue()})) continue;
            iterator.remove();
        }
        if ((long)alert.getTags().entrySet().size() <= 0L) {
            alert.setTags(null);
        }
    }
}

