/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.util.StrUtil;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.component.alerter.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class WeComRobotAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(WeComRobotAlertNotifyHandlerImpl.class);

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        block6: {
            try {
                WeWorkWebHookDto weWorkWebHookDTO = new WeWorkWebHookDto();
                WeWorkWebHookDto.MarkdownDTO markdownDTO = new WeWorkWebHookDto.MarkdownDTO();
                markdownDTO.setContent(this.renderContent(noticeTemplate, alert));
                weWorkWebHookDTO.setMarkdown(markdownDTO);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity httpEntity = new HttpEntity((Object)weWorkWebHookDTO, (MultiValueMap)headers);
                String webHookUrl = this.alerterProperties.getWeWorkWebhookUrl() + receiver.getWechatId();
                ResponseEntity entity = this.restTemplate.postForEntity(webHookUrl, (Object)httpEntity, CommonRobotNotifyResp.class, new Object[0]);
                if (entity.getStatusCode() == HttpStatus.OK) {
                    assert (entity.getBody() != null);
                    if (((CommonRobotNotifyResp)entity.getBody()).getErrCode() == 0) {
                        log.debug("Send WeWork webHook: {} Success", (Object)webHookUrl);
                        WeWorkWebHookDto weWorkWebHookTextDto = this.checkNeedAtNominator(receiver, alert);
                        if (!Objects.isNull(weWorkWebHookTextDto)) {
                            HttpEntity httpEntityText = new HttpEntity((Object)weWorkWebHookTextDto, (MultiValueMap)headers);
                            this.restTemplate.postForEntity(webHookUrl, (Object)httpEntityText, CommonRobotNotifyResp.class, new Object[0]);
                        }
                        break block6;
                    }
                    log.warn("Send WeWork webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)entity.getBody()).getErrMsg());
                    throw new AlertNoticeException(((CommonRobotNotifyResp)entity.getBody()).getErrMsg());
                }
                log.warn("Send WeWork webHook: {} Failed: {}", (Object)webHookUrl, entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            catch (Exception e) {
                throw new AlertNoticeException("[WeWork Notify Error] " + e.getMessage());
            }
        }
    }

    private WeWorkWebHookDto checkNeedAtNominator(NoticeReceiver receiver, Alert alert) {
        if (StringUtils.isBlank((CharSequence)receiver.getPhone()) && StringUtils.isBlank((CharSequence)receiver.getUserId())) {
            return null;
        }
        WeWorkWebHookDto weWorkWebHookTextDto = new WeWorkWebHookDto();
        weWorkWebHookTextDto.setMsgtype("text");
        WeWorkWebHookDto.TextDTO textDto = new WeWorkWebHookDto.TextDTO();
        if (StringUtils.isNotBlank((CharSequence)receiver.getPhone())) {
            textDto.setMentionedMobileList(StrUtil.analysisArgToList(receiver.getPhone()));
            weWorkWebHookTextDto.setText(textDto);
        }
        if (StringUtils.isNotBlank((CharSequence)receiver.getUserId())) {
            textDto.setMentionedList(StrUtil.analysisArgToList(receiver.getUserId()));
            weWorkWebHookTextDto.setText(textDto);
        }
        return weWorkWebHookTextDto;
    }

    @Override
    public byte type() {
        return 4;
    }

    private static class WeWorkWebHookDto {
        public static final String WEBHOOK_URL = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=";
        private static final String DEFAULT_MSG_TYPE = "markdown";
        private static final String TEXT_MSG_TYPE = "text";
        private String msgtype;
        private MarkdownDTO markdown;
        private TextDTO text;

        private static String $default$msgtype() {
            return DEFAULT_MSG_TYPE;
        }

        public static WeWorkWebHookDtoBuilder builder() {
            return new WeWorkWebHookDtoBuilder();
        }

        public String getMsgtype() {
            return this.msgtype;
        }

        public MarkdownDTO getMarkdown() {
            return this.markdown;
        }

        public TextDTO getText() {
            return this.text;
        }

        public void setMsgtype(String msgtype) {
            this.msgtype = msgtype;
        }

        public void setMarkdown(MarkdownDTO markdown) {
            this.markdown = markdown;
        }

        public void setText(TextDTO text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeWorkWebHookDto)) {
                return false;
            }
            WeWorkWebHookDto other = (WeWorkWebHookDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgtype = this.getMsgtype();
            String other$msgtype = other.getMsgtype();
            if (this$msgtype == null ? other$msgtype != null : !this$msgtype.equals(other$msgtype)) {
                return false;
            }
            MarkdownDTO this$markdown = this.getMarkdown();
            MarkdownDTO other$markdown = other.getMarkdown();
            if (this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown)) {
                return false;
            }
            TextDTO this$text = this.getText();
            TextDTO other$text = other.getText();
            return !(this$text == null ? other$text != null : !((Object)this$text).equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeWorkWebHookDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgtype = this.getMsgtype();
            result = result * 59 + ($msgtype == null ? 43 : $msgtype.hashCode());
            MarkdownDTO $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            TextDTO $text = this.getText();
            result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
            return result;
        }

        public String toString() {
            return "WeComRobotAlertNotifyHandlerImpl.WeWorkWebHookDto(msgtype=" + this.getMsgtype() + ", markdown=" + this.getMarkdown() + ", text=" + this.getText() + ")";
        }

        public WeWorkWebHookDto(String msgtype, MarkdownDTO markdown, TextDTO text) {
            this.msgtype = msgtype;
            this.markdown = markdown;
            this.text = text;
        }

        public WeWorkWebHookDto() {
            this.msgtype = WeWorkWebHookDto.$default$msgtype();
        }

        public static class WeWorkWebHookDtoBuilder {
            private boolean msgtype$set;
            private String msgtype$value;
            private MarkdownDTO markdown;
            private TextDTO text;

            WeWorkWebHookDtoBuilder() {
            }

            public WeWorkWebHookDtoBuilder msgtype(String msgtype) {
                this.msgtype$value = msgtype;
                this.msgtype$set = true;
                return this;
            }

            public WeWorkWebHookDtoBuilder markdown(MarkdownDTO markdown) {
                this.markdown = markdown;
                return this;
            }

            public WeWorkWebHookDtoBuilder text(TextDTO text) {
                this.text = text;
                return this;
            }

            public WeWorkWebHookDto build() {
                String msgtype$value = this.msgtype$value;
                if (!this.msgtype$set) {
                    msgtype$value = WeWorkWebHookDto.$default$msgtype();
                }
                return new WeWorkWebHookDto(msgtype$value, this.markdown, this.text);
            }

            public String toString() {
                return "WeComRobotAlertNotifyHandlerImpl.WeWorkWebHookDto.WeWorkWebHookDtoBuilder(msgtype$value=" + this.msgtype$value + ", markdown=" + this.markdown + ", text=" + this.text + ")";
            }
        }

        private static class MarkdownDTO {
            private String content;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MarkdownDTO)) {
                    return false;
                }
                MarkdownDTO other = (MarkdownDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$content = this.getContent();
                String other$content = other.getContent();
                return !(this$content == null ? other$content != null : !this$content.equals(other$content));
            }

            protected boolean canEqual(Object other) {
                return other instanceof MarkdownDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $content = this.getContent();
                result = result * 59 + ($content == null ? 43 : $content.hashCode());
                return result;
            }

            public String toString() {
                return "WeComRobotAlertNotifyHandlerImpl.WeWorkWebHookDto.MarkdownDTO(content=" + this.getContent() + ")";
            }
        }

        private static class TextDTO {
            private String content;
            @JsonProperty(value="mentioned_list")
            private List<String> mentionedList;
            @JsonProperty(value="mentioned_mobile_list")
            private List<String> mentionedMobileList;

            public String getContent() {
                return this.content;
            }

            public List<String> getMentionedList() {
                return this.mentionedList;
            }

            public List<String> getMentionedMobileList() {
                return this.mentionedMobileList;
            }

            public void setContent(String content) {
                this.content = content;
            }

            @JsonProperty(value="mentioned_list")
            public void setMentionedList(List<String> mentionedList) {
                this.mentionedList = mentionedList;
            }

            @JsonProperty(value="mentioned_mobile_list")
            public void setMentionedMobileList(List<String> mentionedMobileList) {
                this.mentionedMobileList = mentionedMobileList;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TextDTO)) {
                    return false;
                }
                TextDTO other = (TextDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$content = this.getContent();
                String other$content = other.getContent();
                if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                    return false;
                }
                List<String> this$mentionedList = this.getMentionedList();
                List<String> other$mentionedList = other.getMentionedList();
                if (this$mentionedList == null ? other$mentionedList != null : !((Object)this$mentionedList).equals(other$mentionedList)) {
                    return false;
                }
                List<String> this$mentionedMobileList = this.getMentionedMobileList();
                List<String> other$mentionedMobileList = other.getMentionedMobileList();
                return !(this$mentionedMobileList == null ? other$mentionedMobileList != null : !((Object)this$mentionedMobileList).equals(other$mentionedMobileList));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TextDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $content = this.getContent();
                result = result * 59 + ($content == null ? 43 : $content.hashCode());
                List<String> $mentionedList = this.getMentionedList();
                result = result * 59 + ($mentionedList == null ? 43 : ((Object)$mentionedList).hashCode());
                List<String> $mentionedMobileList = this.getMentionedMobileList();
                result = result * 59 + ($mentionedMobileList == null ? 43 : ((Object)$mentionedMobileList).hashCode());
                return result;
            }

            public String toString() {
                return "WeComRobotAlertNotifyHandlerImpl.WeWorkWebHookDto.TextDTO(content=" + this.getContent() + ", mentionedList=" + this.getMentionedList() + ", mentionedMobileList=" + this.getMentionedMobileList() + ")";
            }
        }
    }
}

