/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import java.util.Objects;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
final class SlackAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(SlackAlertNotifyHandlerImpl.class);
    private static final String SUCCESS = "ok";
    private final RestTemplate restTemplate;

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) throws AlertNoticeException {
        try {
            SlackNotifyDTO slackNotify = SlackNotifyDTO.builder().text(this.renderContent(noticeTemplate, alert)).build();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity slackNotifyEntity = new HttpEntity((Object)slackNotify, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity(receiver.getSlackWebHookUrl(), (Object)slackNotifyEntity, String.class, new Object[0]);
            if (entity.getStatusCode() == HttpStatus.OK && entity.getBody() != null) {
                String body = (String)entity.getBody();
                if (!Objects.equals(SUCCESS, body)) {
                    log.warn("Send Slack Failed: {}", (Object)body);
                    throw new AlertNoticeException(body);
                }
            } else {
                log.warn("Send Slack Failed {}", entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send Slack Success");
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Slack Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 8;
    }

    public SlackAlertNotifyHandlerImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private static class SlackNotifyDTO {
        private String text;

        SlackNotifyDTO(String text) {
            this.text = text;
        }

        public static SlackNotifyDTOBuilder builder() {
            return new SlackNotifyDTOBuilder();
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlackNotifyDTO)) {
                return false;
            }
            SlackNotifyDTO other = (SlackNotifyDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlackNotifyDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "SlackAlertNotifyHandlerImpl.SlackNotifyDTO(text=" + this.getText() + ")";
        }

        public static class SlackNotifyDTOBuilder {
            private String text;

            SlackNotifyDTOBuilder() {
            }

            public SlackNotifyDTOBuilder text(String text) {
                this.text = text;
                return this;
            }

            public SlackNotifyDTO build() {
                return new SlackNotifyDTO(this.text);
            }

            public String toString() {
                return "SlackAlertNotifyHandlerImpl.SlackNotifyDTO.SlackNotifyDTOBuilder(text=" + this.text + ")";
            }
        }
    }
}

