/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Resource;
import org.apache.hertzbeat.alert.AlerterProperties;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.apache.hertzbeat.manager.component.alerter.AlertNotifyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.client.RestTemplate;

abstract class AbstractAlertNotifyHandlerImpl
implements AlertNotifyHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAlertNotifyHandlerImpl.class);
    private static final String NUMBER_FORMAT = "0";
    protected static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected ResourceBundle bundle = ResourceBundleUtil.getBundle("alerter");
    @Resource
    protected RestTemplate restTemplate;
    @Resource
    protected AlerterProperties alerterProperties;

    AbstractAlertNotifyHandlerImpl() {
    }

    protected String renderContent(NoticeTemplate noticeTemplate, Alert alert) throws TemplateException, IOException {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        cfg.setNumberFormat(NUMBER_FORMAT);
        cfg.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        HashMap<String, Object> model = new HashMap<String, Object>(16);
        model.put("title", this.bundle.getString("alerter.notify.title"));
        if (alert.getTags() != null) {
            String thresholdId;
            String monitorHost;
            String monitorName;
            String monitorId = alert.getTags().get("monitorId");
            if (monitorId != null) {
                model.put("monitorId", monitorId);
            }
            if ((monitorName = alert.getTags().get("monitorName")) != null) {
                model.put("monitorName", monitorName);
            }
            if ((monitorHost = alert.getTags().get("monitorHost")) != null) {
                model.put("monitorHost", monitorHost);
            }
            if ((thresholdId = alert.getTags().get("thresholdId")) != null) {
                model.put("thresholdId", thresholdId);
            }
        }
        model.put("alarmId", alert.getId());
        model.put("status", alert.getStatus());
        model.put("monitorIdLabel", this.bundle.getString("alerter.notify.monitorId"));
        model.put("monitorNameLabel", this.bundle.getString("alerter.notify.monitorName"));
        model.put("monitorHostLabel", this.bundle.getString("alerter.notify.monitorHost"));
        model.put("target", alert.getTarget());
        model.put("targetLabel", this.bundle.getString("alerter.notify.target"));
        model.put("priorityLabel", this.bundle.getString("alerter.notify.priority"));
        model.put("priority", this.bundle.getString("alerter.priority." + alert.getPriority()));
        model.put("priorityValue", alert.getPriority());
        model.put("triggerTimeLabel", this.bundle.getString("alerter.notify.triggerTime"));
        model.put("triggerTime", DTF.format(Instant.ofEpochMilli(alert.getLastAlarmTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()));
        if (2 == alert.getStatus()) {
            model.put("restoreTimeLabel", this.bundle.getString("alerter.notify.restoreTime"));
            model.put("restoreTime", DTF.format(Instant.ofEpochMilli(alert.getFirstAlarmTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()));
        }
        model.put("timesLabel", this.bundle.getString("alerter.notify.times"));
        model.put("times", alert.getTimes());
        model.put("contentLabel", this.bundle.getString("alerter.notify.content"));
        model.put("content", alert.getContent());
        model.put("tagsLabel", this.bundle.getString("alerter.notify.tags"));
        model.put("tags", alert.getTags());
        if (this.alerterProperties != null) {
            model.put("consoleUrl", this.alerterProperties.getConsoleUrl());
        }
        model.put("consoleLabel", this.bundle.getString("alerter.notify.console"));
        String templateName = "freeMakerTemplate";
        stringLoader.putTemplate(templateName, noticeTemplate.getContent());
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        Template templateRes = cfg.getTemplate(templateName, Locale.CHINESE);
        String template = FreeMarkerTemplateUtils.processTemplateIntoString((Template)templateRes, model);
        return template.replaceAll("((\r\n)|\n)[\\s\t ]*(\\1)+", "$1");
    }

    protected String escapeJsonStr(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block9: for (char c : jsonStr.toCharArray()) {
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @EventListener(value={SystemConfigChangeEvent.class})
    public void onEvent(SystemConfigChangeEvent event) {
        log.info("{} receive system config change event: {}.", (Object)this.getClass().getName(), event.getSource());
        this.bundle = ResourceBundleUtil.getBundle("alerter");
    }
}

