/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance.internal;

import com.google.protobuf.Message;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hertzbeat.collector.dispatch.DispatchProperties;
import org.apache.hertzbeat.collector.dispatch.WorkerPool;
import org.apache.hertzbeat.collector.dispatch.entrance.CollectServer;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectResponseEventListener;
import org.apache.hertzbeat.collector.dispatch.timer.TimerDispatch;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.ProtoJsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CollectJobService {
    private static final Logger log = LoggerFactory.getLogger(CollectJobService.class);
    private static final String COLLECTOR_STR = "-collector";
    private final TimerDispatch timerDispatch;
    private final WorkerPool workerPool;
    private final String collectorIdentity;
    private String mode = null;
    private CollectServer collectServer;

    public CollectJobService(TimerDispatch timerDispatch, DispatchProperties properties, WorkerPool workerPool) {
        this.timerDispatch = timerDispatch;
        this.workerPool = workerPool;
        Optional<DispatchProperties.EntranceProperties.NettyProperties> nettyPropertiesOptional = Optional.ofNullable(properties).map(DispatchProperties::getEntrance).map(DispatchProperties.EntranceProperties::getNetty).filter(DispatchProperties.EntranceProperties.NettyProperties::isEnabled);
        if (nettyPropertiesOptional.isEmpty()) {
            this.collectorIdentity = "main-default-collector";
            return;
        }
        DispatchProperties.EntranceProperties.NettyProperties nettyProperties = nettyPropertiesOptional.get();
        this.mode = nettyProperties.getMode();
        if (StringUtils.hasText((String)nettyProperties.getIdentity())) {
            this.collectorIdentity = nettyProperties.getIdentity();
        } else {
            this.collectorIdentity = IpDomainUtil.getCurrentHostName() + COLLECTOR_STR;
            log.info("user not config this collector identity, use [host name - host ip] default: {}.", (Object)this.collectorIdentity);
        }
    }

    public List<CollectRep.MetricsData> collectSyncJobData(Job job) {
        final LinkedList<CollectRep.MetricsData> metricsData = new LinkedList<CollectRep.MetricsData>();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        CollectResponseEventListener listener = new CollectResponseEventListener(){

            @Override
            public void response(List<CollectRep.MetricsData> responseMetrics) {
                if (responseMetrics != null) {
                    metricsData.addAll(responseMetrics);
                }
                countDownLatch.countDown();
            }
        };
        this.timerDispatch.addJob(job, listener);
        try {
            countDownLatch.await(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.info("The sync task runs for 120 seconds with no response and returns");
        }
        return metricsData;
    }

    public void collectSyncOneTimeJobData(Job oneTimeJob) {
        this.workerPool.executeJob(() -> {
            List<CollectRep.MetricsData> metricsDataList = this.collectSyncJobData(oneTimeJob);
            List jsons = CollectionUtils.emptyIfNull(metricsDataList).stream().map(ProtoJsonUtil::toJsonStr).filter(StringUtils::hasText).collect(Collectors.toList());
            String response = JsonUtil.toJson(jsons);
            ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setMsg(response).setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.RESPONSE_ONE_TIME_TASK_DATA).build();
            this.collectServer.sendMsg(message);
        });
    }

    public void addAsyncCollectJob(Job job) {
        this.timerDispatch.addJob(job.clone(), null);
    }

    public void cancelAsyncCollectJob(Long jobId) {
        if (jobId != null) {
            this.timerDispatch.deleteJob(jobId, true);
        }
    }

    public void sendAsyncCollectData(CollectRep.MetricsData metricsData) {
        String data = ProtoJsonUtil.toJsonStr((Message)metricsData);
        ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setIdentity(this.collectorIdentity).setMsg(data).setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.RESPONSE_CYCLIC_TASK_DATA).build();
        this.collectServer.sendMsg(message);
    }

    public String getCollectorIdentity() {
        return this.collectorIdentity;
    }

    public String getCollectorMode() {
        return this.mode;
    }

    public void setCollectServer(CollectServer collectServer) {
        this.collectServer = collectServer;
    }
}

