/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.redis.client.impl;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.realtime.redis.MetricsDataRedisCodec;
import org.apache.hertzbeat.warehouse.store.realtime.redis.RedisProperties;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.RedisClientOperation;

public class RedisSimpleClientImpl
implements RedisClientOperation<String, CollectRep.MetricsData> {
    private RedisClient redisClient;
    private StatefulRedisConnection<String, CollectRep.MetricsData> connection;

    @Override
    public RedisClientOperation<String, CollectRep.MetricsData> connect(RedisProperties redisProperties, RedisCodec<String, CollectRep.MetricsData> redisCodec) {
        String[] address = redisProperties.address().split(":");
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(address[0]).withPort(Integer.parseInt(address[1])).withTimeout(Duration.of(10L, ChronoUnit.SECONDS)).withDatabase(redisProperties.db().intValue());
        if (StringUtils.isNotBlank((CharSequence)redisProperties.password())) {
            uriBuilder.withPassword(redisProperties.password().toCharArray());
        }
        this.redisClient = RedisClient.create((RedisURI)uriBuilder.build());
        this.connection = this.redisClient.connect((RedisCodec)new MetricsDataRedisCodec());
        return this;
    }

    @Override
    public CollectRep.MetricsData hget(String key, String field) {
        return (CollectRep.MetricsData)this.connection.sync().hget((Object)key, (Object)field);
    }

    @Override
    public Map<String, CollectRep.MetricsData> hgetAll(String key) {
        return this.connection.sync().hgetall((Object)key);
    }

    @Override
    public void hset(String key, String field, CollectRep.MetricsData value, Consumer<RedisFuture<Boolean>> redisFutureConsumer) {
        RedisFuture redisFuture = this.connection.async().hset((Object)key, (Object)field, (Object)value);
        if (Objects.nonNull(redisFutureConsumer)) {
            redisFutureConsumer.accept((RedisFuture<Boolean>)redisFuture);
        }
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.connection)) {
            this.connection.close();
        }
        if (Objects.nonNull(this.redisClient)) {
            this.redisClient.close();
        }
    }
}

