/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.redis.client.impl;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.realtime.redis.MetricsDataRedisCodec;
import org.apache.hertzbeat.warehouse.store.realtime.redis.RedisProperties;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.RedisClientOperation;

public class RedisSentinelClientImpl
implements RedisClientOperation<String, CollectRep.MetricsData> {
    private RedisClient sentinelRedisClient;
    private StatefulRedisSentinelConnection<String, String> sentinelConnection;
    private RedisClient masterRedisClient;
    private StatefulRedisConnection<String, CollectRep.MetricsData> masterConnection;

    @Override
    public RedisClientOperation<String, CollectRep.MetricsData> connect(RedisProperties redisProperties, RedisCodec<String, CollectRep.MetricsData> redisCodec) {
        RedisURI.Builder masterUriBuilder;
        String[] address = redisProperties.address().split(":");
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(address[0]).withPort(Integer.parseInt(address[1])).withTimeout(Duration.of(10L, ChronoUnit.SECONDS));
        if (StringUtils.isNotBlank((CharSequence)redisProperties.password())) {
            uriBuilder.withPassword(redisProperties.password().toCharArray());
        }
        this.sentinelRedisClient = RedisClient.create((RedisURI)uriBuilder.build());
        this.sentinelConnection = this.sentinelRedisClient.connectSentinel();
        SocketAddress masterSocketAddress = this.sentinelConnection.sync().getMasterAddrByName((Object)redisProperties.masterName());
        if (masterSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress masterAddress = (InetSocketAddress)masterSocketAddress;
            masterUriBuilder = RedisURI.builder().withHost(masterAddress.getHostName()).withPort(masterAddress.getPort()).withTimeout(Duration.of(10L, ChronoUnit.SECONDS)).withDatabase(redisProperties.db().intValue());
            if (StringUtils.isNotBlank((CharSequence)redisProperties.password())) {
                masterUriBuilder.withPassword(redisProperties.password().toCharArray());
            }
        } else {
            throw new UnsupportedOperationException("Incorrect type of SocketAddress, connect redis sentinel failed...");
        }
        this.masterRedisClient = RedisClient.create((RedisURI)masterUriBuilder.build());
        this.masterConnection = this.masterRedisClient.connect((RedisCodec)new MetricsDataRedisCodec());
        return this;
    }

    @Override
    public CollectRep.MetricsData hget(String key, String field) {
        return (CollectRep.MetricsData)this.masterConnection.sync().hget((Object)key, (Object)field);
    }

    @Override
    public Map<String, CollectRep.MetricsData> hgetAll(String key) {
        return this.masterConnection.sync().hgetall((Object)key);
    }

    @Override
    public void hset(String key, String field, CollectRep.MetricsData value, Consumer<RedisFuture<Boolean>> redisFutureConsumer) {
        RedisFuture redisFuture = this.masterConnection.async().hset((Object)key, (Object)field, (Object)value);
        if (Objects.nonNull(redisFutureConsumer)) {
            redisFutureConsumer.accept((RedisFuture<Boolean>)redisFuture);
        }
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.masterConnection)) {
            this.masterConnection.close();
        }
        if (Objects.nonNull(this.masterRedisClient)) {
            this.masterRedisClient.close();
        }
        if (Objects.nonNull(this.sentinelConnection)) {
            this.sentinelConnection.close();
        }
        if (Objects.nonNull(this.sentinelRedisClient)) {
            this.sentinelRedisClient.close();
        }
    }
}

