/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.realtime.AbstractRealTimeDataStorage;
import org.apache.hertzbeat.warehouse.store.realtime.redis.RedisProperties;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.RedisCommandDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Primary
@Component
@ConditionalOnProperty(prefix="warehouse.real-time.redis", name={"enabled"}, havingValue="true")
public class RedisDataStorage
extends AbstractRealTimeDataStorage {
    private static final Logger log = LoggerFactory.getLogger(RedisDataStorage.class);
    private final RedisCommandDelegate redisCommandDelegate;

    public RedisDataStorage(RedisProperties redisProperties) {
        RedisCommandDelegate delegate = RedisCommandDelegate.getInstance();
        this.serverAvailable = delegate.initRedisClient(redisProperties);
        this.redisCommandDelegate = delegate;
    }

    @Override
    public CollectRep.MetricsData getCurrentMetricsData(@NonNull Long monitorId, @NonNull String metric) {
        return this.redisCommandDelegate.operate().hget(String.valueOf(monitorId), metric);
    }

    @Override
    public List<CollectRep.MetricsData> getCurrentMetricsData(@NonNull Long monitorId) {
        Map<String, CollectRep.MetricsData> metricsDataMap = this.redisCommandDelegate.operate().hgetAll(String.valueOf(monitorId));
        return new ArrayList<CollectRep.MetricsData>(metricsDataMap.values());
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        String key = String.valueOf(metricsData.getId());
        String hashKey = metricsData.getMetrics();
        if (metricsData.getCode() != CollectRep.Code.SUCCESS || !this.isServerAvailable()) {
            return;
        }
        this.redisCommandDelegate.operate().hset(key, hashKey, metricsData, future -> future.thenAccept(response -> {
            if (response.booleanValue()) {
                log.debug("[warehouse] redis add new data {}:{}.", (Object)key, (Object)hashKey);
            } else {
                log.debug("[warehouse] redis replace data {}:{}.", (Object)key, (Object)hashKey);
            }
        }));
    }

    public void destroy() throws Exception {
        this.redisCommandDelegate.destroy();
    }
}

