/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.realtime.AbstractRealTimeDataStorage;
import org.apache.hertzbeat.warehouse.store.realtime.memory.MemoryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="warehouse.real-time.memory", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MemoryDataStorage
extends AbstractRealTimeDataStorage {
    private static final Logger log = LoggerFactory.getLogger(MemoryDataStorage.class);
    private final Map<Long, Map<String, CollectRep.MetricsData>> monitorMetricsDataMap;
    private static final Integer DEFAULT_INIT_SIZE = 16;
    private static final Integer METRICS_SIZE = 8;

    public MemoryDataStorage(MemoryProperties memoryProperties) {
        int initSize = DEFAULT_INIT_SIZE;
        if (memoryProperties != null && memoryProperties.initSize() != null) {
            initSize = memoryProperties.initSize();
        }
        this.monitorMetricsDataMap = new ConcurrentHashMap<Long, Map<String, CollectRep.MetricsData>>(initSize);
        this.serverAvailable = true;
    }

    @Override
    public CollectRep.MetricsData getCurrentMetricsData(@NonNull Long monitorId, @NonNull String metric) {
        Map metricsDataMap = this.monitorMetricsDataMap.computeIfAbsent(monitorId, key -> new ConcurrentHashMap(METRICS_SIZE));
        return (CollectRep.MetricsData)metricsDataMap.get(metric);
    }

    @Override
    public List<CollectRep.MetricsData> getCurrentMetricsData(@NonNull Long monitorId) {
        Map metricsDataMap = this.monitorMetricsDataMap.computeIfAbsent(monitorId, key -> new ConcurrentHashMap(METRICS_SIZE));
        return new ArrayList<CollectRep.MetricsData>(metricsDataMap.values());
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        Long monitorId = metricsData.getId();
        String metrics = metricsData.getMetrics();
        if (metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        Map metricsDataMap = this.monitorMetricsDataMap.computeIfAbsent(monitorId, key -> new ConcurrentHashMap(METRICS_SIZE));
        metricsDataMap.put(metrics, metricsData);
    }

    public void destroy() {
        if (this.monitorMetricsDataMap != null) {
            this.monitorMetricsDataMap.clear();
        }
    }
}

