/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.vm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.vm.VictoriaMetricsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Primary
@Component
@ConditionalOnProperty(prefix="warehouse.store.victoria-metrics", name={"enabled"}, havingValue="true")
public class VictoriaMetricsDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(VictoriaMetricsDataStorage.class);
    private static final String IMPORT_PATH = "/api/v1/import";
    private static final String EXPORT_PATH = "/api/v1/export";
    private static final String QUERY_RANGE_PATH = "/api/v1/query_range";
    private static final String STATUS_PATH = "/api/v1/status/tsdb";
    private static final String LABEL_KEY_NAME = "__name__";
    private static final String LABEL_KEY_JOB = "job";
    private static final String LABEL_KEY_INSTANCE = "instance";
    private static final String SPILT = "_";
    private static final String MONITOR_METRICS_KEY = "__metrics__";
    private static final String MONITOR_METRIC_KEY = "__metric__";
    private final VictoriaMetricsProperties victoriaMetricsProp;
    private final RestTemplate restTemplate;

    public VictoriaMetricsDataStorage(VictoriaMetricsProperties victoriaMetricsProperties, RestTemplate restTemplate) {
        if (victoriaMetricsProperties == null) {
            log.error("init error, please config Warehouse victoriaMetrics props in application.yml");
            throw new IllegalArgumentException("please config Warehouse victoriaMetrics props");
        }
        this.restTemplate = restTemplate;
        this.victoriaMetricsProp = victoriaMetricsProperties;
        this.serverAvailable = this.checkVictoriaMetricsDatasourceAvailable();
    }

    private boolean checkVictoriaMetricsDatasourceAvailable() {
        try {
            HttpHeaders headers = new HttpHeaders();
            if (StringUtils.hasText((String)this.victoriaMetricsProp.username()) && StringUtils.hasText((String)this.victoriaMetricsProp.password())) {
                String authStr = this.victoriaMetricsProp.username() + ":" + this.victoriaMetricsProp.password();
                String encodedAuth = new String(Base64.encodeBase64((byte[])authStr.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(this.victoriaMetricsProp.url() + STATUS_PATH, HttpMethod.GET, httpEntity, String.class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.info("check victoria metrics server status success.");
                return true;
            }
            log.error("check victoria metrics server status not success: {}.", responseEntity.getBody());
        }
        catch (Exception e) {
            log.error("check victoria metrics server status error: {}.", (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (!this.isServerAvailable()) {
            this.serverAvailable = this.checkVictoriaMetricsDatasourceAvailable();
        }
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValuesList().isEmpty()) {
            log.info("[warehouse victoria-metrics] flush metrics data {} is null, ignore.", (Object)metricsData.getId());
            return;
        }
        HashMap<String, String> defaultLabels = new HashMap<String, String>(8);
        defaultLabels.put(MONITOR_METRICS_KEY, metricsData.getMetrics());
        boolean isPrometheusAuto = false;
        if (metricsData.getApp().startsWith("_prometheus_")) {
            isPrometheusAuto = true;
            defaultLabels.put(LABEL_KEY_JOB, metricsData.getApp().substring("_prometheus_".length()));
        } else {
            defaultLabels.put(LABEL_KEY_JOB, metricsData.getApp());
        }
        defaultLabels.put(LABEL_KEY_INSTANCE, String.valueOf(metricsData.getId()));
        List fields = metricsData.getFieldsList();
        Long[] timestamp = new Long[]{metricsData.getTime()};
        HashMap<String, Double> fieldsValue = new HashMap<String, Double>(fields.size());
        HashMap<String, String> labels = new HashMap<String, String>(fields.size());
        for (CollectRep.ValueRow valueRow : metricsData.getValuesList()) {
            fieldsValue.clear();
            labels.clear();
            for (int index = 0; index < fields.size(); ++index) {
                CollectRep.Field field = (CollectRep.Field)fields.get(index);
                String value = valueRow.getColumns(index);
                if (field.getType() == 0 && !field.getLabel() && !"&nbsp;".equals(value)) {
                    fieldsValue.put(field.getName(), CommonUtil.parseStrDouble((String)value));
                }
                if (!field.getLabel() || "&nbsp;".equals(value)) continue;
                labels.put(field.getName(), value);
            }
            for (Map.Entry entry : fieldsValue.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                try {
                    labels.putAll(defaultLabels);
                    String labelName = isPrometheusAuto ? metricsData.getMetrics() : metricsData.getMetrics() + SPILT + (String)entry.getKey();
                    labels.put(LABEL_KEY_NAME, labelName);
                    labels.put(MONITOR_METRIC_KEY, (String)entry.getKey());
                    VictoriaMetricsContent content = VictoriaMetricsContent.builder().metric(labels).values(new Double[]{(Double)entry.getValue()}).timestamps(timestamp).build();
                    HttpHeaders headers = new HttpHeaders();
                    headers.setContentType(MediaType.APPLICATION_JSON);
                    if (StringUtils.hasText((String)this.victoriaMetricsProp.username()) && StringUtils.hasText((String)this.victoriaMetricsProp.password())) {
                        String authStr = this.victoriaMetricsProp.username() + ":" + this.victoriaMetricsProp.password();
                        String encodedAuth = new String(Base64.encodeBase64((byte[])authStr.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                        headers.add("Authorization", "Basic " + encodedAuth);
                    }
                    HttpEntity httpEntity = new HttpEntity((Object)content, (MultiValueMap)headers);
                    ResponseEntity responseEntity = this.restTemplate.postForEntity(this.victoriaMetricsProp.url() + IMPORT_PATH, (Object)httpEntity, String.class, new Object[0]);
                    if (responseEntity.getStatusCode().is2xxSuccessful()) {
                        log.debug("insert metrics data to victoria-metrics success. {}", (Object)content);
                        continue;
                    }
                    log.error("insert metrics data to victoria-metrics failed. {}", (Object)content);
                }
                catch (Exception e) {
                    log.error("flush metrics data to victoria-metrics error: {}.", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public void destroy() {
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        Object labelName = metrics + SPILT + metric;
        if ("prometheus".equals(app)) {
            labelName = metrics;
        }
        String timeSeriesSelector = "__name__=\"" + (String)labelName + "\",instance=\"" + monitorId + "\",__metric__=\"" + metric + "\"";
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.victoriaMetricsProp.username()) && StringUtils.hasText((String)this.victoriaMetricsProp.password())) {
                String authStr = this.victoriaMetricsProp.username() + ":" + this.victoriaMetricsProp.password();
                String encodedAuth = new String(Base64.encodeBase64((byte[])authStr.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.victoriaMetricsProp.url() + EXPORT_PATH)).queryParam(URLEncoder.encode("match[]", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode("{" + timeSeriesSelector + "}", StandardCharsets.UTF_8)}).queryParam("start", new Object[]{URLEncoder.encode("now-" + history, StandardCharsets.UTF_8)}).queryParam("end", new Object[]{"now"}).build(true).toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, String.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from victoria-metrics success. {}", (Object)uri);
                if (StringUtils.hasText((String)((String)responseEntity.getBody()))) {
                    String[] contentJsonArr = ((String)responseEntity.getBody()).split("\n");
                    List<VictoriaMetricsContent> contents = Arrays.stream(contentJsonArr).map(item -> (VictoriaMetricsContent)JsonUtil.fromJson((String)item, VictoriaMetricsContent.class)).toList();
                    for (VictoriaMetricsContent content : contents) {
                        Map<String, String> labels = content.getMetric();
                        labels.remove(LABEL_KEY_NAME);
                        labels.remove(LABEL_KEY_JOB);
                        labels.remove(LABEL_KEY_INSTANCE);
                        labels.remove(MONITOR_METRICS_KEY);
                        labels.remove(MONITOR_METRIC_KEY);
                        String labelStr = JsonUtil.toJson(labels);
                        if (content.getValues() == null || content.getTimestamps() == null) continue;
                        List valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList());
                        if (content.getValues().length != content.getTimestamps().length) {
                            log.error("content.getValues().length != content.getTimestamps().length");
                            continue;
                        }
                        Double[] values = content.getValues();
                        Long[] timestamps = content.getTimestamps();
                        for (int index = 0; index < content.getValues().length; ++index) {
                            String strValue = BigDecimal.valueOf(values[index]).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                            valueList.add(new Value(strValue, timestamps[index].longValue()));
                        }
                    }
                }
            } else {
                log.error("query metrics data from victoria-metrics failed. {}", (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error("query metrics data from victoria-metrics error. {}.", (Object)e.getMessage(), (Object)e);
        }
        return instanceValuesMap;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        ZonedDateTime dateTime;
        long startTime;
        if (!this.serverAvailable) {
            log.error("\n\t---------------VictoriaMetrics Init Failed---------------\n\t--------------Please Config VictoriaMetrics--------------\n\t----------Can Not Use Metric History Now----------\n");
            return Collections.emptyMap();
        }
        long endTime = ZonedDateTime.now().toEpochSecond();
        try {
            if (NumberUtils.isParsable((String)history)) {
                startTime = NumberUtils.toLong((String)history);
                startTime = ZonedDateTime.now().toEpochSecond() - startTime;
            } else {
                TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)history);
                dateTime = ZonedDateTime.now().minus(temporalAmount);
                startTime = dateTime.toEpochSecond();
            }
        }
        catch (Exception e) {
            log.error("history time error: {}. use default: 6h", (Object)e.getMessage());
            dateTime = ZonedDateTime.now().minus(Duration.ofHours(6L));
            startTime = dateTime.toEpochSecond();
        }
        Object labelName = metrics + SPILT + metric;
        if ("prometheus".equals(app)) {
            labelName = metrics;
        }
        String timeSeriesSelector = "__name__=\"" + (String)labelName + "\",instance=\"" + monitorId + "\",__metric__=\"" + metric + "\"";
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        try {
            Value value;
            List valueList;
            String labelStr;
            Map<String, String> labels;
            List<VictoriaMetricsQueryContent.ContentData.Content> contents;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.victoriaMetricsProp.username()) && StringUtils.hasText((String)this.victoriaMetricsProp.password())) {
                String authStr = this.victoriaMetricsProp.username() + ":" + this.victoriaMetricsProp.password();
                String encodedAuth = new String(Base64.encodeBase64((byte[])authStr.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.victoriaMetricsProp.url() + QUERY_RANGE_PATH)).queryParam(URLEncoder.encode("query", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode("{" + timeSeriesSelector + "}", StandardCharsets.UTF_8)}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build(true).toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, VictoriaMetricsQueryContent.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from victoria-metrics success. {}", (Object)uri);
                if (responseEntity.getBody() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    contents = ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult();
                    for (VictoriaMetricsQueryContent.ContentData.Content content : contents) {
                        labels = content.getMetric();
                        labels.remove(LABEL_KEY_NAME);
                        labels.remove(LABEL_KEY_JOB);
                        labels.remove(LABEL_KEY_INSTANCE);
                        labels.remove(MONITOR_METRICS_KEY);
                        labels.remove(MONITOR_METRIC_KEY);
                        labelStr = JsonUtil.toJson(labels);
                        if (content.getValues() == null || content.getValues().isEmpty()) continue;
                        valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList());
                        for (Object[] valueArr : content.getValues()) {
                            long timestamp = Long.parseLong(String.valueOf(valueArr[0]));
                            String value2 = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                            valueList.add(new Value(value2, timestamp * 1000L));
                        }
                    }
                }
            } else {
                log.error("query metrics data from victoria-metrics failed. {}", (Object)responseEntity);
            }
            if ((responseEntity = this.restTemplate.exchange(uri = UriComponentsBuilder.fromHttpUrl((String)(this.victoriaMetricsProp.url() + QUERY_RANGE_PATH)).queryParam(URLEncoder.encode("query", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode("max_over_time({" + timeSeriesSelector + "})", StandardCharsets.UTF_8)}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build(true).toUri(), HttpMethod.GET, httpEntity, VictoriaMetricsQueryContent.class)).getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                contents = ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult();
                for (VictoriaMetricsQueryContent.ContentData.Content content : contents) {
                    labels = content.getMetric();
                    labels.remove(LABEL_KEY_NAME);
                    labels.remove(LABEL_KEY_JOB);
                    labels.remove(LABEL_KEY_INSTANCE);
                    labels.remove(MONITOR_METRICS_KEY);
                    labels.remove(MONITOR_METRIC_KEY);
                    labelStr = JsonUtil.toJson(labels);
                    if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
                    for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                        value = (Value)valueList.get(timestampIndex);
                        Object[] valueArr = content.getValues().get(timestampIndex);
                        String maxValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        value.setMax(maxValue);
                    }
                }
            }
            if ((responseEntity = this.restTemplate.exchange(uri = UriComponentsBuilder.fromHttpUrl((String)(this.victoriaMetricsProp.url() + QUERY_RANGE_PATH)).queryParam(URLEncoder.encode("query", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode("min_over_time({" + timeSeriesSelector + "})", StandardCharsets.UTF_8)}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build(true).toUri(), HttpMethod.GET, httpEntity, VictoriaMetricsQueryContent.class)).getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                contents = ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult();
                for (VictoriaMetricsQueryContent.ContentData.Content content : contents) {
                    labels = content.getMetric();
                    labels.remove(LABEL_KEY_NAME);
                    labels.remove(LABEL_KEY_JOB);
                    labels.remove(LABEL_KEY_INSTANCE);
                    labels.remove(MONITOR_METRICS_KEY);
                    labels.remove(MONITOR_METRIC_KEY);
                    labelStr = JsonUtil.toJson(labels);
                    if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
                    for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                        value = (Value)valueList.get(timestampIndex);
                        Object[] valueArr = content.getValues().get(timestampIndex);
                        String minValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        value.setMin(minValue);
                    }
                }
            }
            if ((responseEntity = this.restTemplate.exchange(uri = UriComponentsBuilder.fromHttpUrl((String)(this.victoriaMetricsProp.url() + QUERY_RANGE_PATH)).queryParam(URLEncoder.encode("query", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode("avg_over_time({" + timeSeriesSelector + "})", StandardCharsets.UTF_8)}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build(true).toUri(), HttpMethod.GET, httpEntity, VictoriaMetricsQueryContent.class)).getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData() != null && ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                contents = ((VictoriaMetricsQueryContent)responseEntity.getBody()).getData().getResult();
                for (VictoriaMetricsQueryContent.ContentData.Content content : contents) {
                    labels = content.getMetric();
                    labels.remove(LABEL_KEY_NAME);
                    labels.remove(LABEL_KEY_JOB);
                    labels.remove(LABEL_KEY_INSTANCE);
                    labels.remove(MONITOR_METRICS_KEY);
                    labels.remove(MONITOR_METRIC_KEY);
                    labelStr = JsonUtil.toJson(labels);
                    if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
                    for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                        value = (Value)valueList.get(timestampIndex);
                        Object[] valueArr = content.getValues().get(timestampIndex);
                        String avgValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        value.setMean(avgValue);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("query metrics data from victoria-metrics error. {}.", (Object)e.getMessage(), (Object)e);
        }
        return instanceValuesMap;
    }

    public static final class VictoriaMetricsContent {
        private Map<String, String> metric;
        private Double[] values;
        private Long[] timestamps;

        public static VictoriaMetricsContentBuilder builder() {
            return new VictoriaMetricsContentBuilder();
        }

        public Map<String, String> getMetric() {
            return this.metric;
        }

        public Double[] getValues() {
            return this.values;
        }

        public Long[] getTimestamps() {
            return this.timestamps;
        }

        public void setMetric(Map<String, String> metric) {
            this.metric = metric;
        }

        public void setValues(Double[] values) {
            this.values = values;
        }

        public void setTimestamps(Long[] timestamps) {
            this.timestamps = timestamps;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VictoriaMetricsContent)) {
                return false;
            }
            VictoriaMetricsContent other = (VictoriaMetricsContent)o;
            Map<String, String> this$metric = this.getMetric();
            Map<String, String> other$metric = other.getMetric();
            if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getValues(), other.getValues())) {
                return false;
            }
            return Arrays.deepEquals(this.getTimestamps(), other.getTimestamps());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $metric = this.getMetric();
            result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getValues());
            result = result * 59 + Arrays.deepHashCode(this.getTimestamps());
            return result;
        }

        public String toString() {
            return "VictoriaMetricsDataStorage.VictoriaMetricsContent(metric=" + this.getMetric() + ", values=" + Arrays.deepToString(this.getValues()) + ", timestamps=" + Arrays.deepToString(this.getTimestamps()) + ")";
        }

        public VictoriaMetricsContent(Map<String, String> metric, Double[] values, Long[] timestamps) {
            this.metric = metric;
            this.values = values;
            this.timestamps = timestamps;
        }

        public VictoriaMetricsContent() {
        }

        public static class VictoriaMetricsContentBuilder {
            private Map<String, String> metric;
            private Double[] values;
            private Long[] timestamps;

            VictoriaMetricsContentBuilder() {
            }

            public VictoriaMetricsContentBuilder metric(Map<String, String> metric) {
                this.metric = metric;
                return this;
            }

            public VictoriaMetricsContentBuilder values(Double[] values) {
                this.values = values;
                return this;
            }

            public VictoriaMetricsContentBuilder timestamps(Long[] timestamps) {
                this.timestamps = timestamps;
                return this;
            }

            public VictoriaMetricsContent build() {
                return new VictoriaMetricsContent(this.metric, this.values, this.timestamps);
            }

            public String toString() {
                return "VictoriaMetricsDataStorage.VictoriaMetricsContent.VictoriaMetricsContentBuilder(metric=" + this.metric + ", values=" + Arrays.deepToString(this.values) + ", timestamps=" + Arrays.deepToString(this.timestamps) + ")";
            }
        }
    }

    public static final class VictoriaMetricsQueryContent {
        private String status;
        private ContentData data;

        public static VictoriaMetricsQueryContentBuilder builder() {
            return new VictoriaMetricsQueryContentBuilder();
        }

        public String getStatus() {
            return this.status;
        }

        public ContentData getData() {
            return this.data;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setData(ContentData data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VictoriaMetricsQueryContent)) {
                return false;
            }
            VictoriaMetricsQueryContent other = (VictoriaMetricsQueryContent)o;
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            ContentData this$data = this.getData();
            ContentData other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            ContentData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "VictoriaMetricsDataStorage.VictoriaMetricsQueryContent(status=" + this.getStatus() + ", data=" + this.getData() + ")";
        }

        public VictoriaMetricsQueryContent(String status, ContentData data) {
            this.status = status;
            this.data = data;
        }

        public VictoriaMetricsQueryContent() {
        }

        public static class VictoriaMetricsQueryContentBuilder {
            private String status;
            private ContentData data;

            VictoriaMetricsQueryContentBuilder() {
            }

            public VictoriaMetricsQueryContentBuilder status(String status) {
                this.status = status;
                return this;
            }

            public VictoriaMetricsQueryContentBuilder data(ContentData data) {
                this.data = data;
                return this;
            }

            public VictoriaMetricsQueryContent build() {
                return new VictoriaMetricsQueryContent(this.status, this.data);
            }

            public String toString() {
                return "VictoriaMetricsDataStorage.VictoriaMetricsQueryContent.VictoriaMetricsQueryContentBuilder(status=" + this.status + ", data=" + this.data + ")";
            }
        }

        public static final class ContentData {
            private String resultType;
            private List<Content> result;

            public String getResultType() {
                return this.resultType;
            }

            public List<Content> getResult() {
                return this.result;
            }

            public void setResultType(String resultType) {
                this.resultType = resultType;
            }

            public void setResult(List<Content> result) {
                this.result = result;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContentData)) {
                    return false;
                }
                ContentData other = (ContentData)o;
                String this$resultType = this.getResultType();
                String other$resultType = other.getResultType();
                if (this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType)) {
                    return false;
                }
                List<Content> this$result = this.getResult();
                List<Content> other$result = other.getResult();
                return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $resultType = this.getResultType();
                result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
                List<Content> $result = this.getResult();
                result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
                return result;
            }

            public String toString() {
                return "VictoriaMetricsDataStorage.VictoriaMetricsQueryContent.ContentData(resultType=" + this.getResultType() + ", result=" + this.getResult() + ")";
            }

            public ContentData(String resultType, List<Content> result) {
                this.resultType = resultType;
                this.result = result;
            }

            public ContentData() {
            }

            public static final class Content {
                private Map<String, String> metric;
                private Object[] value;
                private List<Object[]> values;

                public Map<String, String> getMetric() {
                    return this.metric;
                }

                public Object[] getValue() {
                    return this.value;
                }

                public List<Object[]> getValues() {
                    return this.values;
                }

                public void setMetric(Map<String, String> metric) {
                    this.metric = metric;
                }

                public void setValue(Object[] value) {
                    this.value = value;
                }

                public void setValues(List<Object[]> values) {
                    this.values = values;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Content)) {
                        return false;
                    }
                    Content other = (Content)o;
                    Map<String, String> this$metric = this.getMetric();
                    Map<String, String> other$metric = other.getMetric();
                    if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
                        return false;
                    }
                    if (!Arrays.deepEquals(this.getValue(), other.getValue())) {
                        return false;
                    }
                    List<Object[]> this$values = this.getValues();
                    List<Object[]> other$values = other.getValues();
                    return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, String> $metric = this.getMetric();
                    result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
                    result = result * 59 + Arrays.deepHashCode(this.getValue());
                    List<Object[]> $values = this.getValues();
                    result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
                    return result;
                }

                public String toString() {
                    return "VictoriaMetricsDataStorage.VictoriaMetricsQueryContent.ContentData.Content(metric=" + this.getMetric() + ", value=" + Arrays.deepToString(this.getValue()) + ", values=" + this.getValues() + ")";
                }

                public Content(Map<String, String> metric, Object[] value, List<Object[]> values) {
                    this.metric = metric;
                    this.value = value;
                    this.values = values;
                }

                public Content() {
                }
            }
        }
    }
}

