/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.tdengine;

import com.taosdata.jdbc.utils.StringUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.tdengine.TdEngineProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
@ConditionalOnProperty(prefix="warehouse.store.td-engine", name={"enabled"}, havingValue="true")
public class TdEngineDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(TdEngineDataStorage.class);
    private static final String CONSTANTS_URL_PREFIX = "jdbc:TAOS://";
    private static final Pattern SQL_SPECIAL_STRING_PATTERN = Pattern.compile("(\\\\)|(')");
    private static final String INSTANCE_NULL = "''";
    private static final String CONSTANTS_CREATE_DATABASE = "CREATE DATABASE IF NOT EXISTS %s";
    private static final String INSERT_TABLE_DATA_SQL = "INSERT INTO `%s` USING `%s` TAGS (%s) VALUES %s";
    private static final String CREATE_SUPER_TABLE_SQL = "CREATE STABLE IF NOT EXISTS `%s` %s TAGS (monitor BIGINT)";
    private static final String NO_SUPER_TABLE_ERROR = "Table does not exist";
    private static final String QUERY_HISTORY_WITH_INSTANCE_SQL = "SELECT ts, instance, `%s` FROM `%s` WHERE instance = '%s' AND ts >= now - %s order by ts desc";
    private static final String QUERY_HISTORY_SQL = "SELECT ts, instance, `%s` FROM `%s` WHERE ts >= now - %s order by ts desc";
    private static final String QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL = "SELECT first(ts), first(`%s`), avg(`%s`), min(`%s`), max(`%s`) FROM `%s` WHERE instance = '%s' AND ts >= now - %s interval(4h)";
    private static final String QUERY_INSTANCE_SQL = "SELECT DISTINCT instance FROM `%s` WHERE ts >= now - 1w";
    private static final String TABLE_NOT_EXIST = "Table does not exist";
    private static final Runnable INSTANCE_EXCEPTION_PRINT = () -> {
        if (log.isErrorEnabled()) {
            log.error("\t---------------TdEngine Init Failed---------------\n\t--------------Please Config Tdengine--------------\n\t----------Can Not Use Metric History Now----------\n");
        }
    };
    private HikariDataSource hikariDataSource;
    private final int tableStrColumnDefineMaxLength;

    public TdEngineDataStorage(TdEngineProperties tdEngineProperties) {
        if (tdEngineProperties == null) {
            log.error("init error, please config Warehouse TdEngine props in application.yml");
            throw new IllegalArgumentException("please config Warehouse TdEngine props");
        }
        this.tableStrColumnDefineMaxLength = tdEngineProperties.tableStrColumnDefineMaxLength();
        this.serverAvailable = this.initTdEngineDatasource(tdEngineProperties);
    }

    private void initTdEngineDatabase(TdEngineProperties tdEngineProperties) throws SQLException {
        Properties parseResultProperties = StringUtils.parseUrl((String)tdEngineProperties.url(), null);
        String host = (String)ObjectUtils.requireNonEmpty((Object)parseResultProperties.getProperty("host"));
        String port = (String)ObjectUtils.requireNonEmpty((Object)parseResultProperties.getProperty("port"));
        String dbName = (String)ObjectUtils.requireNonEmpty((Object)parseResultProperties.getProperty("dbname"));
        try (Connection tempConnection = DriverManager.getConnection(CONSTANTS_URL_PREFIX + host + ":" + port, tdEngineProperties.username(), tdEngineProperties.password());){
            tempConnection.prepareStatement(String.format(CONSTANTS_CREATE_DATABASE, dbName)).execute();
        }
    }

    private boolean initTdEngineDatasource(TdEngineProperties tdEngineProperties) {
        try {
            this.initTdEngineDatabase(tdEngineProperties);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            INSTANCE_EXCEPTION_PRINT.run();
            return false;
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(tdEngineProperties.url());
        config.setUsername(tdEngineProperties.username());
        config.setPassword(tdEngineProperties.password());
        config.setDriverClassName(tdEngineProperties.driverClassName());
        config.setMinimumIdle(10);
        config.setMaximumPoolSize(10);
        config.setConnectionTimeout(30000L);
        config.setMaxLifetime(0L);
        config.setIdleTimeout(0L);
        config.setConnectionTestQuery("select server_status()");
        try {
            this.hikariDataSource = new HikariDataSource(config);
        }
        catch (Exception e) {
            INSTANCE_EXCEPTION_PRINT.run();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValuesList().isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("[warehouse tdengine] flush metrics data {} is null, ignore.", (Object)metricsData.getId());
            }
            return;
        }
        String monitorId = String.valueOf(metricsData.getId());
        String superTable = metricsData.getApp() + "_" + metricsData.getMetrics() + "_super";
        String table = metricsData.getApp() + "_" + metricsData.getMetrics() + "_" + monitorId;
        List fields = metricsData.getFieldsList();
        StringBuilder sqlBuffer = new StringBuilder();
        int i = 0;
        for (CollectRep.ValueRow valueRow : metricsData.getValuesList()) {
            StringBuilder sqlRowBuffer = new StringBuilder("(");
            sqlRowBuffer.append(metricsData.getTime() + (long)i++).append(", ");
            HashMap<String, String> labels = new HashMap<String, String>(8);
            sqlRowBuffer.append("'").append("%s").append("', ");
            for (int index = 0; index < fields.size(); ++index) {
                CollectRep.Field field = (CollectRep.Field)fields.get(index);
                String value = valueRow.getColumns(index);
                int fieldType = field.getType();
                if (fieldType == 0 || fieldType == 3) {
                    if ("&nbsp;".equals(value)) {
                        sqlRowBuffer.append("NULL");
                    } else {
                        try {
                            double number = Double.parseDouble(value);
                            sqlRowBuffer.append(number);
                        }
                        catch (Exception e) {
                            if (log.isWarnEnabled()) {
                                log.warn(e.getMessage());
                            }
                            sqlRowBuffer.append("NULL");
                        }
                    }
                } else if ("&nbsp;".equals(value)) {
                    sqlRowBuffer.append("NULL");
                } else {
                    sqlRowBuffer.append("'").append(this.formatStringValue(value)).append("'");
                }
                if (field.getLabel() && !"&nbsp;".equals(value)) {
                    labels.put(field.getName(), this.formatStringValue(value));
                }
                if (index == fields.size() - 1) continue;
                sqlRowBuffer.append(", ");
            }
            sqlRowBuffer.append(")");
            sqlBuffer.append(" ").append(String.format(sqlRowBuffer.toString(), this.formatStringValue(JsonUtil.toJson(labels))));
        }
        String insertDataSql = String.format(INSERT_TABLE_DATA_SQL, table, superTable, monitorId, sqlBuffer);
        if (log.isDebugEnabled()) {
            log.debug(insertDataSql);
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.hikariDataSource.getConnection();
            statement = connection.createStatement();
            statement.execute(insertDataSql);
            connection.close();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Table does not exist")) {
                StringBuilder fieldSqlBuilder = new StringBuilder("(");
                fieldSqlBuilder.append("ts TIMESTAMP, ");
                fieldSqlBuilder.append("instance NCHAR(").append(this.tableStrColumnDefineMaxLength).append("), ");
                for (int index = 0; index < fields.size(); ++index) {
                    CollectRep.Field field = (CollectRep.Field)fields.get(index);
                    String fieldName = field.getName();
                    int fieldType = field.getType();
                    if (fieldType == 0 || fieldType == 3) {
                        fieldSqlBuilder.append("`").append(fieldName).append("` ").append("DOUBLE");
                    } else {
                        fieldSqlBuilder.append("`").append(fieldName).append("` ").append("NCHAR(").append(this.tableStrColumnDefineMaxLength).append(")");
                    }
                    if (index == fields.size() - 1) continue;
                    fieldSqlBuilder.append(", ");
                }
                fieldSqlBuilder.append(")");
                String createTableSql = String.format(CREATE_SUPER_TABLE_SQL, superTable, fieldSqlBuilder);
                try {
                    assert (statement != null);
                    if (log.isInfoEnabled()) {
                        log.info("[tdengine-data]: create {} use sql: {}.", (Object)superTable, (Object)createTableSql);
                    }
                    statement.execute(createTableSql);
                    statement.execute(insertDataSql);
                }
                catch (Exception createTableException) {
                    if (log.isErrorEnabled()) {
                        log.error(e.getMessage(), (Throwable)createTableException);
                    }
                }
            } else if (log.isErrorEnabled()) {
                log.error(e.getMessage());
            }
        }
        finally {
            block40: {
                try {
                    assert (connection != null);
                    connection.close();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block40;
                    log.error(e.getMessage());
                }
            }
        }
    }

    private String formatStringValue(String value) {
        String formatValue = SQL_SPECIAL_STRING_PATTERN.matcher(value).replaceAll("\\\\$0");
        if (formatValue != null && formatValue.length() > this.tableStrColumnDefineMaxLength) {
            formatValue = formatValue.substring(0, this.tableStrColumnDefineMaxLength);
        }
        return formatValue;
    }

    public void destroy() {
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        if (!this.serverAvailable) {
            INSTANCE_EXCEPTION_PRINT.run();
            return Collections.emptyMap();
        }
        String table = app + "_" + metrics + "_" + monitorId;
        LinkedList<String> instances = new LinkedList<String>();
        if (label != null) {
            instances.add(label);
        }
        if (instances.isEmpty()) {
            String queryInstanceSql = String.format(QUERY_INSTANCE_SQL, table);
            Connection connection = null;
            try {
                connection = this.hikariDataSource.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(queryInstanceSql);
                while (resultSet.next()) {
                    String instanceValue = resultSet.getString(1);
                    if (instanceValue == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)instanceValue)) {
                        instances.add(INSTANCE_NULL);
                        continue;
                    }
                    instances.add(instanceValue);
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage());
                }
            }
            finally {
                block35: {
                    try {
                        assert (connection != null);
                        connection.close();
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block35;
                        log.error(e.getMessage());
                    }
                }
            }
        }
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(instances.size());
        for (String instanceValue : instances) {
            if (INSTANCE_NULL.equals(instanceValue)) {
                instanceValue = "";
            }
            String selectSql = String.format(QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL, metric, metric, metric, metric, table, instanceValue, history);
            if (log.isDebugEnabled()) {
                log.debug(selectSql);
            }
            List values = instanceValuesMap.computeIfAbsent(instanceValue, k -> new LinkedList());
            Connection connection = null;
            try {
                connection = this.hikariDataSource.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(selectSql);
                while (resultSet.next()) {
                    Timestamp ts = resultSet.getTimestamp(1);
                    double origin = resultSet.getDouble(2);
                    String originStr = BigDecimal.valueOf(origin).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                    double avg = resultSet.getDouble(3);
                    String avgStr = BigDecimal.valueOf(avg).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                    double min = resultSet.getDouble(4);
                    String minStr = BigDecimal.valueOf(min).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                    double max = resultSet.getDouble(5);
                    String maxStr = BigDecimal.valueOf(max).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                    Value value = Value.builder().origin(originStr).mean(avgStr).min(minStr).max(maxStr).time(Long.valueOf(ts.getTime() / 100L * 100L)).build();
                    values.add(value);
                }
                resultSet.close();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    assert (connection != null);
                    connection.close();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error(e.getMessage());
                }
            }
        }
        return instanceValuesMap;
    }

    private static /* synthetic */ List lambda$getHistoryMetricData$1(String k) {
        return new LinkedList();
    }
}

