/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.greptime;

import com.mysql.cj.jdbc.Driver;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.greptime.GreptimeDB;
import io.greptime.models.AuthInfo;
import io.greptime.models.DataType;
import io.greptime.models.Result;
import io.greptime.models.Table;
import io.greptime.models.TableSchema;
import io.greptime.options.GreptimeOptions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.greptime.GreptimeProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GreptimeDbDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(GreptimeDbDataStorage.class);
    private static final String CONSTANT_DB_TTL = "30d";
    private static final String QUERY_HISTORY_SQL = "SELECT CAST (ts AS Int64) ts, instance, `%s` FROM `%s` WHERE ts >= now() -  interval '%s' and monitor_id = %s order by ts desc;";
    private static final String QUERY_HISTORY_WITH_INSTANCE_SQL = "SELECT CAST (ts AS Int64) ts, instance, `%s` FROM `%s` WHERE ts >= now() - interval '%s' and monitor_id = %s and instance = '%s' order by ts desc;";
    private static final String QUERY_INSTANCE_SQL = "SELECT DISTINCT instance FROM `%s` WHERE ts >= now() - interval '1 WEEK'";
    private static final String QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL = "SELECT CAST (ts AS Int64) ts, first_value(`%s`) range '4h' first, avg(`%s`) range '4h' avg, min(`%s`) range '4h' min, max(`%s`) range '4h' max FROM `%s` WHERE instance = '%s' AND ts >= now() - interval '%s' ALIGN '4h'";
    private static final String TABLE_NOT_EXIST = "not found";
    private static final String CONSTANTS_CREATE_DATABASE = "CREATE DATABASE IF NOT EXISTS `%s` WITH(ttl='%s')";
    private static final Runnable INSTANCE_EXCEPTION_PRINT = () -> {
        if (log.isErrorEnabled()) {
            log.error("\t---------------GreptimeDB Init Failed---------------\n\t--------------Please Config GreptimeDB--------------\nt-----------Can Not Use Metric History Now-----------\n");
        }
    };
    private HikariDataSource hikariDataSource;
    private GreptimeDB greptimeDb;

    public GreptimeDbDataStorage(GreptimeProperties greptimeProperties) {
        if (greptimeProperties == null) {
            log.error("init error, please config Warehouse GreptimeDB props in application.yml");
            throw new IllegalArgumentException("please config Warehouse GreptimeDB props");
        }
        this.serverAvailable = this.initGreptimeDbClient(greptimeProperties) && this.initGreptimeDbDataSource(greptimeProperties);
    }

    private void initGreptimeDb(GreptimeProperties greptimeProperties) throws SQLException {
        DriverPropertyInfo[] properties = new Driver().getPropertyInfo(greptimeProperties.url(), null);
        String host = (String)ObjectUtils.requireNonEmpty((Object)properties[0].value);
        String port = (String)ObjectUtils.requireNonEmpty((Object)properties[1].value);
        String dbName = (String)ObjectUtils.requireNonEmpty((Object)properties[2].value);
        String ttl = greptimeProperties.expireTime();
        if (ttl == null || StringUtils.isBlank((CharSequence)ttl.trim())) {
            ttl = CONSTANT_DB_TTL;
        }
        try (Connection tempConnection = DriverManager.getConnection("jdbc:mysql://" + host + ":" + port, greptimeProperties.username(), greptimeProperties.password());
             PreparedStatement pstmt = tempConnection.prepareStatement(String.format(CONSTANTS_CREATE_DATABASE, dbName, ttl));){
            log.info("[warehouse greptime] try to create database `{}` if not exists", (Object)dbName);
            pstmt.execute();
        }
    }

    private boolean initGreptimeDbClient(GreptimeProperties greptimeProperties) {
        String endpoints = greptimeProperties.grpcEndpoints();
        try {
            DriverPropertyInfo[] properties = new Driver().getPropertyInfo(greptimeProperties.url(), null);
            String dbName = (String)ObjectUtils.requireNonEmpty((Object)properties[2].value);
            GreptimeOptions opts = GreptimeOptions.newBuilder((String[])endpoints.split(","), (String)dbName).writeMaxRetries(3).authInfo(new AuthInfo(greptimeProperties.username(), greptimeProperties.password())).routeTableRefreshPeriodSeconds(30L).build();
            this.greptimeDb = GreptimeDB.create((GreptimeOptions)opts);
        }
        catch (Exception e) {
            log.error("[warehouse greptime] Fail to start GreptimeDB client");
            return false;
        }
        return true;
    }

    private boolean initGreptimeDbDataSource(GreptimeProperties greptimeProperties) {
        try {
            this.initGreptimeDb(greptimeProperties);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            INSTANCE_EXCEPTION_PRINT.run();
            return false;
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(greptimeProperties.url());
        config.setUsername(greptimeProperties.username());
        config.setPassword(greptimeProperties.password());
        config.setDriverClassName(greptimeProperties.driverClassName());
        config.setMinimumIdle(10);
        config.setMaximumPoolSize(10);
        config.setConnectionTimeout(30000L);
        config.setMaxLifetime(0L);
        config.setIdleTimeout(0L);
        config.setConnectionTestQuery("select 1");
        try {
            this.hikariDataSource = new HikariDataSource(config);
        }
        catch (Exception e) {
            INSTANCE_EXCEPTION_PRINT.run();
            return false;
        }
        return true;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        block15: {
            if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
                return;
            }
            if (metricsData.getValuesList().isEmpty()) {
                log.info("[warehouse greptime] flush metrics data {} is null, ignore.", (Object)metricsData.getId());
                return;
            }
            String monitorId = String.valueOf(metricsData.getId());
            String tableName = this.getTableName(metricsData.getApp(), metricsData.getMetrics());
            TableSchema.Builder tableSchemaBuilder = TableSchema.newBuilder((String)tableName);
            tableSchemaBuilder.addTag("monitor_id", DataType.String).addTag("instance", DataType.String).addTimestamp("ts", DataType.TimestampMillisecond);
            List fieldsList = metricsData.getFieldsList();
            for (CollectRep.Field field : fieldsList) {
                if (field.getType() == 0) {
                    tableSchemaBuilder.addField(field.getName(), DataType.Float64);
                    continue;
                }
                if (field.getType() != 1) continue;
                tableSchemaBuilder.addField(field.getName(), DataType.String);
            }
            Table table = Table.from((TableSchema)tableSchemaBuilder.build());
            try {
                long now = System.currentTimeMillis();
                Object[] values = new Object[3 + fieldsList.size()];
                values[0] = monitorId;
                values[2] = now;
                for (CollectRep.ValueRow valueRow : metricsData.getValuesList()) {
                    HashMap<String, String> labels = new HashMap<String, String>(8);
                    for (int i = 0; i < fieldsList.size(); ++i) {
                        if (!"&nbsp;".equals(valueRow.getColumns(i))) {
                            CollectRep.Field field = (CollectRep.Field)fieldsList.get(i);
                            if (field.getType() == 0) {
                                values[3 + i] = Double.parseDouble(valueRow.getColumns(i));
                            } else if (field.getType() == 1) {
                                values[3 + i] = valueRow.getColumns(i);
                            }
                            if (!field.getLabel()) continue;
                            labels.put(field.getName(), String.valueOf(values[3 + i]));
                            continue;
                        }
                        values[3 + i] = null;
                    }
                    values[1] = JsonUtil.toJson(labels);
                    table.addRow(values);
                }
                CompletableFuture writeFuture = this.greptimeDb.write(new Table[]{table});
                try {
                    Result result = (Result)writeFuture.get(10L, TimeUnit.SECONDS);
                    if (result.isOk()) {
                        log.debug("[warehouse greptime]-Write successful");
                        break block15;
                    }
                    log.warn("[warehouse greptime]--Write failed: {}", result.getErr());
                }
                catch (Throwable throwable) {
                    log.error("[warehouse greptime]--Error occurred: {}", (Object)throwable.getMessage());
                }
            }
            catch (Exception e) {
                log.error("[warehouse greptime]--Error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getTableName(String app, String metrics) {
        return app + "_" + metrics;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        LinkedList<String> instances;
        String table;
        block47: {
            if (!this.isServerAvailable()) {
                INSTANCE_EXCEPTION_PRINT.run();
                return Collections.emptyMap();
            }
            table = this.getTableName(app, metrics);
            instances = new LinkedList<String>();
            if (label != null && !StringUtils.isBlank((CharSequence)label)) {
                instances.add(label);
            }
            if (instances.isEmpty()) {
                String selectSql = String.format(QUERY_INSTANCE_SQL, table);
                if (log.isDebugEnabled()) {
                    log.debug("[warehouse greptime] getHistoryIntervalMetricData sql: {}", (Object)selectSql);
                }
                try (Connection connection = this.hikariDataSource.getConnection();
                     Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(selectSql);){
                    while (resultSet.next()) {
                        String instanceValue = resultSet.getString(1);
                        if (instanceValue == null || StringUtils.isBlank((CharSequence)instanceValue)) {
                            instances.add("''");
                            continue;
                        }
                        instances.add(instanceValue);
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block47;
                    log.error("[warehouse greptime] failed to query instances{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(instances.size());
        for (String instanceValue : instances) {
            String selectSql = String.format(QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL, metric, metric, metric, metric, table, instanceValue, this.history2interval(history));
            if (log.isDebugEnabled()) {
                log.debug("[warehouse greptime] getHistoryIntervalMetricData sql: {}", (Object)selectSql);
            }
            List values = instanceValuesMap.computeIfAbsent(instanceValue, k -> new LinkedList());
            try {
                Connection connection = this.hikariDataSource.getConnection();
                try {
                    Statement statement = connection.createStatement();
                    try {
                        ResultSet resultSet = statement.executeQuery(selectSql);
                        try {
                            while (resultSet.next()) {
                                long ts = resultSet.getLong(1);
                                if (ts == 0L) {
                                    if (!log.isErrorEnabled()) continue;
                                    log.error("[warehouse greptime] getHistoryIntervalMetricData query result timestamp is 0, ignore. {}.", (Object)selectSql);
                                    continue;
                                }
                                double origin = resultSet.getDouble(2);
                                String originStr = this.double2decimalString(origin);
                                double avg = resultSet.getDouble(3);
                                String avgStr = this.double2decimalString(avg);
                                double min = resultSet.getDouble(4);
                                String minStr = this.double2decimalString(min);
                                double max = resultSet.getDouble(5);
                                String maxStr = this.double2decimalString(max);
                                Value value = Value.builder().origin(originStr).mean(avgStr).min(minStr).max(maxStr).time(Long.valueOf(ts)).build();
                                values.add(value);
                            }
                            resultSet.close();
                        }
                        finally {
                            if (resultSet == null) continue;
                            resultSet.close();
                        }
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error("[warehouse greptime] failed to getHistoryIntervalMetricData: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return instanceValuesMap;
    }

    private String history2interval(String history) {
        if (history == null) {
            return null;
        }
        history = history.trim().toLowerCase();
        return history.replaceAll("d", " day").replaceAll("s", " second").replaceAll("w", " week").replaceAll("h", " hour").replaceAll("m", " minute");
    }

    private String double2decimalString(double d) {
        return BigDecimal.valueOf(d).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    public void destroy() {
        if (this.greptimeDb != null) {
            this.greptimeDb.shutdownGracefully();
            this.greptimeDb = null;
        }
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
            this.hikariDataSource = null;
        }
    }

    private static /* synthetic */ List lambda$getHistoryMetricData$1(String k) {
        return new LinkedList();
    }
}

