/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store;

import java.util.Optional;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.plugin.PostCollectPlugin;
import org.apache.hertzbeat.plugin.runner.PluginRunner;
import org.apache.hertzbeat.warehouse.WarehouseWorkerPool;
import org.apache.hertzbeat.warehouse.store.history.HistoryDataWriter;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataStorageDispatch {
    private static final Logger log = LoggerFactory.getLogger(DataStorageDispatch.class);
    private final CommonDataQueue commonDataQueue;
    private final WarehouseWorkerPool workerPool;
    private final RealTimeDataWriter realTimeDataWriter;
    private final Optional<HistoryDataWriter> historyDataWriter;
    private final PluginRunner pluginRunner;

    public DataStorageDispatch(CommonDataQueue commonDataQueue, WarehouseWorkerPool workerPool, Optional<HistoryDataWriter> historyDataWriter, RealTimeDataWriter realTimeDataWriter, PluginRunner pluginRunner) {
        this.commonDataQueue = commonDataQueue;
        this.workerPool = workerPool;
        this.realTimeDataWriter = realTimeDataWriter;
        this.historyDataWriter = historyDataWriter;
        this.pluginRunner = pluginRunner;
        this.startPersistentDataStorage();
        this.startRealTimeDataStorage();
    }

    private void startRealTimeDataStorage() {
        Runnable runnable = () -> {
            Thread.currentThread().setName("warehouse-realtime-data-storage");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = this.commonDataQueue.pollMetricsDataToRealTimeStorage();
                    if (metricsData == null) continue;
                    this.realTimeDataWriter.saveData(metricsData);
                    this.pluginRunner.pluginExecute(PostCollectPlugin.class, (postCollectPlugin, pluginContext) -> postCollectPlugin.execute(metricsData, pluginContext));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.workerPool.executeJob(runnable);
    }

    protected void startPersistentDataStorage() {
        Runnable runnable = () -> {
            Thread.currentThread().setName("warehouse-persistent-data-storage");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = this.commonDataQueue.pollMetricsDataToPersistentStorage();
                    if (metricsData == null) continue;
                    this.historyDataWriter.ifPresent(dataWriter -> dataWriter.saveData(metricsData));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.workerPool.executeJob(runnable);
    }
}

