/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.service.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.dto.Field;
import org.apache.hertzbeat.common.entity.dto.MetricsData;
import org.apache.hertzbeat.common.entity.dto.MetricsHistoryData;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.dto.ValueRow;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.warehouse.service.MetricsDataService;
import org.apache.hertzbeat.warehouse.store.history.HistoryDataReader;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataReader;
import org.springframework.stereotype.Service;

@Service
public class MetricsDataServiceImpl
implements MetricsDataService {
    private final RealTimeDataReader realTimeDataReader;
    private final Optional<HistoryDataReader> historyDataReader;

    public MetricsDataServiceImpl(RealTimeDataReader realTimeDataReader, Optional<HistoryDataReader> historyDataReader) {
        this.realTimeDataReader = realTimeDataReader;
        this.historyDataReader = historyDataReader;
    }

    @Override
    public Boolean getWarehouseStorageServerStatus() {
        return this.historyDataReader.isPresent() && this.historyDataReader.get().isServerAvailable();
    }

    @Override
    public MetricsData getMetricsData(Long monitorId, String metrics) {
        boolean available = this.realTimeDataReader.isServerAvailable();
        if (!available) {
            throw new CommonException("real time store not available");
        }
        CollectRep.MetricsData storageData = this.realTimeDataReader.getCurrentMetricsData(monitorId, metrics);
        if (storageData == null) {
            return null;
        }
        MetricsData.MetricsDataBuilder dataBuilder = MetricsData.builder();
        dataBuilder.id(Long.valueOf(storageData.getId())).app(storageData.getApp()).metrics(storageData.getMetrics()).time(Long.valueOf(storageData.getTime()));
        List fields = storageData.getFieldsList().stream().map(tmpField -> Field.builder().name(tmpField.getName()).type(Byte.valueOf(Integer.valueOf(tmpField.getType()).byteValue())).label(Boolean.valueOf(tmpField.getLabel())).unit(tmpField.getUnit()).build()).collect(Collectors.toList());
        dataBuilder.fields(fields);
        LinkedList<ValueRow> valueRows = new LinkedList<ValueRow>();
        for (CollectRep.ValueRow valueRow : storageData.getValuesList()) {
            HashMap<String, String> labels = new HashMap<String, String>(8);
            LinkedList<Value> values = new LinkedList<Value>();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                String origin = valueRow.getColumns(i);
                if ("&nbsp;".equals(origin)) {
                    values.add(new Value());
                    continue;
                }
                values.add(new Value(origin));
                if (!field.getLabel().booleanValue()) continue;
                labels.put(field.getName(), origin);
            }
            valueRows.add(ValueRow.builder().labels(labels).values(values).build());
        }
        dataBuilder.valueRows(valueRows);
        return dataBuilder.build();
    }

    @Override
    public MetricsHistoryData getMetricHistoryData(Long monitorId, String app, String metrics, String metric, String label, String history, Boolean interval) {
        if (history == null) {
            history = "6h";
        }
        Map<String, List<Value>> instanceValuesMap = interval == null || interval == false ? this.historyDataReader.get().getHistoryMetricData(monitorId, app, metrics, metric, label, history) : this.historyDataReader.get().getHistoryIntervalMetricData(monitorId, app, metrics, metric, label, history);
        return MetricsHistoryData.builder().id(monitorId).metrics(metrics).values(instanceValuesMap).field(Field.builder().name(metric).type(Byte.valueOf((byte)0)).build()).build();
    }
}

