/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.snmp;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.SnmpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.fluent.SnmpBuilder;
import org.snmp4j.fluent.SnmpCompletableFuture;
import org.snmp4j.fluent.TargetBuilder;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SnmpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(SnmpCollectImpl.class);
    private static final String AES128 = "1";
    private static final String SHA1 = "1";
    private static final String DEFAULT_PROTOCOL = "udp";
    private static final String OPERATION_GET = "get";
    private static final String OPERATION_WALK = "walk";
    private static final String HEX_SPLIT = ":";
    private static final String FORMAT_PATTERN = "{0,choice,0#|1#1 day, |1<{0,number,integer} days, }{1,choice,0#|1#1 hour, |1<{1,number,integer} hours, }{2,choice,0#|1#1 minute, |1<{2,number,integer} minutes, }{3,choice,0#|1#1 second, |1<{3,number,integer} seconds }";
    private final Map<Integer, Snmp> versionSnmpService = new ConcurrentHashMap<Integer, Snmp>(3);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getSnmp() == null) {
            throw new IllegalArgumentException("Snmp collect must has snmp params");
        }
        SnmpProtocol snmpProtocol = metrics.getSnmp();
        Assert.hasText((String)snmpProtocol.getHost(), (String)"snmp host is required.");
        Assert.hasText((String)snmpProtocol.getPort(), (String)"snmp port is required.");
        Assert.notNull((Object)snmpProtocol.getVersion(), (String)"snmp version is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        SnmpProtocol snmpProtocol = metrics.getSnmp();
        int timeout = CollectUtil.getTimeout((String)snmpProtocol.getTimeout());
        int snmpVersion = this.getSnmpVersion(snmpProtocol.getVersion());
        Snmp snmpService = null;
        try {
            Target target;
            SnmpBuilder snmpBuilder = new SnmpBuilder();
            snmpService = this.getSnmpService(snmpVersion, snmpBuilder);
            snmpService.listen();
            Address targetAddress = GenericAddress.parse((String)("udp:" + snmpProtocol.getHost() + "/" + snmpProtocol.getPort()));
            TargetBuilder targetBuilder = snmpBuilder.target(targetAddress);
            if (snmpVersion == 3) {
                TargetBuilder.PrivProtocol privatePasswordEncryption = this.getPrivPasswordEncryption(snmpProtocol.getPrivPasswordEncryption());
                TargetBuilder.AuthProtocol authPasswordEncryption = this.getAuthPasswordEncryption(snmpProtocol.getAuthPasswordEncryption());
                target = targetBuilder.user(snmpProtocol.getUsername()).auth(authPasswordEncryption).authPassphrase(snmpProtocol.getAuthPassphrase()).priv(privatePasswordEncryption).privPassphrase(snmpProtocol.getPrivPassphrase()).done().timeout((long)timeout).retries(1).build();
                USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
                snmpService.getUSM().addUser(new OctetString(snmpProtocol.getUsername()), new UsmUser(new OctetString(snmpProtocol.getUsername()), AuthMD5.ID, new OctetString(snmpProtocol.getAuthPassphrase()), PrivDES.ID, new OctetString(snmpProtocol.getPrivPassphrase())));
            } else if (snmpVersion == 0) {
                target = targetBuilder.v1().community(new OctetString(snmpProtocol.getCommunity())).timeout((long)timeout).retries(1).build();
                target.setSecurityModel(1);
            } else {
                target = targetBuilder.v2c().community(new OctetString(snmpProtocol.getCommunity())).timeout((long)timeout).retries(1).build();
                target.setSecurityModel(2);
            }
            String operation = snmpProtocol.getOperation();
            String string = operation = StringUtils.hasText((String)operation) ? operation : OPERATION_GET;
            if (OPERATION_GET.equalsIgnoreCase(operation)) {
                String value;
                String contextName = this.getContextName(snmpProtocol.getContextName());
                PDU pdu = targetBuilder.pdu().type(-96).oids(snmpProtocol.getOids().values().toArray(new String[0])).contextName(contextName).build();
                SnmpCompletableFuture snmpRequestFuture = SnmpCompletableFuture.send((Snmp)snmpService, (Target)target, (PDU)pdu, (Object[])new Object[0]);
                List vbs = ((PDU)snmpRequestFuture.get()).getAll();
                long responseTime = System.currentTimeMillis() - startTime;
                Map oidsMap = snmpProtocol.getOids();
                HashMap<String, String> oidsValueMap = new HashMap<String, String>(oidsMap.size());
                for (Object binding : vbs) {
                    if (binding == null) continue;
                    Variable variable = binding.getVariable();
                    if (variable instanceof TimeTicks) {
                        TimeTicks timeTicks = (TimeTicks)variable;
                        value = timeTicks.toString(FORMAT_PATTERN);
                        oidsValueMap.put(binding.getOid().toDottedString(), value);
                        continue;
                    }
                    oidsValueMap.put(binding.getOid().toDottedString(), binding.toValueString());
                }
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String alias : metrics.getAliasFields()) {
                    if ("responseTime".equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumns(Long.toString(responseTime));
                        continue;
                    }
                    String oid = (String)oidsMap.get(alias);
                    value = (String)oidsValueMap.get(oid);
                    valueRowBuilder.addColumns(Objects.requireNonNullElse(value, "&nbsp;"));
                }
                builder.addValues(valueRowBuilder.build());
            } else if (OPERATION_WALK.equalsIgnoreCase(operation)) {
                Map oidMap = snmpProtocol.getOids();
                Assert.notEmpty((Map)oidMap, (String)"snmp oids is required when operation is walk.");
                TableUtils tableUtils = new TableUtils((Session)snmpService, (PDUFactory)new DefaultPDUFactory(-91));
                OID[] oids = (OID[])oidMap.values().stream().map(OID::new).toArray(OID[]::new);
                List tableEvents = tableUtils.getTable(target, oids, null, null);
                Assert.notNull((Object)tableEvents, (String)"snmp walk response empty content.");
                long responseTime = System.currentTimeMillis() - startTime;
                for (TableEvent tableEvent : tableEvents) {
                    if (tableEvent == null || tableEvent.isError()) continue;
                    VariableBinding[] varBindings = tableEvent.getColumns();
                    HashMap<String, String> oidsValueMap = new HashMap<String, String>(varBindings.length);
                    for (VariableBinding binding : varBindings) {
                        if (binding == null) continue;
                        Variable variable = binding.getVariable();
                        if (variable instanceof TimeTicks) {
                            TimeTicks timeTicks = (TimeTicks)variable;
                            String value = timeTicks.toString(FORMAT_PATTERN);
                            oidsValueMap.put(binding.getOid().trim().toDottedString(), value);
                            continue;
                        }
                        oidsValueMap.put(binding.getOid().trim().toDottedString(), this.bingdingHexValueToString(binding));
                    }
                    if (oidsValueMap.size() < metrics.getAliasFields().size() / 2) continue;
                    CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                    for (String alias : metrics.getAliasFields()) {
                        if ("responseTime".equalsIgnoreCase(alias)) {
                            valueRowBuilder.addColumns(Long.toString(responseTime));
                            continue;
                        }
                        String oid = (String)oidMap.get(alias);
                        String value = (String)oidsValueMap.get(oid);
                        if (value == null) {
                            for (String key : oidsValueMap.keySet()) {
                                if (!key.startsWith(oid)) continue;
                                value = (String)oidsValueMap.get(key);
                                break;
                            }
                        }
                        valueRowBuilder.addColumns(Objects.requireNonNullElse(value, "&nbsp;"));
                    }
                    builder.addValues(valueRowBuilder.build());
                }
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ex);
            log.warn("[snmp collect] error: {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("[snmp collect] error: {}", (Object)errorMsg, (Object)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (snmpService != null && snmpVersion == 3) {
                try {
                    this.snmpClose(snmpService, 3);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String supportProtocol() {
        return "snmp";
    }

    private synchronized Snmp getSnmpService(int snmpVersion, SnmpBuilder snmpBuilder) throws IOException {
        Snmp snmpService = this.versionSnmpService.get(snmpVersion);
        if (snmpService != null) {
            return snmpService;
        }
        snmpService = snmpVersion == 3 ? snmpBuilder.udp().v3().securityProtocols(SecurityProtocols.SecurityProtocolSet.maxCompatibility).usm().threads(4).build() : (snmpVersion == 0 ? snmpBuilder.udp().v1().threads(4).build() : snmpBuilder.udp().v2c().threads(4).build());
        this.versionSnmpService.put(snmpVersion, snmpService);
        return snmpService;
    }

    private int getSnmpVersion(String snmpVersion) {
        int version = 1;
        if (!StringUtils.hasText((String)snmpVersion)) {
            return version;
        }
        if (snmpVersion.equalsIgnoreCase(String.valueOf(0)) || snmpVersion.equalsIgnoreCase(TargetBuilder.SnmpVersion.v1.name())) {
            return 0;
        }
        if (snmpVersion.equalsIgnoreCase(String.valueOf(3)) || snmpVersion.equalsIgnoreCase(TargetBuilder.SnmpVersion.v3.name())) {
            return 3;
        }
        return version;
    }

    private String bingdingHexValueToString(VariableBinding binding) {
        String hexString = binding.toValueString();
        if (hexString.contains(HEX_SPLIT)) {
            try {
                String[] hexArr;
                StringBuilder output = new StringBuilder();
                for (String hex : hexArr = hexString.split(HEX_SPLIT)) {
                    output.append((char)Integer.parseInt(hex, 16));
                }
                return output.toString();
            }
            catch (Exception e) {
                return hexString;
            }
        }
        return hexString;
    }

    private void snmpClose(Snmp snmp, int version) throws IOException {
        snmp.close();
        this.versionSnmpService.remove(version);
    }

    private TargetBuilder.PrivProtocol getPrivPasswordEncryption(String privPasswordEncryption) {
        if (privPasswordEncryption == null) {
            return TargetBuilder.PrivProtocol.des;
        }
        if ("1".equals(privPasswordEncryption)) {
            return TargetBuilder.PrivProtocol.aes128;
        }
        return TargetBuilder.PrivProtocol.des;
    }

    private TargetBuilder.AuthProtocol getAuthPasswordEncryption(String authPasswordEncryption) {
        if (authPasswordEncryption == null) {
            return TargetBuilder.AuthProtocol.md5;
        }
        if ("1".equals(authPasswordEncryption)) {
            return TargetBuilder.AuthProtocol.sha1;
        }
        return TargetBuilder.AuthProtocol.md5;
    }

    private String getContextName(String contextName) {
        return contextName == null ? "" : contextName;
    }
}

