/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.push.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hertzbeat.common.entity.push.PushMetrics;
import org.apache.hertzbeat.common.entity.push.PushMetricsDto;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.push.dao.PushMetricsDao;
import org.apache.hertzbeat.push.dao.PushMonitorDao;
import org.apache.hertzbeat.push.service.PushService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushServiceImpl
implements PushService {
    private static final Logger log = LoggerFactory.getLogger(PushServiceImpl.class);
    @Autowired
    private PushMonitorDao monitorDao;
    @Autowired
    private PushMetricsDao metricsDao;
    private final Map<Long, Long> monitorIdCache = new HashMap<Long, Long>();
    private static final long cacheTimeout = 5000L;
    private final Map<Long, PushMetricsDto.Metrics> lastPushMetrics = new HashMap<Long, PushMetricsDto.Metrics>();
    private static final long deleteMetricsPeriod = 43200000L;
    private static final long deleteBeforeTime = 21600000L;

    public PushServiceImpl() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    PushServiceImpl.this.deletePeriodically();
                }
                catch (Exception e) {
                    log.error("periodical deletion failed. {}", (Object)e.getMessage());
                }
            }
        }, 1000L, 43200000L);
    }

    public void deletePeriodically() {
        this.metricsDao.deleteAllByTimeBefore(System.currentTimeMillis() - 21600000L);
    }

    @Override
    public void pushMetricsData(PushMetricsDto pushMetricsDto) throws RuntimeException {
        ArrayList<PushMetrics> pushMetricsList = new ArrayList<PushMetrics>();
        long curTime = System.currentTimeMillis();
        for (PushMetricsDto.Metrics metrics : pushMetricsDto.getMetricsList()) {
            long monitorId = metrics.getMonitorId();
            metrics.setTime(Long.valueOf(curTime));
            if (!this.monitorIdCache.containsKey(monitorId) || this.monitorIdCache.containsKey(monitorId) && curTime > this.monitorIdCache.get(monitorId) + 5000L) {
                Optional queryOption = this.monitorDao.findById(monitorId);
                if (queryOption.isEmpty()) {
                    this.monitorIdCache.remove(monitorId);
                    continue;
                }
                this.monitorIdCache.put(monitorId, curTime);
            }
            PushMetrics pushMetrics = PushMetrics.builder().monitorId(Long.valueOf(metrics.getMonitorId())).time(Long.valueOf(curTime)).metrics(JsonUtil.toJson((Object)metrics.getMetrics())).build();
            this.lastPushMetrics.put(monitorId, metrics);
            pushMetricsList.add(pushMetrics);
        }
        this.metricsDao.saveAll(pushMetricsList);
    }

    @Override
    public PushMetricsDto getPushMetricData(Long monitorId, Long time) {
        PushMetricsDto.Metrics metrics;
        PushMetricsDto pushMetricsDto = new PushMetricsDto();
        if (this.lastPushMetrics.containsKey(monitorId)) {
            metrics = this.lastPushMetrics.get(monitorId);
        } else {
            try {
                PushMetrics pushMetrics = this.metricsDao.findFirstByMonitorIdOrderByTimeDesc(monitorId);
                if (pushMetrics == null || pushMetrics.getMetrics() == null) {
                    return pushMetricsDto;
                }
                List jsonMap = (List)JsonUtil.fromJson((String)pushMetrics.getMetrics(), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
                metrics = PushMetricsDto.Metrics.builder().monitorId(monitorId.longValue()).metrics(jsonMap).time(pushMetrics.getTime()).build();
                this.lastPushMetrics.put(monitorId, metrics);
            }
            catch (Exception e) {
                log.error("no metrics found, monitor id: {}, {}", new Object[]{monitorId, e.getMessage(), e});
                return pushMetricsDto;
            }
        }
        if (time > metrics.getTime()) {
            return pushMetricsDto;
        }
        pushMetricsDto.getMetricsList().add(metrics);
        return pushMetricsDto;
    }
}

