/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.options;

import io.greptime.Router;
import io.greptime.common.Copiable;
import io.greptime.common.Endpoint;
import io.greptime.common.util.Ensures;
import io.greptime.limit.LimitedPolicy;
import io.greptime.models.AuthInfo;
import io.greptime.options.RouterOptions;
import io.greptime.options.WriteOptions;
import io.greptime.rpc.RpcOptions;
import io.greptime.rpc.TlsOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class GreptimeOptions
implements Copiable<GreptimeOptions> {
    private List<Endpoint> endpoints;
    private RpcOptions rpcOptions;
    private RouterOptions routerOptions;
    private WriteOptions writeOptions;
    private String database;

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public RpcOptions getRpcOptions() {
        return this.rpcOptions;
    }

    public void setRpcOptions(RpcOptions rpcOptions) {
        this.rpcOptions = rpcOptions;
    }

    public RouterOptions getRouterOptions() {
        return this.routerOptions;
    }

    public void setRouterOptions(RouterOptions routerOptions) {
        this.routerOptions = routerOptions;
    }

    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public void setWriteOptions(WriteOptions writeOptions) {
        this.writeOptions = writeOptions;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public GreptimeOptions copy() {
        GreptimeOptions opts = new GreptimeOptions();
        opts.endpoints = new ArrayList<Endpoint>(this.endpoints);
        opts.database = this.database;
        if (this.rpcOptions != null) {
            opts.rpcOptions = this.rpcOptions.copy();
        }
        if (this.routerOptions != null) {
            opts.routerOptions = this.routerOptions.copy();
        }
        if (this.writeOptions != null) {
            opts.writeOptions = this.writeOptions.copy();
        }
        return opts;
    }

    public String toString() {
        return "GreptimeOptions{endpoints=" + this.endpoints + ", rpcOptions=" + this.rpcOptions + ", routerOptions=" + this.routerOptions + ", writeOptions=" + this.writeOptions + ", database='" + this.database + '\'' + '}';
    }

    public static GreptimeOptions checkSelf(GreptimeOptions opts) {
        Ensures.ensureNonNull((Object)opts, (String)"null `opts (GreptimeOptions)`)`");
        Ensures.ensureNonNull(opts.getEndpoints(), (String)"null `endpoints`");
        Ensures.ensure((!opts.getEndpoints().isEmpty() ? 1 : 0) != 0, (Object)"empty `endpoints`");
        Ensures.ensureNonNull((Object)opts.getRpcOptions(), (String)"null `rpcOptions`");
        Ensures.ensureNonNull((Object)opts.getRouterOptions(), (String)"null `routerOptions`");
        Ensures.ensureNonNull((Object)opts.getWriteOptions(), (String)"null `writeOptions`");
        return opts;
    }

    public static Builder newBuilder(String endpoint, String database) {
        return GreptimeOptions.newBuilder(Endpoint.parse((String)endpoint), database);
    }

    public static Builder newBuilder(Endpoint endpoint, String database) {
        return new Builder(Collections.singletonList(endpoint), database);
    }

    public static Builder newBuilder(String[] endpoints, String database) {
        return new Builder(Arrays.stream(endpoints).map(Endpoint::parse).collect(Collectors.toList()), database);
    }

    public static Builder newBuilder(Endpoint[] endpoints, String database) {
        return new Builder(Arrays.asList(endpoints), database);
    }

    public static final class Builder {
        private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
        private final String database;
        private Executor asyncPool;
        private RpcOptions rpcOptions = RpcOptions.newDefault();
        private TlsOptions tlsOptions;
        private int writeMaxRetries = 1;
        private int maxInFlightWritePoints = 655360;
        private LimitedPolicy writeLimitedPolicy = LimitedPolicy.defaultWriteLimitedPolicy();
        private int defaultStreamMaxWritePointsPerSecond = 655360;
        private long routeTableRefreshPeriodSeconds = -1L;
        private AuthInfo authInfo;
        private Router<Void, Endpoint> router;

        public Builder(List<Endpoint> endpoints, String database) {
            this.endpoints.addAll(endpoints);
            this.database = database;
        }

        public Builder asyncPool(Executor asyncPool) {
            this.asyncPool = asyncPool;
            return this;
        }

        public Builder rpcOptions(RpcOptions rpcOptions) {
            this.rpcOptions = rpcOptions;
            return this;
        }

        public Builder tlsOptions(TlsOptions tlsOptions) {
            this.tlsOptions = tlsOptions;
            return this;
        }

        public Builder writeMaxRetries(int maxRetries) {
            this.writeMaxRetries = maxRetries;
            return this;
        }

        public Builder maxInFlightWritePoints(int maxInFlightWritePoints) {
            this.maxInFlightWritePoints = maxInFlightWritePoints;
            return this;
        }

        public Builder writeLimitedPolicy(LimitedPolicy writeLimitedPolicy) {
            this.writeLimitedPolicy = writeLimitedPolicy;
            return this;
        }

        public Builder defaultStreamMaxWritePointsPerSecond(int defaultStreamMaxWritePointsPerSecond) {
            this.defaultStreamMaxWritePointsPerSecond = defaultStreamMaxWritePointsPerSecond;
            return this;
        }

        public Builder routeTableRefreshPeriodSeconds(long routeTableRefreshPeriodSeconds) {
            this.routeTableRefreshPeriodSeconds = routeTableRefreshPeriodSeconds;
            return this;
        }

        public Builder authInfo(AuthInfo authInfo) {
            this.authInfo = authInfo;
            return this;
        }

        public Builder router(Router<Void, Endpoint> router) {
            this.router = router;
            return this;
        }

        public GreptimeOptions build() {
            if (this.tlsOptions != null && this.rpcOptions != null) {
                this.rpcOptions.setTlsOptions(this.tlsOptions);
            }
            GreptimeOptions opts = new GreptimeOptions();
            opts.setEndpoints(this.endpoints);
            opts.setRpcOptions(this.rpcOptions);
            opts.setDatabase(this.database);
            opts.setRouterOptions(this.routerOptions());
            opts.setWriteOptions(this.writeOptions());
            return GreptimeOptions.checkSelf(opts);
        }

        private RouterOptions routerOptions() {
            RouterOptions routerOpts = new RouterOptions();
            routerOpts.setEndpoints(this.endpoints);
            routerOpts.setRouter(this.router);
            routerOpts.setRefreshPeriodSeconds(this.routeTableRefreshPeriodSeconds);
            return routerOpts;
        }

        private WriteOptions writeOptions() {
            WriteOptions writeOpts = new WriteOptions();
            writeOpts.setDatabase(this.database);
            writeOpts.setAuthInfo(this.authInfo);
            writeOpts.setAsyncPool(this.asyncPool);
            writeOpts.setMaxRetries(this.writeMaxRetries);
            writeOpts.setMaxInFlightWritePoints(this.maxInFlightWritePoints);
            writeOpts.setLimitedPolicy(this.writeLimitedPolicy);
            writeOpts.setDefaultStreamMaxWritePointsPerSecond(this.defaultStreamMaxWritePointsPerSecond);
            return writeOpts;
        }
    }
}

