/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.util.concurrent.RateLimiter;
import io.greptime.RouterClient;
import io.greptime.Status;
import io.greptime.StreamWriter;
import io.greptime.Util;
import io.greptime.Write;
import io.greptime.WriteOp;
import io.greptime.common.Display;
import io.greptime.common.Endpoint;
import io.greptime.common.Lifecycle;
import io.greptime.common.util.Clock;
import io.greptime.common.util.Ensures;
import io.greptime.common.util.MetricExecutor;
import io.greptime.common.util.MetricsUtil;
import io.greptime.common.util.SerializingExecutor;
import io.greptime.errors.LimitedException;
import io.greptime.errors.ServerException;
import io.greptime.errors.StreamException;
import io.greptime.limit.AbstractLimiter;
import io.greptime.limit.LimitedPolicy;
import io.greptime.limit.WriteLimiter;
import io.greptime.models.AuthInfo;
import io.greptime.models.Err;
import io.greptime.models.Result;
import io.greptime.models.Table;
import io.greptime.models.TableHelper;
import io.greptime.models.WriteOk;
import io.greptime.models.WriteTables;
import io.greptime.options.WriteOptions;
import io.greptime.rpc.Context;
import io.greptime.rpc.Observer;
import io.greptime.v1.Common;
import io.greptime.v1.Database;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteClient
implements Write,
Lifecycle<WriteOptions>,
Display {
    private static final Logger LOG = LoggerFactory.getLogger(WriteClient.class);
    private WriteOptions opts;
    private RouterClient routerClient;
    private Executor asyncPool;
    private WriteLimiter writeLimiter;

    public boolean init(WriteOptions opts) {
        this.opts = (WriteOptions)Ensures.ensureNonNull((Object)opts, (String)"null `WriteClient.opts`");
        this.routerClient = this.opts.getRouterClient();
        Executor pool = this.opts.getAsyncPool();
        this.asyncPool = pool != null ? pool : new SerializingExecutor("write_client");
        this.asyncPool = new MetricExecutor(this.asyncPool, "async_write_pool.time");
        this.writeLimiter = new DefaultWriteLimiter(this.opts.getMaxInFlightWritePoints(), this.opts.getLimitedPolicy());
        return true;
    }

    public void shutdownGracefully() {
    }

    @Override
    public CompletableFuture<Result<WriteOk, Err>> write(Collection<Table> tables, WriteOp writeOp, Context ctx) {
        Ensures.ensureNonNull(tables, (String)"null `tables`");
        Ensures.ensure((!tables.isEmpty() ? 1 : 0) != 0, (Object)"empty `tables`");
        long startCall = Clock.defaultClock().getTick();
        WriteTables writeTables = new WriteTables(tables, writeOp);
        return this.writeLimiter.acquireAndDo(tables, () -> this.write0(writeTables, ctx, 0).whenCompleteAsync((r, e) -> {
            InnerMetricHelper.writeQps().mark();
            if (r != null) {
                if (Util.isRwLogging()) {
                    LOG.info("Write to {} with operation {}, duration={} ms, result={}.", new Object[]{"GreptimeDB", writeOp, Clock.defaultClock().duration(startCall), r});
                }
                if (r.isOk()) {
                    WriteOk ok = (WriteOk)r.getOk();
                    InnerMetricHelper.writeRowsSuccessNum(writeOp).update(ok.getSuccess());
                    InnerMetricHelper.writeRowsFailureNum(writeOp).update(ok.getFailure());
                    return;
                }
            }
            InnerMetricHelper.writeFailureNum().mark();
        }, this.asyncPool));
    }

    @Override
    public StreamWriter<Table, WriteOk> streamWriter(int maxPointsPerSecond, Context ctx) {
        int permitsPerSecond = maxPointsPerSecond > 0 ? maxPointsPerSecond : this.opts.getDefaultStreamMaxWritePointsPerSecond();
        final CompletableFuture respFuture = new CompletableFuture();
        return (StreamWriter)((CompletableFuture)((CompletableFuture)this.routerClient.route().thenApply(endpoint -> this.streamWriteTo((Endpoint)endpoint, ctx, (Observer<WriteOk>)Util.toObserver(respFuture)))).thenApply(reqObserver -> new RateLimitingStreamWriter((Observer)reqObserver, permitsPerSecond, (Observer)reqObserver){
            final /* synthetic */ Observer val$reqObserver;
            {
                this.val$reqObserver = observer2;
                super((Observer<WriteTables>)observer, permitsPerSecond);
            }

            @Override
            public StreamWriter<Table, WriteOk> write(Table table, WriteOp writeOp) {
                if (respFuture.isCompletedExceptionally()) {
                    respFuture.getNow(null);
                }
                return super.write(table, writeOp);
            }

            @Override
            public CompletableFuture<WriteOk> completed() {
                this.val$reqObserver.onCompleted();
                return respFuture;
            }
        })).join();
    }

    private CompletableFuture<Result<WriteOk, Err>> write0(WriteTables writeTables, Context ctx, int retries) {
        InnerMetricHelper.writeByRetries(retries).mark();
        return ((CompletableFuture)this.routerClient.route().thenComposeAsync(endpoint -> this.writeTo((Endpoint)endpoint, writeTables, ctx, retries), this.asyncPool)).thenComposeAsync(r -> {
            if (r.isOk()) {
                LOG.debug("Success to write to {}, ok={}.", (Object)"GreptimeDB", r.getOk());
                return Util.completedCf(r);
            }
            Err err = (Err)r.getErr();
            LOG.warn("Failed to write to {}, retries={}, err={}.", new Object[]{"GreptimeDB", retries, err});
            if (retries + 1 > this.opts.getMaxRetries()) {
                LOG.error("Retried {} times still failed.", (Object)retries);
                return Util.completedCf(r);
            }
            if (Util.shouldNotRetry(err)) {
                return Util.completedCf(r);
            }
            return this.write0(writeTables, ctx, retries + 1);
        }, this.asyncPool);
    }

    private CompletableFuture<Result<WriteOk, Err>> writeTo(Endpoint endpoint, WriteTables writeTables, Context ctx, int retries) {
        String database = this.opts.getDatabase();
        AuthInfo authInfo = this.opts.getAuthInfo();
        Database.GreptimeRequest req = TableHelper.toGreptimeRequest(writeTables, database, authInfo);
        ctx.with("retries", (Object)retries);
        CompletableFuture future = this.routerClient.invoke(endpoint, req, ctx);
        return future.thenApplyAsync(resp -> {
            Common.ResponseHeader header = resp.getHeader();
            Common.Status status = header.getStatus();
            int statusCode = status.getStatusCode();
            if (Status.isSuccess(statusCode)) {
                int affectedRows = resp.getAffectedRows().getValue();
                return WriteOk.ok(affectedRows, 0).mapToResult();
            }
            return Err.writeErr(statusCode, new ServerException(status.getErrMsg()), endpoint).mapToResult();
        }, this.asyncPool);
    }

    private Observer<WriteTables> streamWriteTo(Endpoint endpoint, Context ctx, final Observer<WriteOk> respObserver) {
        final Observer<Database.GreptimeRequest> rpcObserver = this.routerClient.invokeClientStreaming(endpoint, Database.GreptimeRequest.getDefaultInstance(), ctx, new Observer<Database.GreptimeResponse>(){

            public void onNext(Database.GreptimeResponse resp) {
                int affectedRows = resp.getAffectedRows().getValue();
                Result<WriteOk, Err> ret = WriteOk.ok(affectedRows, 0).mapToResult();
                if (ret.isOk()) {
                    respObserver.onNext((Object)ret.getOk());
                } else {
                    respObserver.onError((Throwable)new StreamException(String.valueOf(ret.getErr())));
                }
            }

            public void onError(Throwable err) {
                respObserver.onError(err);
            }

            public void onCompleted() {
                respObserver.onCompleted();
            }
        });
        final String database = this.opts.getDatabase();
        final AuthInfo authInfo = this.opts.getAuthInfo();
        return new Observer<WriteTables>(){

            public void onNext(WriteTables writeTables) {
                Database.GreptimeRequest req = TableHelper.toGreptimeRequest(writeTables, database, authInfo);
                rpcObserver.onNext((Object)req);
            }

            public void onError(Throwable err) {
                rpcObserver.onError(err);
            }

            public void onCompleted() {
                rpcObserver.onCompleted();
            }
        };
    }

    public void display(Display.Printer out) {
        out.println((Object)"--- WriteClient ---").print((Object)"maxRetries=").println((Object)this.opts.getMaxRetries()).print((Object)"asyncPool=").println((Object)this.asyncPool);
    }

    public String toString() {
        return "WriteClient{opts=" + this.opts + ", routerClient=" + this.routerClient + ", asyncPool=" + this.asyncPool + '}';
    }

    static abstract class RateLimitingStreamWriter
    implements StreamWriter<Table, WriteOk> {
        private final Observer<WriteTables> observer;
        private final RateLimiter rateLimiter;

        RateLimitingStreamWriter(Observer<WriteTables> observer, double permitsPerSecond) {
            this.observer = observer;
            this.rateLimiter = permitsPerSecond > 0.0 ? RateLimiter.create((double)permitsPerSecond) : null;
        }

        @Override
        public StreamWriter<Table, WriteOk> write(Table table, WriteOp writeOp) {
            Ensures.ensureNonNull((Object)table, (String)"null `table`");
            int permits = table.pointCount();
            if (this.rateLimiter != null && permits > 0) {
                double millisToWait = this.rateLimiter.acquire(permits) * 1000.0;
                InnerMetricHelper.writeStreamLimiterAcquireWaitTime().update((long)millisToWait, TimeUnit.MILLISECONDS);
            }
            this.observer.onNext((Object)new WriteTables(table, writeOp));
            return this;
        }
    }

    static class DefaultWriteLimiter
    extends WriteLimiter {
        public DefaultWriteLimiter(int maxInFlight, LimitedPolicy policy) {
            super(maxInFlight, policy, "write_limiter_acquire");
        }

        @Override
        public int calculatePermits(Collection<Table> in) {
            return in.stream().map(Table::pointCount).reduce(0, Integer::sum);
        }

        @Override
        public Result<WriteOk, Err> rejected(Collection<Table> in, AbstractLimiter.RejectedState state) {
            String errMsg = String.format("Write limited by client, acquirePermits=%d, maxPermits=%d, availablePermits=%d.", state.acquirePermits(), state.maxPermits(), state.availablePermits());
            return Result.err(Err.writeErr(503, new LimitedException(errMsg), null));
        }
    }

    static final class InnerMetricHelper {
        static final Histogram INSERT_ROWS_SUCCESS_NUM = MetricsUtil.histogram((Object)"insert_rows_success_num");
        static final Histogram DELETE_ROWS_SUCCESS_NUM = MetricsUtil.histogram((Object)"delete_rows_success_num");
        static final Histogram INSERT_ROWS_FAILURE_NUM = MetricsUtil.histogram((Object)"insert_rows_failure_num");
        static final Histogram DELETE_ROWS_FAILURE_NUM = MetricsUtil.histogram((Object)"delete_rows_failure_num");
        static final Timer WRITE_STREAM_LIMITER_ACQUIRE_WAIT_TIME = MetricsUtil.timer((Object)"write_stream_limiter_acquire_wait_time");
        static final Meter WRITE_FAILURE_NUM = MetricsUtil.meter((Object)"write_failure_num");
        static final Meter WRITE_QPS = MetricsUtil.meter((Object)"write_qps");

        InnerMetricHelper() {
        }

        static Histogram writeRowsSuccessNum(WriteOp writeOp) {
            switch (writeOp) {
                case Insert: {
                    return INSERT_ROWS_SUCCESS_NUM;
                }
                case Delete: {
                    return DELETE_ROWS_SUCCESS_NUM;
                }
            }
            throw new IllegalArgumentException("Unsupported write operation: " + (Object)((Object)writeOp));
        }

        static Histogram writeRowsFailureNum(WriteOp writeOp) {
            switch (writeOp) {
                case Insert: {
                    return INSERT_ROWS_FAILURE_NUM;
                }
                case Delete: {
                    return DELETE_ROWS_FAILURE_NUM;
                }
            }
            throw new IllegalArgumentException("Unsupported write operation: " + (Object)((Object)writeOp));
        }

        static Timer writeStreamLimiterAcquireWaitTime() {
            return WRITE_STREAM_LIMITER_ACQUIRE_WAIT_TIME;
        }

        static Meter writeFailureNum() {
            return WRITE_FAILURE_NUM;
        }

        static Meter writeQps() {
            return WRITE_QPS;
        }

        static Meter writeByRetries(int retries) {
            return MetricsUtil.meter((Object[])new Object[]{"write_by_retries", Math.min(3, retries)});
        }
    }
}

