/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import com.google.protobuf.Message;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.ProtoJsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="redis")
public class RedisCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RedisCommonDataQueue.class);
    private final RedisClient redisClient;
    private final StatefulRedisConnection<String, String> connection;
    private final RedisCommands<String, String> syncCommands;
    private final String metricsDataQueueNameToAlerter;
    private final String metricsDataQueueNameToPersistentStorage;
    private final String metricsDataQueueNameToRealTimeStorage;
    private final String alertsDataQueueName;
    private final CommonProperties.RedisProperties redisProperties;

    public RedisCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getRedis() == null) {
            log.error("init error, please config common.queue.redis props in application.yml");
            throw new IllegalArgumentException("please config common.queue.redis props");
        }
        this.redisProperties = properties.getQueue().getRedis();
        this.redisClient = RedisClient.create((RedisURI)RedisURI.builder().withHost(this.redisProperties.getRedisHost()).withPort(this.redisProperties.getRedisPort()).build());
        this.connection = this.redisClient.connect();
        this.syncCommands = this.connection.sync();
        this.metricsDataQueueNameToAlerter = this.redisProperties.getMetricsDataQueueNameToAlerter();
        this.metricsDataQueueNameToPersistentStorage = this.redisProperties.getMetricsDataQueueNameToPersistentStorage();
        this.metricsDataQueueNameToRealTimeStorage = this.redisProperties.getMetricsDataQueueNameToRealTimeStorage();
        this.alertsDataQueueName = this.redisProperties.getAlertsDataQueueName();
    }

    @Override
    public Alert pollAlertsData() {
        try {
            String alertJson = (String)this.syncCommands.rpop((Object)this.alertsDataQueueName);
            if (alertJson != null) {
                return JsonUtil.fromJson(alertJson, Alert.class);
            }
        }
        catch (Exception e) {
            log.error("please config common.queue.redis props correctly", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() {
        try {
            String metricsDataJson = (String)this.syncCommands.rpop((Object)this.metricsDataQueueNameToAlerter);
            if (metricsDataJson != null) {
                return (CollectRep.MetricsData)ProtoJsonUtil.toProtobuf(metricsDataJson, (Message.Builder)CollectRep.MetricsData.newBuilder());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToPersistentStorage() throws InterruptedException {
        try {
            String metricsDataJson = (String)this.syncCommands.rpop((Object)this.metricsDataQueueNameToPersistentStorage);
            if (metricsDataJson != null) {
                return JsonUtil.fromJson(metricsDataJson, CollectRep.MetricsData.class);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToRealTimeStorage() throws InterruptedException {
        try {
            String metricsDataJson = (String)this.syncCommands.rpop((Object)this.metricsDataQueueNameToRealTimeStorage);
            if (metricsDataJson != null) {
                return JsonUtil.fromJson(metricsDataJson, CollectRep.MetricsData.class);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void sendAlertsData(Alert alert) {
        try {
            String alertJson = JsonUtil.toJson(alert);
            this.syncCommands.lpush((Object)this.alertsDataQueueName, (Object[])new String[]{alertJson});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        try {
            String metricsDataJson = ProtoJsonUtil.toJsonStr((Message)metricsData);
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToAlerter, (Object[])new String[]{metricsDataJson});
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToPersistentStorage, (Object[])new String[]{metricsDataJson});
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToRealTimeStorage, (Object[])new String[]{metricsDataJson});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.connection.close();
        this.redisClient.shutdown();
    }
}

